/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.cmd;

import de.uni_hildesheim.sse.easy.loader.ListLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.standalone.cmd.InstantiationCommands;
import net.ssehub.easy.standalone.cmd.ModelLoadDefinition;
import net.ssehub.easy.standalone.cmd.ReasoningCommands;

public class CommandLineExecuter {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(CommandLineExecuter.class, "EASyCommandLine");
    private static final List<String> OPTIONS = new ArrayList<String>();
    private static final String OPT_RESULTFILE = "--resultFile";

    public static void main(String[] args) {
        int result = 0;
        try {
            ListLoader loader = new ListLoader();
            loader.startup();
            if (null != args && args.length > 1) {
                HashMap<String, String> options = new HashMap<String, String>();
                if ("instantiateSelf".equals((args = CommandLineExecuter.pruneArguments(args, options))[0])) {
                    result = CommandLineExecuter.instantiateSelf(args, options);
                } else if ("instantiate".equals(args[0])) {
                    result = CommandLineExecuter.instantiate(args, options);
                } else if ("checkValidity".equals(args[0])) {
                    result = CommandLineExecuter.checkValidity(args, options);
                }
            }
            loader.shutdown();
        }
        catch (IOException e) {
            LOGGER.exception((Exception)e);
            result = 1;
        }
        System.exit(result);
    }

    private static int instantiateSelf(String[] args, Map<String, String> options) {
        int result = 0;
        try {
            File project = new File(args[1]);
            switch (args.length) {
                case 2: {
                    InstantiationCommands.instantiateSelf(project);
                    break;
                }
                case 3: {
                    File ivmlFile1 = new File(args[2]);
                    InstantiationCommands.instantiateSelf(project, ivmlFile1);
                    break;
                }
                case 4: {
                    File ivmlFile2 = new File(args[2]);
                    File vilFile = new File(args[3]);
                    InstantiationCommands.instantiateSelf(project, ivmlFile2, vilFile);
                    break;
                }
                default: {
                    LOGGER.warn("Unspecified combination of arguments passed. # Arguments = " + args.length);
                    break;
                }
            }
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 2;
        }
        catch (VilException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 4;
        }
        catch (PersistenceException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 3;
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.exception((Exception)e);
            result = 8;
        }
        return result;
    }

    private static int instantiate(String[] args, Map<String, String> options) {
        int result = 0;
        try {
            File projectSRC = new File(args[1]);
            File projectTRG = new File(args[2]);
            switch (args.length) {
                case 3: {
                    InstantiationCommands.instantiate(projectSRC, projectTRG);
                    break;
                }
                case 5: {
                    File ivmlFile = new File(args[3]);
                    File vilFile = new File(args[4]);
                    InstantiationCommands.instantiate(projectSRC, projectTRG, ivmlFile, vilFile);
                    break;
                }
                case 7: {
                    ModelLoadDefinition ivmlDef = new ModelLoadDefinition(args[3], args[4]);
                    ModelLoadDefinition vilDef = new ModelLoadDefinition(args[5], args[6]);
                    InstantiationCommands.instantiate(projectSRC, projectTRG, ivmlDef, vilDef);
                    break;
                }
                default: {
                    LOGGER.warn("Unspecified combination of arguments passed. # Arguments = " + args.length);
                    break;
                }
            }
        }
        catch (VilException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 4;
        }
        catch (PersistenceException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 3;
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 2;
        }
        catch (SecurityException e) {
            LOGGER.exception((Exception)e);
            result = 7;
        }
        catch (IOException e) {
            LOGGER.exception((Exception)e);
            result = 1;
        }
        catch (NullPointerException e) {
            LOGGER.exception((Exception)e);
            result = 6;
        }
        catch (VersionFormatException e) {
            LOGGER.exception((Exception)((Object)e));
            result = 5;
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.exception((Exception)e);
            result = 8;
        }
        return result;
    }

    private static boolean checkForOption(String arg, Map<String, String> options) {
        String optName = null;
        String optValue = null;
        for (int o = 0; null == optName && o < OPTIONS.size(); ++o) {
            String argName = OPTIONS.get(o);
            if (arg.equals(argName)) {
                optName = argName;
            } else if (arg.startsWith(argName + "=") && arg.length() > argName.length() + 1) {
                optName = argName;
                optValue = arg.substring(argName.length() + 1);
            }
            if (null == options || null == optName) continue;
            options.put(optName, optValue);
        }
        return null != optName;
    }

    private static String[] pruneArguments(String[] args, Map<String, String> options) {
        ArrayList<String> tmpArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (CommandLineExecuter.checkForOption(arg, options)) continue;
            tmpArgs.add(arg);
        }
        args = new String[tmpArgs.size()];
        return tmpArgs.toArray(args);
    }

    private static int checkValidity(String[] args, Map<String, String> options) {
        int cmdResult = 0;
        Boolean result = null;
        try {
            File project = new File(args[1]);
            switch (args.length) {
                case 2: {
                    result = ReasoningCommands.checkValidity(project);
                    break;
                }
                case 3: {
                    File ivmlFile = new File(args[2]);
                    result = ReasoningCommands.checkValidity(project, ivmlFile);
                    break;
                }
                case 4: {
                    ModelLoadDefinition ivmlDef = new ModelLoadDefinition(args[2], args[3]);
                    result = ReasoningCommands.checkValidity(project, ivmlDef);
                    break;
                }
                default: {
                    LOGGER.warn("Unspecified combination of arguments passed. # Arguments = " + args.length);
                }
            }
            if (null != result) {
                File file;
                String path = options.get(OPT_RESULTFILE);
                if (null == path) {
                    file = new File(project, ".result");
                } else {
                    file = new File(path);
                    if (file.isDirectory()) {
                        file = new File(file, ".result");
                    }
                }
                PrintStream out = new PrintStream(new FileOutputStream(file));
                out.println(result);
                out.flush();
                out.close();
            }
        }
        catch (VersionFormatException e) {
            LOGGER.exception((Exception)((Object)e));
            cmdResult = 5;
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
            cmdResult = 2;
        }
        catch (IOException e) {
            LOGGER.exception((Exception)e);
            cmdResult = 1;
        }
        catch (PersistenceException e) {
            LOGGER.exception((Exception)((Object)e));
            cmdResult = 3;
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.exception((Exception)e);
            cmdResult = 8;
        }
        return cmdResult;
    }

    static {
        OPTIONS.add(OPT_RESULTFILE);
    }
}

