/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.cmd;

import de.uni_hildesheim.sse.easy.loader.ListLoader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.eclipse.persistency.EASyPersistencer;

public class LowlevelCommands {
    private LowlevelCommands() {
    }

    public static void loadProject(File projectFolder) throws PersistenceException {
        EASyPersistencer persistencer = new EASyPersistencer(projectFolder);
        persistencer.load();
    }

    public static void loadWorkspace(File wsFolder) {
        File[] folders = wsFolder.listFiles();
        if (null != folders) {
            for (File folder : folders) {
                if (folder.getName().equalsIgnoreCase(".metadata")) continue;
                try {
                    LowlevelCommands.loadProject(folder);
                }
                catch (PersistenceException persistenceException) {
                    // empty catch block
                }
            }
        }
    }

    public static PLPInfo getProject(String projectName) {
        Collection infos = SPLsManager.INSTANCE.getProductLineProjects().values();
        PLPInfo plp = null;
        for (PLPInfo plpInfo : infos) {
            if (!plpInfo.getProjectName().equalsIgnoreCase(projectName)) continue;
            plp = plpInfo;
            break;
        }
        return plp;
    }

    public static void startEASy() throws IOException {
        ListLoader loader = new ListLoader();
        loader.startup();
    }
}

