/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.cmd;

import java.io.File;
import java.io.IOException;
import net.ssehub.easy.producer.core.contributions.Contributions;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.standard.NatureHelper;

public class ProjectCommands {
    private static final String XTEXT_NATURE_ID = "org.eclipse.xtext.ui.shared.xtextNature";

    public static void toggleEasyNature(File project, String ... classpath) throws IOException, IllegalArgumentException {
        ProjectCommands.checkFolder(project, "project");
        if (!NatureHelper.hasNature((File)project, (String[])new String[]{"de.uni_hildesheim.sse.EASy-Producer"})) {
            if (!NatureHelper.hasNature((File)project, (String[])new String[]{XTEXT_NATURE_ID})) {
                NatureHelper.addNature((File)project, (String)XTEXT_NATURE_ID);
            }
            NatureHelper.addNature((File)project, (String)"de.uni_hildesheim.sse.EASy-Producer");
            Contributions.updateDependencies((File)project, (String[])classpath);
        } else {
            NatureHelper.removeNature((File)project, (String)"de.uni_hildesheim.sse.EASy-Producer");
        }
    }

    public static void updateDependencies(File project, String ... classpath) throws IOException {
        ProjectCommands.checkFolder(project, "project");
        Contributions.updateDependencies((File)project, (String[])classpath);
    }

    private static final void checkFolder(File file, String name) throws IllegalArgumentException {
        if (null == file) {
            throw new IllegalArgumentException(name + " must be given (not null)");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(name + " must exist (" + file + ")");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(name + " must be a folder/directory (" + file + ")");
        }
    }

    public static void setConfigLocation(File project, File ivmlFolder, File vilFolder) throws IOException, IllegalArgumentException {
        ProjectCommands.setConfigLocation(project, ivmlFolder, vilFolder, vilFolder);
    }

    public static void setConfigLocation(File project, File ivmlFolder, File vilFolder, File vtlFolder) throws IOException, IllegalArgumentException {
        ProjectCommands.checkFolder(project, "project");
        ProjectCommands.checkFolder(ivmlFolder, "ivmlFolder");
        ProjectCommands.checkFolder(vilFolder, "vilFolder");
        ProjectCommands.checkFolder(vilFolder, "vtlFolder");
        Configuration config = PersistenceUtils.getConfiguration((File)project);
        config.setPath(Configuration.PathKind.IVML, ivmlFolder);
        config.setPath(Configuration.PathKind.VIL, vilFolder);
        config.setPath(Configuration.PathKind.VTL, vtlFolder);
        config.store();
    }
}

