/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse;

import com.google.inject.Guice;
import com.google.inject.Module;
import de.uni_hildesheim.sse.VilBuildLanguageRuntimeModule;
import de.uni_hildesheim.sse.VilBuildLanguageStandaloneSetup;
import de.uni_hildesheim.sse.buildLanguageTranslation.ExpressionTranslator;
import de.uni_hildesheim.sse.buildLanguageTranslation.ModelTranslator;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Import;
import de.uni_hildesheim.sse.vilBuildLanguage.ImplementationUnit;
import de.uni_hildesheim.sse.vilBuildLanguage.LanguageUnit;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.dslCore.ModelUtility;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangWriter;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Resolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

public class BuildLangModelUtility
extends ModelUtility<ImplementationUnit, Script>
implements IModelLoader<Script> {
    public static final BuildLangModelUtility INSTANCE = new BuildLangModelUtility();

    private BuildLangModelUtility() {
    }

    public TranslationResult<Script> createBuildModel(ImplementationUnit root, java.net.URI uri, boolean registerSuccessful) {
        ModelTranslator translator = new ModelTranslator();
        return new TranslationResult<Script>(translator.createModel(root, uri, registerSuccessful, null), translator);
    }

    @Override
    protected void initializeAfterResourceInitializer() {
        if (BuildLangModelUtility.getResourceInitializer().forEclipse()) {
            this.setInjector(Guice.createInjector((Module[])new Module[]{new VilBuildLanguageRuntimeModule()}));
        } else {
            this.setInjector(new VilBuildLanguageStandaloneSetup().createInjectorAndDoEMFRegistration());
        }
    }

    @Override
    public TranslationResult<Script> parse(URI uri, ImportResolver<Script> resolver) throws IOException {
        ModelTranslator translator = new ModelTranslator();
        ImplementationUnit root = this.parse(uri, true, translator, ImplementationUnit.class);
        List<Script> result = null;
        if (null != root) {
            try {
                result = translator.createModel(root, BuildLangModelUtility.toNetUri(uri), true, resolver);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return new TranslationResult<Script>(result, translator);
    }

    public void print(TranslationResult<Script> result, Writer out, boolean emitComments, boolean emitImports) {
        try {
            BuildlangWriter writer = new BuildlangWriter(out);
            for (int p = 0; p < result.getResultCount(); ++p) {
                try {
                    result.getResult(p).accept(writer);
                    continue;
                }
                catch (VilException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(BuildLangModelUtility.class, "de.uni_hildesheim.sse.vil.buildlang");
                }
            }
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected String getLanguageName() {
        return "de.uni_hildesheim.sse.VilBuildLanguage";
    }

    @Override
    protected ClassLoader getLanguageClassLoader() {
        return BuildLangModelUtility.class.getClassLoader();
    }

    public net.ssehub.easy.instantiation.core.model.expressions.Expression createExpression(String text, Resolver resolver, StringBuilder warnings) throws VilException {
        net.ssehub.easy.instantiation.core.model.expressions.Expression result;
        block9: {
            result = null;
            IParseResult parseResult = this.parseFragment("Expression", text);
            if (null != parseResult) {
                StringBuilder errors = new StringBuilder();
                for (INode error : parseResult.getSyntaxErrors()) {
                    BuildLangModelUtility.appendWithNewLine(errors, error.getText());
                }
                if (0 == errors.length() && null == parseResult.getRootASTElement()) {
                    BuildLangModelUtility.appendWithNewLine(errors, "empty expression");
                }
                if (0 == errors.length()) {
                    ExpressionTranslator translator = new ExpressionTranslator();
                    Expression expr = (Expression)parseResult.getRootASTElement();
                    translator.enactIvmlWarnings();
                    try {
                        result = translator.processExpression(expr, resolver);
                        for (int i = 0; i < translator.getMessageCount(); ++i) {
                            Message msg = translator.getMessage(i);
                            if (Status.ERROR == msg.getStatus()) {
                                BuildLangModelUtility.appendWithNewLine(errors, msg.getDescription());
                                continue;
                            }
                            if (null == warnings) continue;
                            BuildLangModelUtility.appendWithNewLine(warnings, msg.getDescription());
                        }
                        if (translator.getErrorCount() > 0) {
                            throw new VilException(errors.toString(), 70000);
                        }
                        break block9;
                    }
                    catch (TranslatorException e) {
                        throw new VilException(e, e.getId());
                    }
                }
                throw new VilException(errors.toString() + " in expression '" + text + "'", 30003);
            }
        }
        return result;
    }

    public net.ssehub.easy.instantiation.core.model.expressions.Expression createExpression(String text, IRuntimeEnvironment environment) throws VilException {
        return this.createExpression(text, new Resolver(environment), null);
    }

    @Override
    public String getExtension() {
        return "vil";
    }

    @Override
    public List<ModelInfo<Script>> obtainInfo(URI uri) throws IOException {
        ImplementationUnit root = this.parse(uri, true, null, ImplementationUnit.class);
        ArrayList<ModelInfo<Script>> result = new ArrayList<ModelInfo<Script>>();
        if (null != root) {
            for (LanguageUnit script : root.getScripts()) {
                Version version = ModelTranslator.convert(script.getVersion());
                ArrayList imports = new ArrayList();
                for (Import imp : script.getImports()) {
                    String name = imp.getName();
                    imports.add(new ModelImport(name, false, null));
                }
                try {
                    result.add(new ModelInfo<Script>(script.getName(), version, this, BuildLangModelUtility.toNetUri(uri), imports));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
        }
        return result;
    }
}

