/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.buildLanguageTranslation;

import de.uni_hildesheim.sse.BuildLangModelUtility;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Call;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.NamedArgument;
import de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator;
import de.uni_hildesheim.sse.vilBuildLanguage.Alternative;
import de.uni_hildesheim.sse.vilBuildLanguage.For;
import de.uni_hildesheim.sse.vilBuildLanguage.Instantiate;
import de.uni_hildesheim.sse.vilBuildLanguage.Join;
import de.uni_hildesheim.sse.vilBuildLanguage.JoinVariable;
import de.uni_hildesheim.sse.vilBuildLanguage.LoopVariable;
import de.uni_hildesheim.sse.vilBuildLanguage.Map;
import de.uni_hildesheim.sse.vilBuildLanguage.PrimaryExpression;
import de.uni_hildesheim.sse.vilBuildLanguage.RuleElement;
import de.uni_hildesheim.sse.vilBuildLanguage.RuleElementBlock;
import de.uni_hildesheim.sse.vilBuildLanguage.StatementOrBlock;
import de.uni_hildesheim.sse.vilBuildLanguage.SystemExecution;
import de.uni_hildesheim.sse.vilBuildLanguage.VilBuildLanguagePackage;
import de.uni_hildesheim.sse.vilBuildLanguage.While;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.dslCore.translation.MessageHandler;
import net.ssehub.easy.dslCore.translation.StringUtils;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AlternativeExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionVersionRestriction;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ForStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ImplicitVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.InstantiateExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.MapExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.NestedRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Resolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.SimpleStatementBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.StrategyCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.WhileStatement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestrictionValidator;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ExpressionTranslator
extends de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator<VariableDeclaration, Resolver, ExpressionStatement> {
    @Override
    public Expression processPrimaryExpression(de.uni_hildesheim.sse.vil.expressions.expressionDsl.PrimaryExpression ex, Resolver resolver) throws TranslatorException {
        Expression result = null;
        if (ex != null) {
            result = super.processPrimaryExpression(ex, resolver);
            PrimaryExpression pEx = (PrimaryExpression)ex;
            SystemExecution systemEx = pEx.getSysEx();
            if (null != systemEx) {
                result = this.processCall((Expression)null, systemEx.getCall(), ExpressionTranslator.CallType.SYSTEM, (de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression)null, resolver);
                result = this.processSubCalls(result, systemEx.getCalls(), resolver);
            }
            if (null != pEx.getJoin()) {
                result = this.processJoin(pEx.getJoin(), resolver);
            }
            if (null != pEx.getMap()) {
                result = this.processMap(pEx.getMap(), resolver);
            }
            if (null != pEx.getInstantiate()) {
                result = this.processInstantiate(pEx.getInstantiate(), resolver);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InstantiateExpression processInstantiate(Instantiate inst, Resolver resolver) throws TranslatorException {
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>();
        if (null != inst.getParam()) {
            for (NamedArgument param : inst.getParam().getParam()) {
                arguments.add(new CallArgument(param.getName(), this.processExpression(param.getEx(), resolver)));
            }
        }
        CallArgument[] args = new CallArgument[arguments.size()];
        arguments.toArray(args);
        VariableDeclaration var = null;
        if (null != inst.getProject()) {
            var = (VariableDeclaration)resolver.resolve(inst.getProject(), false, inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PROJECT, this);
            if (null == var) throw new TranslatorException("cannot resolve " + inst.getProject(), inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PROJECT, 70002);
            if (!IvmlTypes.projectType().isAssignableFrom(var.getType())) {
                throw new TranslatorException(inst.getProject() + " is not of type Project", inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PROJECT, 20203);
            }
        } else if (0 == StringUtils.convertString(inst.getRuleName()).length()) {
            throw new TranslatorException("the rule name must not be empty", inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PROJECT, 20207);
        }
        try {
            if (null == inst.getProject()) return new InstantiateExpression(StringUtils.convertString(inst.getRuleName()), args);
            IVersionRestriction vRestrict = null;
            if (null == inst.getVersionSpec()) return new InstantiateExpression(var, vRestrict, null, args);
            this.warnVersionRestrictions(inst.getVersionSpec());
            vRestrict = this.processRestriction(inst.getProject(), inst.getVersionSpec(), resolver);
            return new InstantiateExpression(var, vRestrict, null, args);
        }
        catch (VilException e) {
            throw new TranslatorException(e, inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PARAM);
        }
    }

    private AlternativeExpression processAlternative(Alternative alt, Resolver resolver) throws TranslatorException {
        try {
            Expression cond = this.processExpression(alt.getExpr(), resolver);
            cond = this.assertBooleanExpression(cond, alt, (EStructuralFeature)VilBuildLanguagePackage.Literals.ALTERNATIVE__EXPR);
            resolver.pushLevel();
            IRuleBlock ifBlock = this.resolveStatementOrBlock(alt.getIf(), resolver);
            resolver.popLevel();
            resolver.pushLevel();
            IRuleBlock elseBlock = this.resolveStatementOrBlock(alt.getElse(), resolver);
            resolver.popLevel();
            return new AlternativeExpression(cond, ifBlock, elseBlock);
        }
        catch (VilException e) {
            throw new TranslatorException(e, alt, (EStructuralFeature)VilBuildLanguagePackage.Literals.ALTERNATIVE__IF);
        }
    }

    private WhileStatement processWhileStatement(While stmt, Resolver resolver) throws TranslatorException {
        Expression expr = this.processExpression(stmt.getExpr(), resolver);
        expr = this.assertBooleanExpression(expr, stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__EXPR);
        resolver.pushLevel();
        IRuleElement[] block = this.resolveBlock(stmt.getBlock(), resolver);
        resolver.popLevel();
        try {
            return new WhileStatement(expr, block);
        }
        catch (VilException e) {
            throw new TranslatorException(e, stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.WHILE__EXPR);
        }
    }

    private ForStatement processForStatement(For stmt, Resolver resolver) throws TranslatorException {
        Expression expr = this.processExpression(stmt.getExpr(), resolver);
        IMetaType type = null;
        try {
            type = expr.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException(e, stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.FOR__EXPR);
        }
        if (!((TypeDescriptor)type).isCollection() && !((TypeDescriptor)type).isIterator()) {
            OperationDescriptor conversion = ((TypeDescriptor)type).getConversionToSequence();
            if (null == conversion) {
                throw new TranslatorException("for must run over collection", stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.FOR__EXPR, 20203);
            }
            type = conversion.getReturnType();
        }
        EList<LoopVariable> vars = stmt.getVar();
        if (((TypeDescriptor)type).getGenericParameterCount() != vars.size()) {
            throw new TranslatorException("number of for variables does not comply with expression", stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.FOR__EXPR, 20203);
        }
        int vSize = vars.size();
        VariableDeclaration[] mapVars = new VariableDeclaration[vSize];
        TypeDescriptor<?>[] givenTypes = TypeDescriptor.createArray(vSize);
        for (int i = 0; i < vars.size(); ++i) {
            LoopVariable mv = (LoopVariable)vars.get(i);
            TypeDescriptor<?> varType = ((TypeDescriptor)type).getGenericParameterType(i);
            if (null != mv.getType()) {
                givenTypes[i] = this.processType(mv.getType(), resolver);
                if (!givenTypes[i].isAssignableFrom(varType) && null == varType.findConversion(varType, givenTypes[i])) {
                    throw new TranslatorException("explicitly given type '" + givenTypes[i].getVilName() + "'of for iterator variable '" + mv.getVar() + "' does not match inferred type '" + varType.getVilName() + "'", mv, (EStructuralFeature)VilBuildLanguagePackage.Literals.LOOP_VARIABLE__TYPE, 20203);
                }
                varType = givenTypes[i];
            }
            mapVars[i] = new VariableDeclaration(mv.getVar(), varType);
        }
        resolver.pushLevel();
        resolver.add(mapVars);
        IRuleElement[] block = this.resolveBlock(stmt.getBlock(), resolver);
        resolver.popLevel();
        try {
            return new ForStatement(mapVars, expr, block, givenTypes, stmt.getSeparator().equals(":"));
        }
        catch (VilException e) {
            throw new TranslatorException(e, stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.FOR__VAR);
        }
    }

    private MapExpression processMap(Map map, Resolver resolver) throws TranslatorException {
        Expression expr = this.processExpression(map.getExpr(), resolver);
        IMetaType type = null;
        try {
            type = expr.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException(e, map, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__EXPR);
        }
        if (!((TypeDescriptor)type).isCollection() && !((TypeDescriptor)type).isIterator()) {
            OperationDescriptor conversion = ((TypeDescriptor)type).getConversionToSequence();
            if (null == conversion) {
                throw new TranslatorException("map must run over collection", map, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__EXPR, 20203);
            }
            type = conversion.getReturnType();
        }
        EList<LoopVariable> vars = map.getVar();
        if (((TypeDescriptor)type).getGenericParameterCount() != vars.size()) {
            throw new TranslatorException("number of map variables does not comply with expression", map, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__EXPR, 20203);
        }
        int vSize = vars.size();
        VariableDeclaration[] mapVars = new VariableDeclaration[vSize];
        TypeDescriptor<?>[] givenTypes = TypeDescriptor.createArray(vSize);
        for (int i = 0; i < vars.size(); ++i) {
            LoopVariable mv = (LoopVariable)vars.get(i);
            TypeDescriptor<?> varType = ((TypeDescriptor)type).getGenericParameterType(i);
            if (null != mv.getType()) {
                givenTypes[i] = this.processType(mv.getType(), resolver);
                if (!givenTypes[i].isAssignableFrom(varType) && null == varType.findConversion(varType, givenTypes[i])) {
                    throw new TranslatorException("explicitly given type '" + givenTypes[i].getVilName() + "'of map variable '" + mv.getVar() + "' does not match inferred type '" + varType.getVilName() + "'", mv, (EStructuralFeature)VilBuildLanguagePackage.Literals.LOOP_VARIABLE__TYPE, 20203);
                }
                varType = givenTypes[i];
            }
            mapVars[i] = new VariableDeclaration(mv.getVar(), varType);
        }
        resolver.pushLevel();
        resolver.limitVariablesOnCurrentLevel();
        resolver.add(mapVars);
        IRuleElement[] block = this.resolveBlock(map.getBlock(), resolver);
        resolver.popLevel();
        try {
            return new MapExpression(mapVars, expr, block, givenTypes, map.getSeparator().equals(":"));
        }
        catch (VilException e) {
            throw new TranslatorException(e, map, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__VAR);
        }
    }

    private IRuleBlock resolveStatementOrBlock(StatementOrBlock part, Resolver resolver) throws TranslatorException {
        IRuleBlock result = null;
        if (null != part) {
            if (null != part.getBlock()) {
                result = new NestedRuleBlock(this.resolveBlock(part.getBlock(), resolver));
            } else if (null != part.getExStmt()) {
                result = new SimpleStatementBlock(this.processExpressionStatement(part.getExStmt(), resolver));
            }
        }
        return result;
    }

    public IRuleElement[] resolveBlock(RuleElementBlock block, Resolver resolver) {
        IRuleElement[] result = null;
        if (null != block && null != block.getElements()) {
            result = this.resolveBlock((List<? extends RuleElement>)block.getElements(), resolver);
        }
        return result;
    }

    public IRuleElement[] resolveBlock(List<? extends RuleElement> block, Resolver resolver) {
        IRuleElement[] result = null;
        if (null != block) {
            ArrayList<IRuleElement> tmp = new ArrayList<IRuleElement>();
            for (RuleElement ruleElement : block) {
                try {
                    if (null != ruleElement.getExprStmt()) {
                        tmp.add(this.processExpressionStatement(ruleElement.getExprStmt(), resolver));
                        continue;
                    }
                    if (null != ruleElement.getVarDecl()) {
                        tmp.add((IRuleElement)this.processVariableDeclaration(ruleElement.getVarDecl(), resolver));
                        continue;
                    }
                    if (null != ruleElement.getFor()) {
                        tmp.add(this.processForStatement(ruleElement.getFor(), resolver));
                        continue;
                    }
                    if (null != ruleElement.getWhile()) {
                        tmp.add(this.processWhileStatement(ruleElement.getWhile(), resolver));
                        continue;
                    }
                    IRuleElement rElt = this.resolveRuleElement(ruleElement, resolver);
                    if (null == rElt) continue;
                    tmp.add(rElt);
                }
                catch (TranslatorException e) {
                    this.error(e);
                }
            }
            if (!tmp.isEmpty()) {
                result = new IRuleElement[tmp.size()];
                tmp.toArray(result);
            }
        }
        return result;
    }

    protected IRuleElement resolveRuleElement(RuleElement elt, Resolver resolver) throws TranslatorException {
        return null;
    }

    @Override
    protected ExpressionStatement createExpressionStatement(Expression expression, Resolver resolver) {
        return new ExpressionStatement(expression);
    }

    public ExpressionStatement processExpressionStatement(de.uni_hildesheim.sse.vilBuildLanguage.ExpressionStatement expr, Resolver resolver) throws TranslatorException {
        ExpressionStatement result = null != expr.getAlt() ? this.createExpressionStatement((Expression)this.processAlternative(expr.getAlt(), resolver), resolver) : (ExpressionStatement)super.processExpressionStatement(expr, resolver);
        return result;
    }

    protected JoinExpression processJoin(Join join, Resolver resolver) throws TranslatorException {
        JoinVariableDeclaration[] vars = new JoinVariableDeclaration[]{this.processJoinVariable(join.getVar1(), resolver), this.processJoinVariable(join.getVar2(), resolver)};
        Expression condition = null;
        if (null != join.getCondition()) {
            resolver.pushLevel();
            for (int i = 0; i < vars.length; ++i) {
                resolver.add(vars[i]);
            }
            try {
                condition = this.processExpression(join.getCondition(), resolver);
            }
            catch (TranslatorException e) {
                throw e;
            }
            finally {
                resolver.popLevel();
            }
        }
        try {
            return new JoinExpression(vars, condition);
        }
        catch (VilException e) {
            throw new TranslatorException(e, join, (EStructuralFeature)VilBuildLanguagePackage.Literals.JOIN__CONDITION);
        }
    }

    protected JoinVariableDeclaration processJoinVariable(JoinVariable var, Resolver resolver) throws TranslatorException {
        Expression ex = this.processExpression(var.getExpr(), resolver);
        try {
            return new JoinVariableDeclaration(var.getVar(), ex, null != var.getExcl());
        }
        catch (VilException e) {
            throw new TranslatorException(e, var, (EStructuralFeature)VilBuildLanguagePackage.Literals.JOIN_VARIABLE__VAR);
        }
    }

    @Override
    protected Expression processCall(Expression firstParam, Call call, ExpressionTranslator.CallType type, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression arrayEx, Resolver resolver) throws TranslatorException {
        VariableDeclaration opVar;
        AbstractCallExpression result;
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>();
        if (null != firstParam) {
            arguments.add(new CallArgument(firstParam));
        }
        List varDecls = this.resolveIteratorDeclarations(call, type, arguments, resolver);
        String name = this.resolveCallArguments(call, varDecls, arguments, arrayEx, resolver);
        CallArgument[] arg = new CallArgument[arguments.size()];
        arguments.toArray(arg);
        if (ExpressionTranslator.CallType.SYSTEM == type) {
            try {
                VariableDeclaration nameVar = (VariableDeclaration)resolver.resolve(name, false, call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, this);
                if (null == nameVar) {
                    throw new TranslatorException("cannot resolve variable " + nameVar, call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, 20207);
                }
                result = new StrategyCallExpression(nameVar, arg);
                ((Expression)result).inferType();
            }
            catch (VilException e) {
                throw new TranslatorException(e, call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME);
            }
        }
        result = null;
        VilException semanticException = null;
        try {
            result = (AbstractCallExpression)resolver.createCallExpression(ExpressionTranslator.CallType.SUPER == type, name, arg);
        }
        catch (VilException e) {
            semanticException = e;
        }
        if ((null == result || this.continueResolution(semanticException)) && Resolver.ContextType.RULE_BODY == resolver.getContextType()) {
            try {
                StrategyCallExpression sce = new StrategyCallExpression((Object)resolver.getCurrentModel(), name, arg);
                sce.setTypeRegistry(resolver.getTypeRegistry());
                result = sce;
                semanticException = this.checkSemantics(result);
            }
            catch (VilException sce) {
                // empty catch block
            }
        }
        if (null == result || this.continueResolution(semanticException)) {
            try {
                result = new CallExpression(null, name, arg);
                semanticException = this.checkSemantics(result);
            }
            catch (VilException sce) {
                // empty catch block
            }
        }
        if ((null == result || this.continueResolution(semanticException)) && null != (opVar = (VariableDeclaration)resolver.resolve(name, false))) {
            try {
                result = new ResolvableOperationCallExpression(opVar, arg);
                semanticException = this.checkSemantics(result);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        if (null != semanticException) {
            throw new TranslatorException(semanticException, call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME);
        }
        return this.checkCallExpression(result, type, call);
    }

    @Override
    protected VariableDeclaration createVariableDeclaration(String name, TypeDescriptor<?> type, boolean isConstant, Expression expression, Resolver resolver) {
        return new VariableDeclaration(name, type, isConstant, expression);
    }

    @Override
    protected VariableDeclaration createImplicitVariableDeclaration(String name, TypeDescriptor<?> type, boolean isConstant, Expression expression, Resolver resolver) {
        return new ImplicitVariableDeclaration(name, type, isConstant, expression);
    }

    @Override
    protected net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestriction createExpressionVersionRestriction(Expression expr, net.ssehub.easy.instantiation.core.model.common.VariableDeclaration decl, EObject cause, EStructuralFeature feature) throws RestrictionEvaluationException {
        try {
            ExpressionVersionRestrictionValidator validator = new ExpressionVersionRestrictionValidator(new MessageHandler(this, cause, feature));
            expr.accept(validator);
            return new ExpressionVersionRestriction(expr, decl);
        }
        catch (VilException e) {
            throw new RestrictionEvaluationException(e.getMessage(), e.getId());
        }
    }

    @Override
    public Expression parseExpression(String expression, Resolver resolver, StringBuilder warnings) throws VilException {
        return BuildLangModelUtility.INSTANCE.createExpression(expression, resolver, warnings);
    }

    @Override
    protected String cannotAssignHint() {
        return "VIL cannot assign values to configurable elements.";
    }
}

