/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.ILoader;
import de.uni_hildesheim.sse.easy.loader.InitType;
import de.uni_hildesheim.sse.easy.loader.StartupInfo;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ListLoader
implements ILoader {
    public static final String EASY_STARTUP_FILE_NAME = ".easyStartup";
    private List<StartupInfo> startupSequence = new ArrayList<StartupInfo>();
    private boolean verbose = false;

    public ListLoader() throws IOException {
        this((File)null);
    }

    public ListLoader(File listFile) throws IOException {
        InputStream is = null == listFile ? this.getClass().getClassLoader().getResourceAsStream(EASY_STARTUP_FILE_NAME) : new FileInputStream(listFile);
        this.load(is);
        Utils.closeQuietly(is);
    }

    public ListLoader(InputStream is) throws IOException {
        this.load(is);
    }

    public ListLoader(Reader reader) throws IOException {
        this.load(reader);
    }

    private void load(InputStream is) throws IOException {
        this.load(new InputStreamReader(is));
    }

    private void load(Reader reader) throws IOException {
        LineNumberReader lnr = new LineNumberReader(reader);
        String line = null;
        do {
            if (null == (line = lnr.readLine())) continue;
            this.processLine(line);
        } while (null != line);
    }

    @Override
    public void startup() {
        for (StartupInfo info : this.startupSequence) {
            info.start();
        }
    }

    @Override
    public void shutdown() {
        for (StartupInfo info : this.startupSequence) {
            info.stop();
        }
    }

    private void processLine(String line) {
        int pos = line.indexOf(58);
        if (pos > 0 && line.length() > pos) {
            String marker = line.substring(0, pos).trim();
            String className = line.substring(pos + 1).trim();
            InitType type = InitType.valueOf(marker);
            if (null != type) {
                this.startupSequence.add(new StartupInfo(type, className, this.verbose));
            }
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        for (StartupInfo info : this.startupSequence) {
            info.setVerbose(verbose);
        }
    }
}

