/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.InitType;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;

class StartupInfo {
    private InitType type;
    private String className;
    private boolean verbose;

    StartupInfo(InitType type, String className, boolean verbose) {
        this.verbose = verbose;
        this.type = type;
        this.className = className;
    }

    public boolean start() {
        boolean result;
        if (InitType.ACTIVATOR == this.type) {
            if (this.verbose) {
                Log.info("START activator " + this.className);
            }
            result = Utils.startBundle(this.getClass().getClassLoader(), this.className);
        } else if (InitType.DS == this.type) {
            if (this.verbose) {
                Log.info("START DS " + this.className);
            }
            result = Utils.activateDsInstance(this.getClass().getClassLoader(), this.className);
        } else {
            result = false;
        }
        return result;
    }

    public boolean stop() {
        boolean result;
        if (InitType.ACTIVATOR == this.type) {
            if (this.verbose) {
                Log.info("STOP activator " + this.className);
            }
            result = Utils.stopBundle(this.getClass().getClassLoader(), this.className);
        } else if (InitType.DS == this.type) {
            if (this.verbose) {
                Log.info("STOP DS " + this.className);
            }
            result = Utils.deactivateDsInstance(this.getClass().getClassLoader(), this.className);
        } else {
            result = false;
        }
        return result;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

