/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Sequence;

public class RefByCheckVisitor
implements IConstraintTreeVisitor {
    private boolean canBeDereferenced = false;

    public boolean canBeDereferenced() {
        return this.canBeDereferenced;
    }

    public void reset() {
        this.canBeDereferenced = false;
    }

    @Override
    public void visitConstantValue(ConstantValue value) {
        this.canBeDereferenced = false;
    }

    @Override
    public void visitVariable(Variable variable) {
        this.canBeDereferenced = true;
    }

    @Override
    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable(variable);
    }

    @Override
    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept(this);
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitOclFeatureCall(OCLFeatureCall call) {
        Operation op = call.getResolvedOperation();
        this.canBeDereferenced = Sequence.AT == op || Sequence.INDEX_ACCESS == op;
    }

    @Override
    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visitMultiAndExpression(MultiAndExpression expression) {
        for (int e = 0; e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept(this);
        }
    }

    @Override
    public void visitLet(Let let) {
        let.getInExpression().accept(this);
    }

    @Override
    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept(this);
        if (null != ifThen.getThenExpr()) {
            boolean tmp = this.canBeDereferenced;
            ifThen.getThenExpr().accept(this);
            this.canBeDereferenced &= tmp;
        }
    }

    @Override
    public void visitContainerOperationCall(ContainerOperationCall call) {
        IDatatype ret = call.getResolvedOperation().getReturns();
        this.canBeDereferenced = Container.TYPE.isAssignableFrom(ret) || Compound.TYPE.isAssignableFrom(ret);
    }

    @Override
    public void visitCompoundAccess(CompoundAccess access) {
        this.canBeDereferenced = true;
    }

    @Override
    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        this.canBeDereferenced = false;
    }

    @Override
    public void visitCompoundInitializer(CompoundInitializer initializer) {
        this.canBeDereferenced = false;
    }

    @Override
    public void visitContainerInitializer(ContainerInitializer initializer) {
        this.canBeDereferenced = false;
    }

    @Override
    public void visitSelf(Self self) {
        this.canBeDereferenced = true;
    }

    @Override
    public void visitBlockExpression(BlockExpression block) {
        int n = block.getExpressionCount();
        for (int e = 0; e < n; ++e) {
            block.getExpression(e).accept(this);
        }
    }
}

