/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.expressions.translation;

import de.uni_hildesheim.sse.vil.expressions.expressionDsl.AdditiveExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.AdditiveExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ArgumentList;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Call;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Constant;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ConstructorExecution;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ContainerInitializer;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Declaration;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.DeclarationUnit;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Declarator;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.EqualityExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.EqualityExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionOrQualifiedExecution;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionStatement;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.LogicalExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.LogicalExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.MultiplicativeExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.MultiplicativeExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.NamedArgument;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.PostfixExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.PrimaryExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.RelationalExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.RelationalExpressionPart;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.SubCall;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.SuperExecution;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Type;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.TypeParameters;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.UnaryExpression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.UnqualifiedExecution;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VariableDeclaration;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionSpec;
import de.uni_hildesheim.sse.vil.expressions.translation.DeferredResolvableOperationExpression;
import de.uni_hildesheim.sse.vil.expressions.translation.IvmlMessageAdapter;
import de.uni_hildesheim.sse.vil.expressions.translation.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.AbstractException;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.dslCore.translation.StringUtils;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstructorCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestriction;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionWriter;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ImplicitContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.MultiAndExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ParenthesisExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolutionListener;
import net.ssehub.easy.instantiation.core.model.expressions.Resolver;
import net.ssehub.easy.instantiation.core.model.expressions.StringExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringResolver;
import net.ssehub.easy.instantiation.core.model.expressions.ValueAssignmentExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VilTypeExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoVoid;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class ExpressionTranslator<I extends net.ssehub.easy.instantiation.core.model.common.VariableDeclaration, R extends Resolver<I>, E extends net.ssehub.easy.instantiation.core.model.common.ExpressionStatement>
extends net.ssehub.easy.dslCore.translation.ExpressionTranslator
implements ResolutionListener,
StringResolver.IExpressionTranslator<I, R> {
    private VarModelIdentifierExpression lastVarModelIdentifierEx;
    private IvmlMessageAdapter ivmlMessageAdapter = new IvmlMessageAdapter();

    public IvmlMessageAdapter setIvmlMessageAdapter(IvmlMessageAdapter adapter) {
        IvmlMessageAdapter old = this.ivmlMessageAdapter;
        this.ivmlMessageAdapter = adapter;
        return old;
    }

    public IvmlMessageAdapter getIvmlMessageAdapter() {
        return this.ivmlMessageAdapter;
    }

    public Expression processExpression(de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression ex, R resolver) throws TranslatorException {
        Expression result = null != ex ? (null != ex.getExpr() ? this.processLogicalExpression(ex.getExpr(), resolver) : this.processContainerInitializer(ex.getInit(), resolver)) : null;
        return result;
    }

    public void enactIvmlWarnings() {
        this.ivmlMessageAdapter.processAndClear(e -> this.ivmlWarning(((VarModelIdentifierExpression)e.getKey()).getIdentifier(), (EObject)e.getValue(), (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE));
    }

    private void ivmlWarning(String name, EObject cause, EStructuralFeature causingFeature) {
        this.warning(VariableExpression.composeUnkownVariableWarning(name), cause, causingFeature, -1);
    }

    public E processExpressionStatement(ExpressionStatement expr, R resolver) throws TranslatorException {
        Expression result = this.processExpression(expr.getExpr(), resolver);
        try {
            result.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException(e, expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__EXPR);
        }
        if (null != expr.getVar()) {
            net.ssehub.easy.instantiation.core.model.common.VariableDeclaration decl = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)((Resolver)resolver).resolve(expr.getVar(), false, expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__VAR, this);
            if (null == decl) {
                throw new TranslatorException("cannot resolve variable '" + expr.getVar() + "'", expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__VAR, 20207);
            }
            if (null != expr.getField()) {
                FieldDescriptor fdesc = decl.getType().getField(expr.getField());
                if (null == fdesc) {
                    throw new TranslatorException("cannot resolve field '" + expr.getField() + "'", expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__FIELD, 20207);
                }
                result = new ValueAssignmentExpression(decl, fdesc, result);
                if (null != fdesc && fdesc.isReadOnly()) {
                    throw new TranslatorException("Cannot assign value to readonly field '" + fdesc.getName() + "'." + this.cannotAssignHint(), expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__FIELD, 30016);
                }
            } else {
                try {
                    result = new ValueAssignmentExpression(decl, result);
                    result.inferType();
                }
                catch (VilException e) {
                    throw new TranslatorException(e, expr, (EStructuralFeature)ExpressionDslPackage.Literals.EXPRESSION_STATEMENT__VAR);
                }
            }
        }
        return this.createExpressionStatement(result, resolver);
    }

    protected abstract String cannotAssignHint();

    protected abstract E createExpressionStatement(Expression var1, R var2);

    public Expression processLogicalExpression(LogicalExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processEqualityExpression(ex.getLeft(), resolver);
        if (null != ex.getRight()) {
            try {
                for (LogicalExpressionPart part : ex.getRight()) {
                    result = new CallExpression(null, part.getOp(), result, this.processEqualityExpression(part.getEx(), resolver));
                    result.inferType();
                }
            }
            catch (VilException e) {
                throw new TranslatorException(e, ex, (EStructuralFeature)ExpressionDslPackage.Literals.LOGICAL_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processEqualityExpression(EqualityExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processRelationalExpression(ex.getLeft(), resolver);
        if (null != ex.getRight()) {
            try {
                EqualityExpressionPart part = ex.getRight();
                result = new CallExpression(null, part.getOp(), result, this.processRelationalExpression(part.getEx(), resolver));
                result.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException(e, ex, (EStructuralFeature)ExpressionDslPackage.Literals.EQUALITY_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processRelationalExpression(RelationalExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processAdditiveExpression(ex.getLeft(), resolver);
        if (null != ex.getRight()) {
            try {
                RelationalExpressionPart part = ex.getRight();
                Expression rightEx = this.processAdditiveExpression(part.getEx(), resolver);
                CallExpression call1 = new CallExpression(null, part.getOp(), result, rightEx);
                result = call1;
                result.inferType();
                if (null != ex.getRight2()) {
                    part = ex.getRight2();
                    CallExpression call2 = new CallExpression(null, part.getOp(), rightEx, this.processAdditiveExpression(part.getEx(), resolver));
                    call2.inferType();
                    result = new MultiAndExpression(call1, call2);
                    result.inferType();
                    if (ExpressionWriter.considerOclCompliance()) {
                        this.warning("OCL compliance: chain of relational operations shall be written by a combination of binary comparisons and Boolean and operatoins", ex, (EStructuralFeature)ExpressionDslPackage.Literals.RELATIONAL_EXPRESSION__RIGHT2, -1);
                    }
                }
            }
            catch (VilException e) {
                throw new TranslatorException(e, ex, (EStructuralFeature)ExpressionDslPackage.Literals.RELATIONAL_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processAdditiveExpression(AdditiveExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processMultiplicativeExpression(ex.getLeft(), resolver);
        if (null != ex.getRight()) {
            try {
                for (AdditiveExpressionPart part : ex.getRight()) {
                    result = new CallExpression(null, part.getOp(), result, this.processMultiplicativeExpression(part.getEx(), resolver));
                    result.inferType();
                }
            }
            catch (VilException e) {
                throw new TranslatorException(e, ex, (EStructuralFeature)ExpressionDslPackage.Literals.ADDITIVE_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processMultiplicativeExpression(MultiplicativeExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processUnaryExpression(ex.getLeft(), resolver);
        if (null != ex.getRight()) {
            try {
                MultiplicativeExpressionPart part = ex.getRight();
                result = new CallExpression(null, part.getOp(), result, this.processUnaryExpression(part.getExpr(), resolver));
                result.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException(e, ex, (EStructuralFeature)ExpressionDslPackage.Literals.MULTIPLICATIVE_EXPRESSION__RIGHT);
            }
        }
        return result;
    }

    protected Expression processUnaryExpression(UnaryExpression ex, R resolver) throws TranslatorException {
        Expression result = this.processPostfixExpression(ex.getExpr(), resolver);
        if (null != ex.getOp()) {
            try {
                result = new CallExpression(null, ex.getOp(), result);
                result.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException(e, ex, (EStructuralFeature)ExpressionDslPackage.Literals.UNARY_EXPRESSION__EXPR);
            }
        }
        return result;
    }

    protected Expression processPostfixExpression(PostfixExpression ex, R resolver) throws TranslatorException {
        return this.processPrimaryExpression(ex.getLeft(), resolver);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<I> resolveIteratorDeclarations(Call call, CallType type, List<CallArgument> arguments, R resolver) throws TranslatorException {
        void var5_8;
        Declarator decl;
        ArrayList arrayList = new ArrayList();
        if (null == call || null == (decl = call.getDecl()) || null == decl.getDecl() || arguments.size() <= 0) return var5_8;
        TypeDescriptor<?> arg0Type = null;
        try {
            arg0Type = arguments.get(0).inferType();
        }
        catch (VilException e) {
            throw new TranslatorException(e, call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__PARAM);
        }
        if (null != arg0Type) {
            if (arg0Type.isCollection()) {
                if (arg0Type.getGenericParameterCount() <= 0) throw new TranslatorException("cannot apply iterator as collection does not declare generic types", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__DECL, 20211);
                ArrayList<I> arrayList2 = this.processDeclarators(call, arg0Type.getGenericParameterType(0), arguments, resolver);
            } else {
                ArrayList<I> arrayList3 = this.processDeclarators(call, null, arguments, resolver);
            }
        }
        if (null == var5_8) {
            throw new TranslatorException("at least one declarator / iterator must be given", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__DECL, 20211);
        }
        int freeCount = 0;
        for (int i = 0; i < var5_8.size(); ++i) {
            net.ssehub.easy.instantiation.core.model.common.VariableDeclaration declarator = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)var5_8.get(i);
            if (null != declarator.getExpression()) continue;
            ++freeCount;
        }
        if (freeCount == true) return var5_8;
        throw new TranslatorException("currently an iterator call accepts exactly one unbound / auto-bound iterator variable", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__DECL, 20211);
    }

    private ArrayList<I> processDeclarators(Call call, TypeDescriptor<?> implicitType, List<CallArgument> arguments, R resolver) throws TranslatorException {
        ArrayList<I> result = new ArrayList<I>();
        Declarator decl = call.getDecl();
        boolean firstDecl = true;
        String callName = Utils.getQualifiedNameString(call.getName());
        boolean isAggregator = "iterate".equals(callName) || "apply".equals(callName);
        for (Declaration d : decl.getDecl()) {
            TypeDescriptor<?> t;
            if (null != d.getType()) {
                t = this.processType(d.getType(), resolver);
                if (!(firstDecl && isAggregator || null == implicitType || t.isAssignableFrom(implicitType))) {
                    throw new TranslatorException("type '" + t.getVilName() + "' of iterator does not match type '" + implicitType.getVilName() + "' of the expression", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__PARAM, 20211);
                }
            } else {
                if (null == implicitType) {
                    if (!arguments.isEmpty()) {
                        try {
                            TypeDescriptor<?> opType = arguments.get(0).inferType();
                            ImplicitContainerInitializerExpression cInitEx = new ImplicitContainerInitializerExpression(arguments.get(0));
                            cInitEx.inferType();
                            arguments.set(0, new CallArgument(cInitEx.toSet()));
                            implicitType = opType;
                        }
                        catch (VilException opType) {
                            // empty catch block
                        }
                    }
                    if (null == implicitType) {
                        throw new TranslatorException("on non-collection iterators the declarator must given with type", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__PARAM, 20211);
                    }
                }
                t = implicitType;
            }
            boolean firstUnit = true;
            for (DeclarationUnit unit : d.getUnits()) {
                Expression deflt = null;
                if (null != unit.getDeflt()) {
                    deflt = this.processExpression(unit.getDeflt(), resolver);
                }
                I var = this.createVariableDeclaration(unit.getId(), t, false, deflt, resolver);
                ((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)var).setHasExplicitType(firstUnit && null != d.getType());
                result.add(var);
                firstUnit = false;
            }
            firstDecl = false;
        }
        return result;
    }

    protected String resolveCallArguments(Call call, List<I> iterators, List<CallArgument> arguments, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression arrayEx, R resolver) throws TranslatorException {
        String name;
        if (null != call) {
            if (null != call.getParam()) {
                if (!iterators.isEmpty()) {
                    ((Resolver)resolver).pushLevel();
                    ((Resolver)resolver).add(iterators);
                }
                int count = 0;
                for (NamedArgument param : call.getParam().getParam()) {
                    Expression ex;
                    String paramName = param.getName();
                    try {
                        ex = this.resolveCallArgumentExpression(param, count, iterators, arguments, resolver);
                        if (0 == count && !iterators.isEmpty()) {
                            if (null != paramName) {
                                net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)((Resolver)resolver).resolve(paramName, false, param, (EStructuralFeature)ExpressionDslPackage.Literals.PARAMETER__NAME, this);
                                if (null == var) {
                                    throw new TranslatorException("cannot resolve '" + paramName + "'", param, (EStructuralFeature)ExpressionDslPackage.Literals.PARAMETER__NAME, 20211);
                                }
                                ex = new ValueAssignmentExpression(var, ex);
                                paramName = null;
                            }
                            net.ssehub.easy.instantiation.core.model.common.VariableDeclaration iterator = null;
                            for (int i = 0; null == iterator && i < iterators.size(); ++i) {
                                net.ssehub.easy.instantiation.core.model.common.VariableDeclaration iter = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)iterators.get(i);
                                if (null != iter.getExpression()) continue;
                                iterator = iter;
                            }
                            ex = new ExpressionEvaluator(ex, iterator, iterators);
                        }
                    }
                    catch (TranslatorException e) {
                        if (20211 == e.getId()) {
                            ex = this.tryIteratorExpression(arguments, param, resolver);
                        }
                        throw new TranslatorException(e, param, (EStructuralFeature)ExpressionDslPackage.Literals.NAMED_ARGUMENT__EX);
                    }
                    arguments.add(new CallArgument(paramName, ex));
                    ++count;
                }
                if (!iterators.isEmpty()) {
                    ((Resolver)resolver).popLevel();
                }
            }
            name = Utils.getQualifiedNameString(call.getName());
        } else {
            arguments.add(new CallArgument(this.processExpression(arrayEx, resolver)));
            name = "[]";
        }
        return name;
    }

    private Expression resolveCallArgumentExpression(NamedArgument param, int paramIndex, List<I> iterators, List<CallArgument> arguments, R resolver) throws TranslatorException {
        Expression ex;
        block6: {
            ex = null;
            this.lastVarModelIdentifierEx = null;
            try {
                ex = this.processExpression(param.getEx(), resolver);
            }
            catch (TranslatorException e) {
                boolean consider = iterators.isEmpty() && 0 == paramIndex && null == param.getName();
                if (consider &= null != this.lastVarModelIdentifierEx && arguments.size() > 0) {
                    TypeDescriptor<?> arg0Type;
                    try {
                        arg0Type = arguments.get(0).inferType();
                    }
                    catch (VilException e1) {
                        arg0Type = null;
                    }
                    if (null != arg0Type && arg0Type.isCollection() && arg0Type.getGenericParameterCount() > 0) {
                        I var = this.createImplicitVariableDeclaration(this.lastVarModelIdentifierEx.getIdentifier(), arg0Type.getGenericParameterType(0), false, null, resolver);
                        iterators.add(var);
                        ((Resolver)resolver).pushLevel();
                        ((Resolver)resolver).add(iterators);
                        ex = this.processExpression(param.getEx(), resolver);
                    }
                }
                if (null != ex) break block6;
                throw e;
            }
        }
        return ex;
    }

    private ExpressionEvaluator tryIteratorExpression(List<CallArgument> arguments, NamedArgument param, R resolver) throws TranslatorException {
        ExpressionEvaluator ex = null;
        if (arguments.size() > 0) {
            try {
                TypeDescriptor<?> arg0Type = arguments.get(0).inferType();
                if (arg0Type.isCollection() && arg0Type.getGenericParameterCount() > 0) {
                    ((Resolver)resolver).pushLevel();
                    I iterVar = this.createImplicitVariableDeclaration("ITER", arg0Type.getGenericParameterType(0), false, null, resolver);
                    ((Resolver)resolver).add(iterVar);
                    ex = new ExpressionEvaluator(this.processExpression(param.getEx(), resolver), (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)iterVar, null);
                    ((Resolver)resolver).popLevel();
                }
            }
            catch (VilException e) {
                throw new TranslatorException(e, param, (EStructuralFeature)ExpressionDslPackage.Literals.NAMED_ARGUMENT__EX);
            }
        }
        return ex;
    }

    protected abstract I createVariableDeclaration(String var1, TypeDescriptor<?> var2, boolean var3, Expression var4, R var5);

    protected abstract I createImplicitVariableDeclaration(String var1, TypeDescriptor<?> var2, boolean var3, Expression var4, R var5);

    protected abstract Expression processCall(Expression var1, Call var2, CallType var3, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression var4, R var5) throws TranslatorException;

    protected AbstractCallExpression checkCallExpression(AbstractCallExpression callEx, CallType type, Call call) throws TranslatorException {
        if (null == callEx) {
            throw new TranslatorException("cannot resolve " + call.getName(), call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, 20207);
        }
        if (callEx.isPlaceholder()) {
            this.warning("The operation '" + callEx.getVilSignature() + "' is unknown, shall be a VIL type - may lead to a runtime error", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, 20200);
        }
        if (ExpressionWriter.considerOclCompliance()) {
            if (!callEx.isOclCompliant()) {
                this.warning("OCL compliance: The operation '" + callEx.getVilSignature() + "' is not OCL compliant. Please use the respective alias method instead.", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, -1);
            }
            if (callEx.isIteratingCollectionOperation() && type != CallType.ITERATOR) {
                this.warning("OCL compliance: The iterator operation '" + callEx.getVilSignature() + "' shall be called through '->' rather than '.'.", call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, -1);
            }
        }
        return callEx;
    }

    protected VilException checkSemantics(Expression expr) {
        VilException semantic = null;
        if (null != expr) {
            try {
                expr.inferType();
            }
            catch (VilException e) {
                semantic = e;
            }
        }
        return semantic;
    }

    protected Expression processSubCalls(Expression firstParam, EList<SubCall> followups, R resolver) throws TranslatorException {
        Expression result = firstParam;
        if (null != followups) {
            for (SubCall call : followups) {
                Declarator decl;
                Call c;
                CallType callType = CallType.OTHER;
                if ("->".equals(call.getType())) {
                    callType = CallType.ITERATOR;
                }
                if (null != (c = call.getCall()) && null != (decl = c.getDecl()) && callType != CallType.ITERATOR) {
                    throw new TranslatorException("iterator variables given but this is no iterator call", c, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__DECL, 20211);
                }
                result = this.processCall(result, c, callType, call.getArrayEx(), resolver);
            }
        }
        return result;
    }

    public Expression processPrimaryExpression(PrimaryExpression ex, R resolver) throws TranslatorException {
        Expression result = null;
        if (null != ex) {
            ConstructorExecution cEx;
            SuperExecution superEx;
            UnqualifiedExecution unqEx;
            ExpressionOrQualifiedExecution otherEx = ex.getOtherEx();
            if (null != otherEx) {
                if (null != otherEx.getVal()) {
                    result = this.processConstant(otherEx.getVal(), resolver);
                } else if (null != otherEx.getParenthesis()) {
                    result = new ParenthesisExpression(this.processExpression(otherEx.getParenthesis(), resolver));
                }
                if (null != otherEx.getCalls()) {
                    result = this.processSubCalls(result, otherEx.getCalls(), resolver);
                }
            }
            if (null != (unqEx = ex.getUnqEx())) {
                result = this.processCall(null, unqEx.getCall(), CallType.OTHER, null, resolver);
                result = this.processSubCalls(result, unqEx.getCalls(), resolver);
            }
            if (null != (superEx = ex.getSuperEx())) {
                result = this.processCall(null, superEx.getCall(), CallType.SUPER, null, resolver);
                result = this.processSubCalls(result, superEx.getCalls(), resolver);
            }
            if (null != (cEx = ex.getNewEx())) {
                try {
                    CallArgument[] args = this.processArguments(cEx.getParam(), resolver);
                    result = new ConstructorCallExpression(this.processType(cEx.getType(), resolver), args);
                    result = this.processSubCalls(result, cEx.getCalls(), resolver);
                    result.inferType();
                }
                catch (VilException e) {
                    throw new TranslatorException(e, cEx, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTRUCTOR_EXECUTION__TYPE);
                }
            }
        }
        return result;
    }

    public CallArgument[] processArguments(ArgumentList arguments, R resolver) throws TranslatorException {
        CallArgument[] result;
        if (null == arguments || null == arguments.getParam()) {
            result = new CallArgument[]{};
        } else {
            EList<NamedArgument> args = arguments.getParam();
            result = new CallArgument[args.size()];
            for (int a = 0; a < args.size(); ++a) {
                NamedArgument arg = (NamedArgument)args.get(a);
                result[a] = new CallArgument(arg.getName(), this.processExpression(arg.getEx(), resolver));
            }
        }
        return result;
    }

    @Override
    public abstract Expression parseExpression(String var1, R var2, StringBuilder var3) throws VilException;

    protected Expression processConstant(Constant arg, R resolver) throws TranslatorException {
        Expression result = null;
        if (null != arg.getNValue()) {
            String tmp = arg.getNValue().getVal();
            TypeDescriptor<?> type = tmp.indexOf(46) > 0 ? TypeRegistry.realType() : TypeRegistry.integerType();
            result = ExpressionTranslator.createConstant(type, tmp, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__NVALUE, ((Resolver)resolver).getTypeRegistry());
        } else if (null != arg.getSValue()) {
            String s = StringUtils.convertString(arg.getSValue());
            try {
                StringBuilder warnings = new StringBuilder();
                Expression ex = this.normalizeStringExpression(StringResolver.substitute(s, resolver, this, warnings, null), s);
                if (warnings.length() > 0) {
                    this.warning(warnings.toString(), arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__SVALUE, 0);
                }
                result = ex;
            }
            catch (VilException e) {
                throw new TranslatorException(e, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__SVALUE);
            }
        } else if (null != arg.getQValue()) {
            String name = Utils.getQualifiedNameString(arg.getQValue());
            result = Version.isVersion(name) ? this.convertToVersion(name, arg, resolver) : this.processQualifiedValue(name, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, resolver);
        } else if (null != arg.getBValue()) {
            result = ExpressionTranslator.createConstant(TypeRegistry.booleanType(), arg.getBValue(), arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__BVALUE, ((Resolver)resolver).getTypeRegistry());
        } else if (null != arg.getNull()) {
            result = ExpressionTranslator.createConstant(TypeRegistry.anyType(), TypeRegistry.NULL, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__NULL, ((Resolver)resolver).getTypeRegistry());
        } else if (null != arg.getVersion()) {
            result = this.convertToVersion(arg.getVersion(), arg, resolver);
        }
        return result;
    }

    private Expression normalizeStringExpression(Expression ex, String st) throws VilException {
        Expression ex1;
        CompositeExpression cEx;
        if (ex instanceof CompositeExpression && 1 == (cEx = (CompositeExpression)ex).getExpressionsCount() && !((ex1 = cEx.getExpression(0)) instanceof ConstantExpression)) {
            cEx.setExpression(0, new StringExpression(ex1, st.startsWith("${")));
        }
        return ex;
    }

    private Expression convertToVersion(String text, Constant arg, R resolver) throws TranslatorException {
        Expression result;
        if (text.startsWith("v")) {
            text = text.substring(1);
        }
        try {
            result = ExpressionTranslator.createConstant(TypeRegistry.versionType(), new Version(text), arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__VERSION, ((Resolver)resolver).getTypeRegistry());
        }
        catch (VersionFormatException e) {
            throw new TranslatorException(e.getMessage(), arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__VERSION, e.getId());
        }
        return result;
    }

    private FieldAccessExpression process(net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var, FieldAccessExpression last, String name, Constant elt) throws TranslatorException {
        FieldAccessExpression result;
        if (null == last) {
            FieldDescriptor fd = var.getType().getField(name);
            if (null != fd) {
                try {
                    result = new FieldAccessExpression(var, fd);
                }
                catch (VilException e) {
                    throw new TranslatorException(e, elt, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
                }
            }
            throw new TranslatorException("cannot resolve field '" + name + "'", elt, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, 20207);
        }
        try {
            FieldDescriptor fd = last.inferType().getField(name);
            if (null == fd) {
                throw new TranslatorException("cannot resolve field '" + name + "'", elt, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, 20207);
            }
            result = new FieldAccessExpression(last, fd);
        }
        catch (VilException e) {
            throw new TranslatorException(e, elt, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
        }
        return result;
    }

    protected Expression processQualifiedValue(String name, Constant arg, EStructuralFeature feature, R resolver) throws TranslatorException {
        TypeDescriptor<?> desc;
        Expression result = null;
        int pos = name.indexOf(46);
        Object res = null;
        if (pos > 0 && pos < name.length()) {
            String head = name.substring(0, pos);
            String tail = name.substring(pos + 1);
            res = ((Resolver)resolver).resolve(head, false, arg, feature, this);
            if (res instanceof net.ssehub.easy.instantiation.core.model.common.VariableDeclaration) {
                net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var = res;
                FieldAccessExpression fae = null;
                do {
                    if ((pos = tail.indexOf(46)) >= 0) {
                        fae = this.process(var, fae, tail.substring(0, pos), arg);
                        tail = tail.substring(pos + 1);
                        continue;
                    }
                    fae = this.process(var, fae, tail, arg);
                } while (pos >= 0);
                result = fae;
                res = null;
            } else {
                FieldDescriptor field;
                TypeDescriptor<?> type = ((Resolver)resolver).getTypeRegistry().getType(head);
                if (null != type && null != (field = type.getField(tail)) && field.isStatic()) {
                    try {
                        result = new FieldAccessExpression(field);
                    }
                    catch (VilException e) {
                        throw new TranslatorException(e, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
                    }
                }
            }
        }
        if (null == res && null == result && null == (res = ((Resolver)resolver).resolve(name, false, arg, feature, this)) && null != (desc = ((Resolver)resolver).getTypeRegistry().getType(name, false))) {
            result = new VilTypeExpression(name, desc);
        }
        if (null == res && null == result) {
            if ("ITER".equals(name)) {
                throw new TranslatorException("iterator variable ITER cannot be resolved", arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, 20211);
            }
            TypeRegistry registry = ((Resolver)resolver).getTypeRegistry();
            TypeDescriptor<?> type = registry.getType(name, false);
            if (null == type) {
                net.ssehub.easy.varModel.model.values.EnumValue eValue;
                Object ivmlElement = ((Resolver)resolver).getIvmlElement(name);
                if (ivmlElement instanceof net.ssehub.easy.varModel.model.values.EnumValue && null != (type = registry.getType((eValue = (net.ssehub.easy.varModel.model.values.EnumValue)ivmlElement).getType()))) {
                    try {
                        result = new ConstantExpression(type, new EnumValue(eValue), registry);
                        this.checkOclEnumCompliance(name, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
                    }
                    catch (VilException e) {
                        throw new TranslatorException(e, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
                    }
                }
                if (null == result) {
                    VarModelIdentifierExpression vmie;
                    if (ivmlElement instanceof DecisionVariableDeclaration) {
                        type = registry.getType(((DecisionVariableDeclaration)ivmlElement).getType());
                    } else if (ivmlElement instanceof IvmlElement) {
                        type = ((IvmlElement)ivmlElement).getType();
                    }
                    this.lastVarModelIdentifierEx = vmie = new VarModelIdentifierExpression(name, type, ((Resolver)resolver).getCurrentModel());
                    result = vmie;
                    if (null == ivmlElement) {
                        this.ivmlMessageAdapter.notify(vmie, arg);
                    }
                }
            } else {
                result = new VilTypeExpression(name, type);
                this.ivmlWarning(name, arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE);
            }
        } else if (res instanceof net.ssehub.easy.instantiation.core.model.common.VariableDeclaration) {
            result = new VariableExpression(res, name);
        } else if (res instanceof IvmlElement) {
            result = new VarModelIdentifierExpression(name, ((IvmlElement)res).getType(), ((Resolver)resolver).getCurrentModel());
        } else if (null == result) {
            throw new TranslatorException(name + " is no variable", arg, (EStructuralFeature)ExpressionDslPackage.Literals.CONSTANT__QVALUE, 20203);
        }
        return result;
    }

    private void checkOclEnumCompliance(String name, EObject cause, EStructuralFeature causeFeature) {
        int pos;
        if (ExpressionWriter.considerOclCompliance() && (pos = name.indexOf(46)) > 0) {
            this.warning("OCL compliance: literal access by '.' is discouraged, use '::' instead", cause, causeFeature, -1);
        }
    }

    protected static final Expression createConstant(TypeDescriptor<?> type, Object value, EObject cause, EStructuralFeature causingFeature, TypeRegistry registry) throws TranslatorException {
        try {
            return new ConstantExpression(type, value, registry);
        }
        catch (VilException e) {
            throw new TranslatorException(e, cause, causingFeature);
        }
    }

    public TypeDescriptor<?> processType(Type type, R resolver) throws TranslatorException {
        String typeName;
        TypeDescriptor<IVilType> result;
        TypeDescriptor<?>[] param;
        if (null == type) {
            throw new TranslatorException("no type given", type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__NAME, 30003);
        }
        if (null != type.getSeq()) {
            param = this.processTypeParameter(type.getParam(), type, resolver);
            try {
                result = TypeRegistry.getSequenceType(param);
            }
            catch (VilException e) {
                throw new TranslatorException(e, type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__SEQ);
            }
        } else if (null != type.getSet()) {
            param = this.processTypeParameter(type.getParam(), type, resolver);
            try {
                result = TypeRegistry.getSetType(param);
            }
            catch (VilException e) {
                throw new TranslatorException(e, type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__SET);
            }
        } else if (null != type.getMap()) {
            param = this.processTypeParameter(type.getParam(), type, resolver);
            try {
                result = TypeRegistry.getMapType(param);
            }
            catch (VilException e) {
                throw new TranslatorException(e, type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__SET);
            }
        } else if (null != type.getCall()) {
            param = this.processTypeParameter(type.getParam(), type, resolver);
            TypeDescriptor[] tmp = new TypeDescriptor[param.length + 1];
            System.arraycopy(param, 0, tmp, 0, param.length);
            TypeDescriptor<PseudoVoid> ret = null == type.getReturn() ? ReflectionTypeDescriptor.VOID : this.processType(type.getReturn(), resolver);
            tmp[tmp.length - 1] = ret;
            try {
                result = TypeRegistry.getRuleType(tmp);
            }
            catch (VilException e) {
                throw new TranslatorException(e, type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__CALL);
            }
        } else {
            typeName = Utils.getQualifiedNameString(type.getName());
            TypeRegistry reg = ((Resolver)resolver).getTypeRegistry();
            result = reg.getType(typeName, false);
            if (null == result) {
                result = this.resolveModelType(type, typeName, resolver);
            }
            if (null == result) {
                result = reg.getType(typeName);
            }
            if (null == result) {
                throw new TranslatorException("type '" + typeName + "' unknown", type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__NAME, 20200);
            }
        }
        if (result.isPlaceholder()) {
            typeName = Utils.getQualifiedNameString(type.getName());
            this.ivmlWarning(typeName, type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__NAME);
        }
        return result;
    }

    private TypeDescriptor<?> resolveModelType(Type type, String typeName, R resolver) throws TranslatorException {
        TypeDescriptor<?> result = ((Resolver)resolver).resolveType(typeName);
        if (null != result) {
            TypeRegistry registry = ((Resolver)resolver).getTypeRegistry();
            try {
                TypeDescriptor<?> tmp;
                if (registry.addTypeAlias(typeName, result) && null != (tmp = registry.getType(typeName))) {
                    result = tmp;
                }
            }
            catch (VilException e) {
                throw new TranslatorException("type '" + typeName + "' unknown: " + e.getMessage(), type, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE__NAME, 20200);
            }
        }
        return result;
    }

    private ContainerInitializerExpression processContainerInitializer(ContainerInitializer initializer, R resolver) throws TranslatorException {
        ContainerInitializerExpression result;
        if (null != initializer.getExprs()) {
            int dimensions = -1;
            ArrayList partDims = new ArrayList();
            ArrayList<Expression> inits = new ArrayList<Expression>();
            for (de.uni_hildesheim.sse.vil.expressions.expressionDsl.ContainerInitializerExpression initEx : initializer.getExprs()) {
                Expression part = null;
                partDims.clear();
                try {
                    if (null != initEx.getLogical()) {
                        part = this.processLogicalExpression(initEx.getLogical(), resolver);
                        if (null != part) {
                            partDims.add(part.inferType());
                        }
                    } else if (null != initEx.getContainer()) {
                        part = this.processContainerInitializer(initEx.getContainer(), resolver);
                        TypeDescriptor<?> partType = part.inferType();
                        for (int d = 0; d < partType.getGenericParameterCount(); ++d) {
                            partDims.add(partType.getGenericParameterType(d));
                        }
                    }
                }
                catch (VilException e) {
                    throw new TranslatorException(e, initEx, (EStructuralFeature)ExpressionDslPackage.Literals.CONTAINER_INITIALIZER_EXPRESSION__CONTAINER);
                }
                if (partDims.isEmpty()) {
                    throw new TranslatorException("unknown dimension of container initializer", initEx, (EStructuralFeature)ExpressionDslPackage.Literals.CONTAINER_INITIALIZER_EXPRESSION__CONTAINER, 20212);
                }
                if (dimensions < 0) {
                    dimensions = partDims.size();
                } else if (dimensions != partDims.size()) {
                    throw new TranslatorException("unmatching dimension of container initializer part", initEx, (EStructuralFeature)ExpressionDslPackage.Literals.CONTAINER_INITIALIZER_EXPRESSION__CONTAINER, 20212);
                }
                inits.add(part);
            }
            Expression[] exprs = new Expression[inits.size()];
            inits.toArray(exprs);
            result = new ContainerInitializerExpression(exprs);
        } else {
            result = new ContainerInitializerExpression();
        }
        return result;
    }

    protected TypeDescriptor<?>[] processTypeParameter(TypeParameters param, Type type, R resolver) throws TranslatorException {
        EList<Type> params = param.getParam();
        TypeDescriptor<?>[] result = TypeDescriptor.createArray(params.size());
        for (int i = 0; i < params.size(); ++i) {
            result[i] = this.processType((Type)params.get(i), resolver);
        }
        return result;
    }

    public Expression processAssignment(EObject cause, TypeDescriptor<?> type, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression ex, R resolver) throws TranslatorException {
        Expression init = null;
        if (null != ex) {
            init = this.processExpression(ex, resolver);
            try {
                ContainerInitializerExpression tmp;
                TypeDescriptor<?> tmpType;
                ContainerInitializerExpression cie;
                TypeDescriptor<?> exType = init.inferType();
                boolean ok = type.isAssignableFrom(exType);
                TypeDescriptor checkType = type;
                if (!ok && type.getBaseType() instanceof TypeDescriptor && null == exType.getBaseType()) {
                    checkType = (TypeDescriptor)type.getBaseType();
                }
                if (!ok && checkType.isSequence() && exType.isSequence() && 0 == exType.getGenericParameterCount() && init instanceof ContainerInitializerExpression) {
                    cie = (ContainerInitializerExpression)init;
                    boolean bl = ok = 0 == cie.getInitExpressionsCount();
                }
                if (!ok && checkType.isSet() && exType.isSequence() && 0 == exType.getGenericParameterCount() && init instanceof ContainerInitializerExpression && 0 == (cie = (ContainerInitializerExpression)init).getInitExpressionsCount()) {
                    init = cie.toSet();
                    exType = cie.inferType();
                    ok = true;
                }
                if (!ok && checkType.isSet() && exType.isSequence() && init instanceof ContainerInitializerExpression && checkType.isAssignableFrom(tmpType = (tmp = (cie = (ContainerInitializerExpression)init).toSet()).inferType())) {
                    init = tmp;
                    exType = tmpType;
                    ok = true;
                }
                if (!ok && TypeRegistry.resolvableOperationType().isAssignableFrom(checkType) && IvmlTypes.ivmlElement().isAssignableFrom(exType)) {
                    init = new DeferredResolvableOperationExpression(cause, type, init);
                    ok = true;
                }
                if (!ok) {
                    OperationDescriptor conversion = TypeDescriptor.findConversionOnBoth(exType, checkType);
                    if (null == conversion) {
                        this.throwVariableCannotBeInitialized(cause, ExpressionTranslator.getName(cause), type, exType);
                    } else {
                        init = new CallExpression(conversion, new CallArgument(init));
                    }
                }
            }
            catch (VilException e) {
                throw new TranslatorException(e, cause, (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__TYPE);
            }
        }
        return init;
    }

    public I processVariableDeclaration(VariableDeclaration decl, R resolver) throws TranslatorException {
        String name = decl.getName();
        if (((Resolver)resolver).resolve(name, true) != null) {
            throw new TranslatorException("variable '" + name + "' was already declared", decl, (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__NAME, 20205);
        }
        TypeDescriptor<?> type = this.processType(decl.getType(), resolver);
        boolean isConstant = null != decl.getConst();
        Expression init = this.processAssignment(decl, type, decl.getExpression(), resolver);
        I result = this.createVariableDeclaration(name, type, isConstant, init, resolver);
        ((Resolver)resolver).add(result);
        return result;
    }

    public void reProcessVariableDeclaration(I decl, R resolver) throws TranslatorException {
        Expression init = ((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)decl).getExpression();
        if (init instanceof DeferredResolvableOperationExpression) {
            DeferredResolvableOperationExpression defEx = (DeferredResolvableOperationExpression)init;
            try {
                IMetaOperation op;
                boolean done = false;
                IModel model = ((Resolver)resolver).getCurrentModel();
                Expression defExInit = defEx.getInit();
                TypeDescriptor<?> varType = defEx.getVarType();
                TypeDescriptor<?> defExInitType = defExInit.inferType();
                if (model instanceof IMetaType && null != (op = AbstractCallExpression.resolveResolvableOperation((IMetaType)((Object)model), varType, defExInitType, defExInit, this))) {
                    ((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)decl).resolveOperation(defEx.getVarType(), op);
                    done = true;
                }
                if (!done) {
                    this.throwVariableCannotBeInitialized(defEx.getCause(), null, varType, defExInitType);
                }
            }
            catch (VilException e) {
                throw new TranslatorException(e, defEx.getCause(), (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__TYPE);
            }
        }
    }

    private void throwVariableCannotBeInitialized(EObject cause, String name, TypeDescriptor<?> declType, TypeDescriptor<?> initType) throws TranslatorException {
        if (null == name) {
            name = ExpressionTranslator.getName(cause);
        }
        throw new TranslatorException("'" + name + "' of type '" + declType.getVilName() + "' cannot be initialized with an expression of type '" + initType.getVilName() + "'", cause, (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__NAME, 20203);
    }

    private static String getName(EObject cause) {
        String name = "?";
        if (null != cause) {
            try {
                Method m = cause.getClass().getDeclaredMethod("getName", new Class[0]);
                Object o = m.invoke((Object)cause, new Object[0]);
                if (null != o) {
                    name = o.toString();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return name;
    }

    protected boolean continueResolution(VilException semanticException) {
        return null != semanticException && (semanticException.getId() == 70002 || semanticException.getId() == 70001);
    }

    public void error(AbstractException exception, EObject cause, EStructuralFeature causeFeature) {
        this.error(exception.getMessage(), cause, causeFeature, exception.getId());
    }

    public void warning(AbstractException exception, EObject cause, EStructuralFeature causeFeature) {
        this.error(exception.getMessage(), cause, causeFeature, exception.getId());
    }

    public void warnVersionRestrictions(VersionSpec spec) {
    }

    public IVersionRestriction processRestriction(String name, VersionSpec spec, R resolver) throws TranslatorException {
        ExpressionVersionRestriction result = null;
        if (null != spec && null != spec.getRestriction()) {
            ((Resolver)resolver).pushLevel();
            I versionVariable = this.createVariableDeclaration("version", TypeRegistry.versionType(), false, null, resolver);
            ((Resolver)resolver).add(versionVariable);
            try {
                result = this.createExpressionVersionRestriction(this.processExpression(spec.getRestriction(), resolver), (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)versionVariable, spec.getRestriction(), (EStructuralFeature)ExpressionDslPackage.Literals.VERSION_SPEC__RESTRICTION);
                ((Resolver)resolver).popLevel();
            }
            catch (RestrictionEvaluationException e) {
                throw new TranslatorException(e.getMessage(), spec, (EStructuralFeature)ExpressionDslPackage.Literals.VERSION_SPEC__RESTRICTION, e.getId());
            }
        }
        return result;
    }

    protected abstract ExpressionVersionRestriction createExpressionVersionRestriction(Expression var1, net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var2, EObject var3, EStructuralFeature var4) throws RestrictionEvaluationException;

    @Override
    public void resolved(VarModelIdentifierExpression ex) {
        this.ivmlMessageAdapter.resolve(ex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression assertBooleanExpression(Expression expression, EObject cause, EStructuralFeature causingFeature) throws TranslatorException {
        if (null == expression) return expression;
        try {
            TypeDescriptor<?> type = expression.inferType();
            boolean ok = false;
            if (IvmlTypes.decisionVariableType().isAssignableFrom(type)) {
                ok = true;
                IMetaOperation convOp = TypeHelper.findConversion(type, TypeRegistry.booleanType());
                if (!(convOp instanceof OperationDescriptor)) throw new TranslatorException("No conversion from decisionVariable to Boolean defined", cause, causingFeature, 20203);
                expression = new CallExpression((OperationDescriptor)convOp, new CallArgument(expression));
            } else {
                ok = TypeRegistry.booleanType().isAssignableFrom(type);
            }
            if (ok) return expression;
            throw new TranslatorException("condition must be a Boolean expression rather than " + type.getVilName(), cause, causingFeature, 20203);
        }
        catch (VilException e) {
            throw new TranslatorException(e, cause, causingFeature);
        }
    }

    protected static enum CallType {
        SUPER,
        SYSTEM,
        OTHER,
        ITERATOR;

    }
}

