/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.expressions.translation;

import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Compound;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Import;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.LanguageUnit;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Parameter;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ParameterList;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.TypeDef;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VariableDeclaration;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionSpec;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionStmt;
import de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator;
import de.uni_hildesheim.sse.vil.expressions.translation.Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.common.ICompoundReceiver;
import net.ssehub.easy.instantiation.core.model.common.ITypedefReceiver;
import net.ssehub.easy.instantiation.core.model.common.IVariableDeclarationReceiver;
import net.ssehub.easy.instantiation.core.model.common.Imports;
import net.ssehub.easy.instantiation.core.model.common.ListVariableDeclarationReceiver;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.Resolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.CompoundTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeResolver;
import net.ssehub.easy.varModel.model.Project;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class ModelTranslator<M extends IModel, I extends net.ssehub.easy.instantiation.core.model.common.VariableDeclaration, R extends Resolver<I>, S extends ExpressionStatement, E extends ExpressionTranslator<I, R, S>>
extends net.ssehub.easy.dslCore.translation.ModelTranslator<E> {
    private R resolver;

    public ModelTranslator(E expressionTranslator, R resolver) {
        super(expressionTranslator);
        this.resolver = resolver;
    }

    protected R getResolver() {
        return this.resolver;
    }

    protected Imports<M> processImports(EList<Import> imports) throws TranslatorException {
        Imports result;
        if (null != imports) {
            HashSet<String> known = new HashSet<String>();
            ArrayList tmp = new ArrayList();
            for (Import imp : imports) {
                String name = imp.getName();
                if (imp.getWildcard() != null) {
                    name = name + "*";
                }
                if (!known.contains(name)) {
                    boolean isInsert = imp.getInsert() != null;
                    this.warnVersionRestrictions(imp.getVersionSpec());
                    tmp.add(new ModelImport(name, false, ((ExpressionTranslator)this.getExpressionTranslator()).processRestriction(name, imp.getVersionSpec(), this.resolver), isInsert));
                    known.add(name);
                    continue;
                }
                throw new TranslatorException(name + " is imported multiple times", imp, (EStructuralFeature)ExpressionDslPackage.Literals.IMPORT__NAME, 20209);
            }
            result = new Imports(tmp);
        } else {
            result = null;
        }
        return result;
    }

    protected ModelImport<M> getExtensionImport(String name, Imports<M> imports, EObject cause, EStructuralFeature causingFeature) throws TranslatorException {
        ModelImport<M> result = null;
        if (null != name && null == (result = imports.getImport(name))) {
            throw new TranslatorException(name + " is not imported", cause, causingFeature, 20209);
        }
        return result;
    }

    protected void processTypedefContents(List<EObject> elts, ITypedefReceiver receiver) {
        List<TypeDef> defs = ModelTranslator.select(elts, TypeDef.class);
        this.processTypedefs(defs, receiver);
    }

    protected void processCompoundContents(List<EObject> elts, ICompoundReceiver receiver) {
        List<Compound> defs = ModelTranslator.select(elts, Compound.class);
        this.processCompounds(defs, receiver);
    }

    protected void processTypedefs(List<TypeDef> defs, ITypedefReceiver receiver) {
        int count;
        do {
            count = defs.size();
            this.processTypedefs(defs, receiver, false);
        } while (count != defs.size() && count > 0);
        if (defs.size() > 0) {
            this.processTypedefs(defs, receiver, true);
        }
    }

    protected void processCompounds(List<Compound> cmps, ICompoundReceiver receiver) {
        int count;
        do {
            count = cmps.size();
            this.processCompounds(cmps, receiver, false);
        } while (count != cmps.size() && count > 0);
        if (cmps.size() > 0) {
            this.processCompounds(cmps, receiver, true);
        }
    }

    private void processTypedefs(List<TypeDef> defs, ITypedefReceiver receiver, boolean force) {
        Iterator<TypeDef> iter = defs.iterator();
        while (iter.hasNext()) {
            TypeDef def = iter.next();
            try {
                String name = def.getName();
                TypeDescriptor<?> type = ((ExpressionTranslator)this.getExpressionTranslator()).processType(def.getType(), this.resolver);
                if (!((Resolver)this.resolver).getTypeRegistry().addTypeAlias(name, type)) {
                    this.error("Type name '" + name + "' already exists", def, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE_DEF__NAME, 20210);
                }
                Typedef typedef = this.createTypedef(name, type);
                receiver.addTypedef(typedef);
                iter.remove();
            }
            catch (VilException e) {
                if (!force) continue;
                this.error(e.getMessage(), def, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE_DEF__NAME, e.getId());
            }
            catch (TranslatorException e) {
                if (!force) continue;
                this.error(e);
            }
        }
    }

    private void processCompounds(List<Compound> cmps, ICompoundReceiver receiver, boolean force) {
        Iterator<Compound> iter = cmps.iterator();
        TypeRegistry registry = ((Resolver)this.resolver).getTypeRegistry();
        while (iter.hasNext()) {
            Compound cmp = iter.next();
            try {
                CompoundTypeDescriptor refines = null;
                if (null != cmp.getSuper()) {
                    TypeDescriptor<?> tmp = registry.getType(cmp.getSuper(), false);
                    if (null == tmp) {
                        this.error("Parent compound '" + cmp.getSuper() + "' does not exists", cmp, (EStructuralFeature)ExpressionDslPackage.Literals.COMPOUND__SUPER, 20200);
                    } else if (tmp instanceof CompoundTypeDescriptor) {
                        refines = (CompoundTypeDescriptor)tmp;
                    } else {
                        this.error(cmp.getSuper() + "' is not a compound", cmp, (EStructuralFeature)ExpressionDslPackage.Literals.COMPOUND__SUPER, 20203);
                    }
                }
                CompoundTypeDescriptor cType = new CompoundTypeDescriptor(cmp.getName(), null != cmp.getAbstract(), refines, registry);
                List<VariableDeclaration> vars = ModelTranslator.copy(cmp.getVars());
                if (null != vars) {
                    int s;
                    ListVariableDeclarationReceiver recv = new ListVariableDeclarationReceiver(cmp.getVars().size());
                    this.processVariableDeclarations(vars, recv, false);
                    HashSet<String> known = new HashSet<String>();
                    CompoundTypeDescriptor.SlotDescriptor[] slots = new CompoundTypeDescriptor.SlotDescriptor[recv.getVariableCount()];
                    for (CompoundTypeDescriptor cIter = refines; null != cIter; cIter = cIter.getRefines()) {
                        for (s = 0; s < cIter.getSlotCount(); ++s) {
                            known.add(cIter.getSlot(s).getName());
                        }
                    }
                    for (s = 0; s < slots.length; ++s) {
                        net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)recv.getVariable(s);
                        String varName = var.getName();
                        if (known.contains(varName)) {
                            this.error("Slot '" + varName + "' is already declared", vars.get(s), (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__NAME, 20205);
                        } else {
                            known.add(varName);
                        }
                        slots[s] = new CompoundTypeDescriptor.SlotDescriptor(cType, var);
                    }
                    cType.setFields(slots);
                }
                receiver.addCompound(this.createCompound(cType));
                if (!registry.registerCompoundType(cType)) {
                    this.error("Compound '" + cType.getName() + "' is already declared", cmp, (EStructuralFeature)ExpressionDslPackage.Literals.COMPOUND__NAME, 20205);
                }
                iter.remove();
            }
            catch (VilException e) {
                if (!force) continue;
                this.error(e.getMessage(), cmp, (EStructuralFeature)ExpressionDslPackage.Literals.COMPOUND__NAME, e.getId());
            }
        }
    }

    protected abstract Typedef createTypedef(String var1, TypeDescriptor<?> var2) throws VilException;

    protected abstract net.ssehub.easy.instantiation.core.model.common.Compound createCompound(CompoundTypeDescriptor var1) throws VilException;

    protected void processVariableDeclarations(List<VariableDeclaration> decls, IVariableDeclarationReceiver<I> receiver) {
        this.processVariableDeclarations(decls, receiver, true);
    }

    protected void processVariableDeclarations(List<VariableDeclaration> decls, IVariableDeclarationReceiver<I> receiver, boolean addToResolver) {
        int count;
        do {
            count = decls.size();
            this.processVariableDeclarations(decls, receiver, false, addToResolver);
        } while (count != decls.size() && count > 0);
        if (decls.size() > 0) {
            this.processVariableDeclarations(decls, receiver, true, addToResolver);
        }
    }

    private void processVariableDeclarations(List<VariableDeclaration> decls, IVariableDeclarationReceiver<I> receiver, boolean force, boolean addToResolver) {
        Iterator<VariableDeclaration> iter = decls.iterator();
        while (iter.hasNext()) {
            VariableDeclaration decl = iter.next();
            try {
                Object varDecl = ((ExpressionTranslator)this.getExpressionTranslator()).processVariableDeclaration(decl, this.resolver);
                receiver.addVariableDeclaration(varDecl);
                if (addToResolver) {
                    ((Resolver)this.resolver).add(varDecl);
                }
                iter.remove();
            }
            catch (TranslatorException e) {
                if (!force) continue;
                this.error(e);
            }
        }
    }

    protected Advice[] processAdvices(EList<de.uni_hildesheim.sse.vil.expressions.expressionDsl.Advice> advices, URI modelURI) {
        Advice[] result = null;
        if (null != advices) {
            result = new Advice[advices.size()];
            for (int a = 0; a < advices.size(); ++a) {
                de.uni_hildesheim.sse.vil.expressions.expressionDsl.Advice adv = (de.uni_hildesheim.sse.vil.expressions.expressionDsl.Advice)advices.get(a);
                String name = Utils.getQualifiedNameString(adv.getName());
                try {
                    IVersionRestriction restrictions = ((ExpressionTranslator)this.getExpressionTranslator()).processRestriction(name, adv.getVersionSpec(), this.resolver);
                    StringBuilder warning = new StringBuilder();
                    result[a] = Advice.create(name, modelURI, restrictions, warning);
                    this.buildLocalTypeRegistry(result[a]);
                    if (warning.length() <= 0) continue;
                    this.warning(warning.toString(), adv, (EStructuralFeature)ExpressionDslPackage.Literals.ADVICE__NAME, 20209);
                    continue;
                }
                catch (TranslatorException e) {
                    this.error(e);
                }
            }
        }
        return result;
    }

    private void buildLocalTypeRegistry(Advice advice) {
        Project varModel = advice.getResolved();
        if (null != varModel) {
            TypeRegistry registry = ((Resolver)this.resolver).getTypeRegistry();
            registry.addTypeResolver(new IvmlTypeResolver(varModel, registry));
        }
    }

    protected void warnVersionRestrictions(VersionSpec spec) {
        ((ExpressionTranslator)this.getExpressionTranslator()).warnVersionRestrictions(spec);
    }

    protected I[] resolveParameters(ParameterList pList, EObject cause, EStructuralFeature paramListFeature, R resolver) throws TranslatorException {
        net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[] result = null != pList ? this.resolveParameters((EList)pList.getParam(), cause, paramListFeature, (Resolver)resolver) : null;
        return result;
    }

    protected I[] resolveParameters(EList<Parameter> parameters, EObject cause, EStructuralFeature paramListFeature, R resolver) throws TranslatorException {
        net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[] result;
        if (null != parameters) {
            ArrayList tmp = new ArrayList();
            int firstDefaultParam = -1;
            int lastNonDefaultParam = -1;
            for (int p = 0; p < parameters.size(); ++p) {
                Parameter par = (Parameter)parameters.get(p);
                TypeDescriptor<?> type = ((ExpressionTranslator)this.getExpressionTranslator()).processType(par.getType(), resolver);
                if (null == type) continue;
                for (int t = 0; t < tmp.size(); ++t) {
                    if (!((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)tmp.get(t)).getName().equals(par.getName())) continue;
                    this.error("duplicate parameter name '" + par.getName() + "'", par, (EStructuralFeature)ExpressionDslPackage.Literals.PARAMETER__NAME, 20210);
                }
                Expression dflt = null;
                if (null != par.getDflt()) {
                    dflt = ((ExpressionTranslator)this.getExpressionTranslator()).processAssignment(par, type, par.getDflt(), resolver);
                }
                tmp.add(((ExpressionTranslator)this.getExpressionTranslator()).createVariableDeclaration(par.getName(), type, false, dflt, resolver));
                if (null != dflt) {
                    if (firstDefaultParam >= 0) continue;
                    firstDefaultParam = p;
                    continue;
                }
                lastNonDefaultParam = p;
            }
            if (firstDefaultParam >= 0 && lastNonDefaultParam > firstDefaultParam) {
                this.error("Default parameters must be given after non-default parameters", cause, paramListFeature, 20203);
            }
            result = this.createArray(tmp.size());
            tmp.toArray(result);
        } else {
            result = null;
        }
        return result;
    }

    protected abstract I[] createArray(int var1);

    public static Version convert(VersionStmt versionStatement) {
        Version version = null;
        String vString = null == versionStatement ? null : versionStatement.getVersion();
        if (null == vString) {
            version = null;
        } else {
            try {
                version = new Version(vString);
            }
            catch (VersionFormatException versionFormatException) {
                // empty catch block
            }
        }
        return version;
    }

    protected abstract ModelManagement<M> getManagementInstance();

    protected void resolveImports(LanguageUnit input, EStructuralFeature inputFeature, M model, URI uri, List<? extends LanguageUnit> inProgress, ImportResolver<M> impResolver) {
        ArrayList infoInProgress = new ArrayList();
        AvailableModels<M> available = this.getManagementInstance().availableModels();
        for (int p = 0; p < inProgress.size(); ++p) {
            LanguageUnit pr = inProgress.get(p);
            VersionStmt versionStatement = pr.getVersion();
            String vString = null == versionStatement ? null : versionStatement.getVersion();
            try {
                List<ModelInfo<M>> info = available.getModelInfo(pr.getName(), vString);
                if (null == info) continue;
                infoInProgress.addAll(info);
                continue;
            }
            catch (VersionFormatException e) {
                this.error(e.getMessage(), input, inputFeature, 20209);
            }
        }
        List<IMessage> resolutionMessages = this.getManagementInstance().resolveImports(model, uri, infoInProgress, impResolver);
        if (resolutionMessages.size() > 0) {
            resolutionMessages = this.postResolveImports(model, uri, resolutionMessages);
        }
        block7: for (int i = 0; i < resolutionMessages.size(); ++i) {
            IMessage msg = resolutionMessages.get(i);
            switch (msg.getStatus()) {
                case ERROR: {
                    this.error(msg.getDescription(), input, inputFeature, 20209);
                    continue block7;
                }
                case WARNING: {
                    this.warning(msg.getDescription(), input, inputFeature, 20209);
                    continue block7;
                }
            }
        }
        this.addImportedVariablesToResolver(model, false, new HashSet());
    }

    private void addImportedVariablesToResolver(M model, boolean addModel, Set<M> done) {
        if (!done.contains(model)) {
            if (addModel) {
                this.addVisibleDeclarationsToResolver(model, this.resolver);
            }
            done.add(model);
            for (int i = 0; i < model.getImportsCount(); ++i) {
                Object resolved = model.getImport(i).getResolved();
                if (null == resolved) continue;
                this.addImportedVariablesToResolver(resolved, true, done);
            }
        }
    }

    protected abstract void addVisibleDeclarationsToResolver(M var1, R var2);

    protected List<IMessage> postResolveImports(M model, URI uri, List<IMessage> resolutionMessages) {
        return resolutionMessages;
    }
}

