/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.templatelang;

import com.google.inject.Guice;
import com.google.inject.Module;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Import;
import de.uni_hildesheim.sse.vil.expressions.translation.IvmlMessageAdapter;
import de.uni_hildesheim.sse.vil.templatelang.TemplateLangRuntimeModule;
import de.uni_hildesheim.sse.vil.templatelang.TemplateLangStandaloneSetup;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.HintedExpression;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.LanguageUnit;
import de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation.ExpressionTranslator;
import de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation.ModelTranslator;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.dslCore.ModelUtility;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.templateModel.Resolver;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

public class TemplateLangModelUtility
extends ModelUtility<LanguageUnit, Template>
implements IModelLoader<Template> {
    public static final TemplateLangModelUtility INSTANCE = new TemplateLangModelUtility();

    private TemplateLangModelUtility() {
    }

    @Override
    protected void initializeAfterResourceInitializer() {
        if (TemplateLangModelUtility.getResourceInitializer().forEclipse()) {
            this.setInjector(Guice.createInjector((Module[])new Module[]{new TemplateLangRuntimeModule()}));
        } else {
            this.setInjector(new TemplateLangStandaloneSetup().createInjectorAndDoEMFRegistration());
        }
    }

    public TranslationResult<Template> createModel(LanguageUnit root, java.net.URI uri, boolean registerSuccessful) {
        ModelTranslator translator = new ModelTranslator();
        ArrayList<Template> result = new ArrayList<Template>();
        result.add(translator.createModel(root, uri, registerSuccessful, null));
        return new TranslationResult<Template>(result, translator);
    }

    @Override
    public TranslationResult<Template> parse(URI uri, ImportResolver<Template> resolver) throws IOException {
        ModelTranslator translator = new ModelTranslator();
        LanguageUnit root = this.parse(uri, true, translator, LanguageUnit.class);
        ArrayList<Template> result = null;
        if (null != root) {
            try {
                result = new ArrayList<Template>();
                Template tpl = translator.createModel(root, TemplateLangModelUtility.toNetUri(uri), true, resolver);
                if (null != tpl) {
                    result.add(tpl);
                }
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return new TranslationResult<Template>(result, translator);
    }

    public void print(TranslationResult<Template> result, Writer out, boolean emitComments, boolean emitImports) {
        try {
            TemplateLangWriter writer = new TemplateLangWriter(out);
            for (int p = 0; p < result.getResultCount(); ++p) {
                try {
                    result.getResult(p).accept(writer);
                    continue;
                }
                catch (VilException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(TemplateLangModelUtility.class, "de.uni_hildesheim.sse.vil.templatelang");
                }
            }
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected String getLanguageName() {
        return "de.uni_hildesheim.sse.vil.templatelang.TemplateLang";
    }

    @Override
    protected ClassLoader getLanguageClassLoader() {
        return TemplateLangModelUtility.class.getClassLoader();
    }

    public Expression createExpression(String text, Resolver resolver, StringBuilder warnings) throws VilException {
        return this.createExpression(text, resolver, warnings, null);
    }

    public Expression createExpression(String text, Resolver resolver, StringBuilder warnings, IvmlMessageAdapter adapter) throws VilException {
        Expression result;
        block11: {
            result = null;
            IParseResult parseResult = this.parseFragment("HintedExpression", text);
            if (null != parseResult) {
                StringBuilder errors = new StringBuilder();
                for (INode error : parseResult.getSyntaxErrors()) {
                    TemplateLangModelUtility.appendWithNewLine(errors, error.getText());
                }
                if (0 == errors.length() && null == parseResult.getRootASTElement()) {
                    TemplateLangModelUtility.appendWithNewLine(errors, "empty expression");
                }
                if (0 == errors.length()) {
                    ExpressionTranslator translator = new ExpressionTranslator();
                    if (null != adapter) {
                        translator.setIvmlMessageAdapter(adapter);
                    }
                    HintedExpression expr = (HintedExpression)parseResult.getRootASTElement();
                    try {
                        result = translator.processExpression(expr.getEx(), resolver);
                        if (null != expr.getHint()) {
                            result = new net.ssehub.easy.instantiation.core.model.templateModel.HintedExpression(result, expr.getHint());
                        }
                        for (int i = 0; i < translator.getMessageCount(); ++i) {
                            Message msg = translator.getMessage(i);
                            if (Status.ERROR == msg.getStatus()) {
                                TemplateLangModelUtility.appendWithNewLine(errors, msg.getDescription());
                                continue;
                            }
                            if (null == warnings) continue;
                            TemplateLangModelUtility.appendWithNewLine(warnings, msg.getDescription());
                        }
                        if (translator.getErrorCount() > 0) {
                            throw new VilException(errors.toString(), 70000);
                        }
                        break block11;
                    }
                    catch (TranslatorException e) {
                        throw new VilException(e, e.getId());
                    }
                }
                throw new VilException(errors.toString() + " in expression '" + text + "'", 30003);
            }
        }
        return result;
    }

    public Expression createExpression(String text, IRuntimeEnvironment environment) throws VilException {
        return this.createExpression(text, new Resolver(environment), null);
    }

    @Override
    public String getExtension() {
        return "vtl";
    }

    @Override
    public List<ModelInfo<Template>> obtainInfo(URI uri) throws IOException {
        LanguageUnit template = this.parse(uri, true, null, LanguageUnit.class);
        ArrayList<ModelInfo<Template>> result = new ArrayList<ModelInfo<Template>>();
        if (null != template) {
            Version version = ModelTranslator.convert(template.getVersion());
            ArrayList imports = new ArrayList();
            for (Import imp : template.getImports()) {
                String name = imp.getName();
                imports.add(new ModelImport(name, false, null));
            }
            try {
                result.add(new ModelInfo<Template>(template.getName(), version, this, TemplateLangModelUtility.toNetUri(uri), imports));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return result;
    }
}

