/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation;

import de.uni_hildesheim.sse.vil.expressions.ResourceRegistry;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.PrimaryExpression;
import de.uni_hildesheim.sse.vil.expressions.translation.IvmlMessageAdapter;
import de.uni_hildesheim.sse.vil.templatelang.TemplateLangModelUtility;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Alternative;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Content;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Extension;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.FormattingHint;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.FormattingHintPart;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.IndentationHint;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.IndentationHintPart;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.JavaQualifiedName;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.LanguageUnit;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Loop;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Stmt;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.StmtBlock;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.Switch;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.SwitchPart;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.TemplateLangPackage;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.VilDef;
import de.uni_hildesheim.sse.vil.templatelang.templateLang.While;
import de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation.DefInfo;
import de.uni_hildesheim.sse.vil.templatelang.templateLanguageTranslation.ExpressionTranslator;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.dslCore.translation.StringUtils;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.Imports;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.StringResolver;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.AlternativeStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Compound;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.FlushStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.JavaExtension;
import net.ssehub.easy.instantiation.core.model.templateModel.LoopStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Resolver;
import net.ssehub.easy.instantiation.core.model.templateModel.StringResolverFactory;
import net.ssehub.easy.instantiation.core.model.templateModel.SwitchStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateDescriptor;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangExecution;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.templateModel.TypeDef;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.templateModel.WhileStatement;
import net.ssehub.easy.instantiation.core.model.vilTypes.CompoundTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ModelTranslator
extends de.uni_hildesheim.sse.vil.expressions.translation.ModelTranslator<Template, VariableDeclaration, Resolver, ExpressionStatement, ExpressionTranslator> {
    private ExpressionTranslator expressionTranslator = (ExpressionTranslator)this.getExpressionTranslator();
    private Resolver resolver = (Resolver)this.getResolver();

    public ModelTranslator() {
        super(new ExpressionTranslator(), new Resolver(new TypeRegistry(TypeRegistry.DEFAULT)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template createModel(LanguageUnit tpl, URI uri, boolean registerSuccessful, ImportResolver<Template> impResolver) {
        Template result = null;
        boolean pushed = false;
        int errorCount = this.getErrorCount();
        ResourceRegistry.register(tpl.eResource(), this.resolver.getTypeRegistry());
        try {
            TemplateDescriptor desc = new TemplateDescriptor();
            Imports<Template> imports = this.processImports(tpl.getImports());
            desc.setImports(imports);
            desc.setAdvices(this.processAdvices(tpl.getAdvices(), uri));
            this.processJavaExtensions(tpl, desc);
            desc.setParameter((VariableDeclaration[])this.resolveParameters(tpl.getParam(), tpl, (EStructuralFeature)TemplateLangPackage.Literals.LANGUAGE_UNIT__PARAM, this.resolver), this.resolver);
            ModelImport<Template> extension = this.getExtensionImport(tpl.getExt(), imports, tpl, (EStructuralFeature)TemplateLangPackage.Literals.LANGUAGE_UNIT__EXT);
            if (null != tpl.getIndent()) {
                desc.setIndentationConfiguration(this.processIndentHint(tpl.getIndent()));
            }
            if (null != tpl.getFormatting()) {
                desc.setFormattingConfiguration(this.processFormattingHint(tpl.getFormatting()));
            }
            result = new Template(tpl.getName(), extension, desc, this.resolver.getTypeRegistry());
            this.resolver.pushModel(result);
            pushed = true;
            result.setVersion(ModelTranslator.convert(tpl.getVersion()));
            this.resolveImports(tpl, (EStructuralFeature)ExpressionDslPackage.Literals.LANGUAGE_UNIT__IMPORTS, result, uri, new ArrayList(), impResolver);
            this.resolver.enumerateImports(result);
            List<EObject> elts = ModelTranslator.copy(tpl.getElements());
            if (null != elts) {
                this.processCompoundContents(elts, result);
                this.processTypedefContents(elts, result);
                this.processGlobalVariableDeclarations(elts, result);
                this.processDefs(elts, result);
                this.reProcessGlobalVariableDeclarations(result);
            }
            if (registerSuccessful && errorCount == this.getErrorCount()) {
                TemplateModel.INSTANCE.updateModel(result, uri, TemplateLangModelUtility.INSTANCE);
            }
        }
        catch (VilException e) {
            this.error(e, tpl, (EStructuralFeature)ExpressionDslPackage.Literals.LANGUAGE_UNIT__NAME);
        }
        catch (TranslatorException e) {
            this.error(e);
        }
        finally {
            if (pushed) {
                this.resolver.popModel();
            }
        }
        ((ExpressionTranslator)this.getExpressionTranslator()).enactIvmlWarnings();
        return result;
    }

    protected void processGlobalVariableDeclarations(List<EObject> elts, Template result) {
        List<de.uni_hildesheim.sse.vil.expressions.expressionDsl.VariableDeclaration> decls = ModelTranslator.select(elts, de.uni_hildesheim.sse.vil.expressions.expressionDsl.VariableDeclaration.class);
        this.processVariableDeclarations(decls, result);
    }

    private IndentationConfiguration processIndentHint(IndentationHint hint) {
        IndentationConfiguration result = null;
        if (null != hint) {
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            HashSet<String> assigned = new HashSet<String>();
            values.put("indentation", -1);
            values.put("tabEmulation", -1);
            values.put("additional", 1);
            for (IndentationHintPart part : hint.getParts()) {
                String name = part.getName();
                if (!values.containsKey(name)) {
                    this.warning("indentation entry '" + name + "' is unknown - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME, 20207);
                    continue;
                }
                if (assigned.contains(name)) {
                    this.warning("indentation entry '" + name + "' is already specified - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME, 20207);
                    continue;
                }
                try {
                    int value = Integer.parseInt(part.getValue());
                    if (value < 0) {
                        this.warning("indentation value is negative - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME, 20207);
                    }
                    values.put(name, value);
                    assigned.add(name);
                }
                catch (NumberFormatException e) {
                    this.warning("indentation value is not an integer - igored", part, (EStructuralFeature)TemplateLangPackage.Literals.INDENTATION_HINT_PART__NAME, 20207);
                }
            }
            result = new IndentationConfiguration((Integer)values.get("indentation"), (Integer)values.get("tabEmulation"), (Integer)values.get("additional"));
        }
        return result;
    }

    private FormattingConfiguration processFormattingHint(FormattingHint hint) {
        FormattingConfiguration result = null;
        if (null != hint) {
            for (FormattingHintPart part : hint.getParts()) {
                if (!"lineEnd".equals(part.getName())) continue;
                result = new FormattingConfiguration();
                String value = StringUtils.convertString(part.getValue());
                result.setLineEnding(value);
            }
        }
        return result;
    }

    protected void reProcessGlobalVariableDeclarations(Template model) {
        for (int v = 0; v < model.getVariableDeclarationCount(); ++v) {
            try {
                ((ExpressionTranslator)this.getExpressionTranslator()).reProcessVariableDeclaration(model.getVariableDeclaration(v), this.resolver);
                continue;
            }
            catch (TranslatorException e) {
                this.error(e);
            }
        }
    }

    private void processJavaExtensions(LanguageUnit tpl, TemplateDescriptor desc) throws TranslatorException {
        int extCount = TemplateLangExecution.getDefaultExtensionCount();
        EList<Extension> exts = tpl.getJavaExts();
        if (extCount > 0 || null != exts) {
            HashSet<String> knownTypes = new HashSet<String>();
            HashSet<String> knownSignatures = new HashSet<String>();
            Iterator<TypeDescriptor<?>> iter = this.resolver.getTypeRegistry().allTypes().iterator();
            while (iter.hasNext()) {
                knownTypes.add(iter.next().getName());
            }
            for (int e = 0; e < extCount; ++e) {
                desc.addJavaExtension(this.processJavaExtension(TemplateLangExecution.getDefaultExtension(e), knownTypes, knownSignatures, tpl, (EStructuralFeature)TemplateLangPackage.Literals.LANGUAGE_UNIT__JAVA_EXTS));
            }
            if (null != exts) {
                for (Extension ext : exts) {
                    desc.addJavaExtension(this.processJavaExtension(ext, knownTypes, knownSignatures));
                }
            }
        }
    }

    private JavaExtension processJavaExtension(Extension ext, Set<String> knownTypes, Set<String> knownSignatures) throws TranslatorException {
        JavaExtension javaExt;
        try {
            javaExt = new JavaExtension(ModelTranslator.getJavaQualifiedNameString(ext.getName()), this.resolver.getTypeRegistry());
            this.processJavaExtension(javaExt, knownTypes, knownSignatures, ext, (EStructuralFeature)TemplateLangPackage.Literals.EXTENSION__NAME);
        }
        catch (VilException e) {
            throw new TranslatorException(e, ext, (EStructuralFeature)TemplateLangPackage.Literals.EXTENSION__NAME);
        }
        return javaExt;
    }

    private JavaExtension processJavaExtension(JavaExtension javaExt, Set<String> knownTypes, Set<String> knownSignatures, EObject cause, EStructuralFeature causingFeature) throws TranslatorException {
        IMetaType resolved = javaExt.getResolved();
        if (null != resolved) {
            String typeName = resolved.getName();
            if (!knownTypes.contains(typeName)) {
                knownTypes.add(typeName);
                for (int o = 0; o < resolved.getOperationsCount(); ++o) {
                    String sig = resolved.getOperation(o).getJavaSignature();
                    if (knownSignatures.contains(sig)) {
                        throw new TranslatorException("signature " + sig + " in type " + typeName + " is already known", cause, causingFeature, 20205);
                    }
                    knownSignatures.add(sig);
                }
            } else {
                throw new TranslatorException("type " + typeName + " is already known", cause, causingFeature, 20205);
            }
        }
        return javaExt;
    }

    public static String getJavaQualifiedNameString(JavaQualifiedName name) {
        StringBuilder result = new StringBuilder();
        for (String s : name.getQname()) {
            result.append(s);
        }
        return result.toString();
    }

    @Override
    protected ModelManagement<Template> getManagementInstance() {
        return TemplateModel.INSTANCE;
    }

    protected void processDefs(List<EObject> elts, Template template) {
        HashMap<String, DefInfo> signatures = new HashMap<String, DefInfo>();
        List<VilDef> defs = ModelTranslator.select(elts, VilDef.class);
        for (int d = 0; d < defs.size(); ++d) {
            try {
                VilDef vilDef = defs.get(d);
                Def def = this.processDef(defs.get(d), template);
                String fSig = def.getSignature() + "[" + template.getName() + ']';
                if (signatures.containsKey(fSig)) {
                    this.error("duplicated template definition", vilDef, (EStructuralFeature)TemplateLangPackage.Literals.VIL_DEF__ID, 20205);
                    continue;
                }
                DefInfo info = new DefInfo(vilDef, def);
                signatures.put(fSig, info);
                template.addDef(def);
                continue;
            }
            catch (TranslatorException e) {
                this.error(e);
            }
        }
        for (DefInfo info : signatures.values()) {
            try {
                this.processDefBody(info);
            }
            catch (TranslatorException e) {
                this.error(e);
            }
        }
    }

    private Def processDef(VilDef def, Template template) throws TranslatorException {
        VariableDeclaration[] param = (VariableDeclaration[])this.resolveParameters(def.getParam(), def, (EStructuralFeature)TemplateLangPackage.Literals.VIL_DEF__PARAM, this.resolver);
        TypeDescriptor<?> specifiedType = null;
        if (null != def.getType()) {
            specifiedType = ((ExpressionTranslator)this.getExpressionTranslator()).processType(def.getType(), this.resolver);
        }
        Def result = new Def(def.getId(), param, null, specifiedType, template);
        if (null != def.getProtected()) {
            result.setProtected(true);
        }
        return result;
    }

    private void processDefBody(DefInfo info) throws TranslatorException {
        Def def = info.getDef();
        VilDef vilDef = info.getVilDef();
        this.resolver.pushLevel();
        for (int p = 0; p < def.getParameterCount(); ++p) {
            this.resolver.add(def.getParameter(p));
        }
        def.setBody(this.processBlock(vilDef.getStmts()));
        try {
            def.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException(e, vilDef, (EStructuralFeature)TemplateLangPackage.Literals.VIL_DEF__STMTS);
        }
        finally {
            this.resolver.popLevel();
        }
    }

    private ITemplateElement[] processBlock(StmtBlock block) {
        ITemplateElement[] result = null;
        if (null != block && null != block.getStmts() && !block.getStmts().isEmpty()) {
            ArrayList<ITemplateElement> tmp = new ArrayList<ITemplateElement>();
            for (Stmt stmt : block.getStmts()) {
                try {
                    tmp.add(this.processStatement(stmt));
                }
                catch (TranslatorException e) {
                    this.error(e);
                }
            }
            if (!tmp.isEmpty()) {
                result = new ITemplateElement[tmp.size()];
                tmp.toArray(result);
            }
        }
        return result;
    }

    private ITemplateElement processStatement(Stmt stmt) throws TranslatorException {
        ITemplateElement result = null;
        if (null != stmt) {
            if (null != stmt.getAlt()) {
                result = this.processAlternative(stmt.getAlt());
            } else if (null != stmt.getCtn()) {
                result = this.processContent(stmt.getCtn(), this.resolver);
            } else if (null != stmt.getExprStmt()) {
                result = (ITemplateElement)this.expressionTranslator.processExpressionStatement(stmt.getExprStmt(), this.resolver);
            } else if (null != stmt.getLoop()) {
                result = this.processLoop(stmt.getLoop());
            } else if (null != stmt.getWhile()) {
                result = this.processWhile(stmt.getWhile());
            } else if (null != stmt.getFlush()) {
                result = this.processFlush();
            } else if (null != stmt.getMulti()) {
                this.warning("multi selection is currently not supported", stmt.getMulti(), (EStructuralFeature)TemplateLangPackage.Literals.STMT__MULTI, 0);
            } else if (null != stmt.getSwitch()) {
                result = this.processSwitch(stmt.getSwitch());
            } else if (null != stmt.getVar()) {
                result = (ITemplateElement)((ExpressionTranslator)this.getExpressionTranslator()).processVariableDeclaration(stmt.getVar(), this.resolver);
            }
        }
        return result;
    }

    private ITemplateElement processStatementOrStmtBlock(Stmt stmt, StmtBlock block) throws TranslatorException {
        ITemplateElement result = null;
        if (null != stmt) {
            result = this.processStatement(stmt);
        } else if (null != block) {
            this.resolver.pushLevel();
            result = new TemplateBlock(this.processBlock(block));
            this.resolver.popLevel();
        }
        return result;
    }

    private AlternativeStatement processAlternative(Alternative alt) throws TranslatorException {
        ITemplateElement elseElt;
        Expression condition = this.expressionTranslator.processExpression(alt.getExpr(), this.resolver);
        condition = this.expressionTranslator.assertBooleanExpression(condition, alt, (EStructuralFeature)TemplateLangPackage.Literals.ALTERNATIVE__EXPR);
        this.resolver.pushLevel();
        ITemplateElement ifElt = this.processStatementOrStmtBlock(alt.getIf(), alt.getIfBlock());
        this.resolver.popLevel();
        if (null != alt.getElse() || null != alt.getElseBlock()) {
            this.resolver.pushLevel();
            elseElt = this.processStatementOrStmtBlock(alt.getElse(), alt.getElseBlock());
            this.resolver.popLevel();
        } else {
            elseElt = null;
        }
        try {
            return new AlternativeStatement(condition, ifElt, elseElt);
        }
        catch (VilException e) {
            throw new TranslatorException(e, alt, (EStructuralFeature)TemplateLangPackage.Literals.ALTERNATIVE__EXPR);
        }
    }

    private Expression processSeparatorExpression(PrimaryExpression ex) throws TranslatorException {
        Expression result = null != ex ? this.expressionTranslator.processPrimaryExpression(ex, this.resolver) : null;
        return result;
    }

    private WhileStatement processWhile(While loop) throws TranslatorException {
        Expression loopExpression = this.expressionTranslator.processExpression(loop.getExpr(), this.resolver);
        loopExpression = this.expressionTranslator.assertBooleanExpression(loopExpression, loop, (EStructuralFeature)TemplateLangPackage.Literals.WHILE__EXPR);
        this.resolver.pushLevel();
        ITemplateElement stmt = null;
        try {
            stmt = this.processStatementOrStmtBlock(loop.getStmt(), loop.getBlock());
        }
        catch (TranslatorException e) {
            throw e;
        }
        finally {
            this.resolver.popLevel();
        }
        try {
            return new WhileStatement(loopExpression, stmt);
        }
        catch (VilException e) {
            throw new TranslatorException(e, loop, (EStructuralFeature)TemplateLangPackage.Literals.WHILE__EXPR);
        }
    }

    private FlushStatement processFlush() throws TranslatorException {
        return new FlushStatement();
    }

    private LoopStatement processLoop(Loop loop) throws TranslatorException {
        TypeDescriptor<?> p0Type;
        Expression loopExpression = this.expressionTranslator.processExpression(loop.getExpr(), this.resolver);
        IMetaType exprType = null;
        try {
            exprType = loopExpression.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException(e, loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__EXPR);
        }
        if (!((TypeDescriptor)exprType).isCollection() && !((TypeDescriptor)exprType).isIterator()) {
            OperationDescriptor conversion = ((TypeDescriptor)exprType).getConversionToSequence();
            if (null == conversion) {
                throw new TranslatorException("loop expression must be of type collection rather than " + ((TypeDescriptor)exprType).getVilName(), loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__EXPR, 20203);
            }
            exprType = conversion.getReturnType();
        }
        if (0 == ((TypeDescriptor)exprType).getGenericParameterCount()) {
            throw new TranslatorException("loop expression is not generic", loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__EXPR, 20203);
        }
        TypeDescriptor<?> type = this.expressionTranslator.processType(loop.getType(), this.resolver);
        if (!type.isAssignableFrom(p0Type = ((TypeDescriptor)exprType).getGenericParameterType(0)) && null == p0Type.findConversion(p0Type, type)) {
            throw new TranslatorException("loop variable type " + type.getVilName() + " must match the element type of the collection " + ((TypeDescriptor)exprType).getVilName(), loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__EXPR, 20203);
        }
        Expression separatorEx = this.processSeparatorExpression(loop.getSeparator());
        Expression finalSeparatorEx = this.processSeparatorExpression(loop.getFinalSeparator());
        VariableDeclaration iteratorVar = new VariableDeclaration(loop.getId(), type);
        ITemplateElement stmt = null;
        this.resolver.pushLevel();
        this.resolver.add(iteratorVar);
        try {
            stmt = this.processStatementOrStmtBlock(loop.getStmt(), loop.getBlock());
        }
        catch (TranslatorException e) {
            throw e;
        }
        finally {
            this.resolver.popLevel();
        }
        try {
            return new LoopStatement(iteratorVar, loopExpression, stmt, separatorEx, finalSeparatorEx);
        }
        catch (VilException e) {
            throw new TranslatorException(e, loop, (EStructuralFeature)TemplateLangPackage.Literals.LOOP__ID);
        }
    }

    private SwitchStatement processSwitch(Switch swtch) throws TranslatorException {
        Object commonConditionType;
        VariableDeclaration switchVar;
        TypeDescriptor<?> switchExpressionType;
        Expression switchExpression = this.expressionTranslator.processExpression(swtch.getExpr(), this.resolver);
        try {
            switchExpressionType = switchExpression.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException(e, swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__EXPR);
        }
        this.resolver.pushLevel();
        ArrayList<SwitchStatement.Alternative> alternatives = new ArrayList<SwitchStatement.Alternative>();
        int loop = 1;
        do {
            switchVar = new VariableDeclaration("VALUE", switchExpressionType);
            this.resolver.add(switchVar);
            commonConditionType = null;
            for (SwitchPart part : swtch.getParts()) {
                TypeDescriptor<?> conditionType;
                Expression condition = this.expressionTranslator.processExpression(part.getLeft(), this.resolver);
                try {
                    conditionType = condition.inferType();
                }
                catch (VilException e) {
                    this.resolver.popLevel();
                    throw new TranslatorException(e, part, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH_PART__LEFT);
                }
                Expression value = this.expressionTranslator.processExpression(part.getRight(), this.resolver);
                try {
                    condition.inferType();
                }
                catch (VilException e) {
                    this.resolver.popLevel();
                    throw new TranslatorException(e, part, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH_PART__RIGHT);
                }
                alternatives.add(new SwitchStatement.Alternative(condition, value));
                if (null != commonConditionType && !conditionType.isAssignableFrom((TypeDescriptor<?>)commonConditionType)) continue;
                commonConditionType = conditionType;
            }
            if (null != swtch.getDflt()) {
                Expression expr = this.expressionTranslator.processExpression(swtch.getDflt(), this.resolver);
                try {
                    expr.inferType();
                }
                catch (VilException e) {
                    this.resolver.popLevel();
                    throw new TranslatorException(e, swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__DFLT);
                }
                alternatives.add(new SwitchStatement.Alternative(expr));
            }
            if (switchExpressionType.isAssignableFrom((TypeDescriptor<?>)commonConditionType) || IvmlTypes.decisionVariableType().isAssignableFrom(switchExpressionType)) break;
            OperationDescriptor convOp = switchExpressionType.findConversion(switchExpressionType, (TypeDescriptor<?>)commonConditionType);
            if (null == convOp) {
                throw new TranslatorException("Cannot convert from switch expression of type " + switchExpressionType.getVilName() + " to the (common) case expression type " + ((TypeDescriptor)commonConditionType).getVilName(), swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__EXPR, 30006);
            }
            try {
                switchExpression = new CallExpression(convOp, new CallArgument(switchExpression));
                switchExpressionType = switchExpression.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException(e, swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__EXPR);
            }
            this.resolver.remove(switchVar);
            alternatives.clear();
        } while (++loop < 3);
        try {
            commonConditionType = new SwitchStatement(switchExpression, switchVar, alternatives);
            return commonConditionType;
        }
        catch (VilException e) {
            throw new TranslatorException(e, swtch, (EStructuralFeature)TemplateLangPackage.Literals.SWITCH__EXPR);
        }
        finally {
            this.resolver.popLevel();
        }
    }

    private ContentStatement processContent(Content content, Resolver resolver) throws TranslatorException {
        Expression indentExpr = null != content.getIndent() ? ((ExpressionTranslator)this.getExpressionTranslator()).processExpression(content.getIndent(), resolver) : null;
        try {
            String text = content.getCtn();
            String terminal = text.substring(0, 1);
            text = StringUtils.convertString(text);
            StringBuilder warnings = new StringBuilder();
            IvmlMessageAdapter localRcv = new IvmlMessageAdapter();
            IvmlMessageAdapter oldRcv = this.expressionTranslator.setIvmlMessageAdapter(localRcv);
            CompositeExpression tmp = (CompositeExpression)StringResolver.substitute(text, resolver, this.expressionTranslator, warnings, StringResolverFactory.INSTANCE);
            this.expressionTranslator.setIvmlMessageAdapter(oldRcv);
            localRcv.processAndClear(e -> StringResolver.appendWarning(warnings, VariableExpression.composeUnkownVariableWarning(((VarModelIdentifierExpression)e.getKey()).getIdentifier())));
            if (warnings.length() > 0) {
                this.warning(warnings.toString(), content, (EStructuralFeature)TemplateLangPackage.Literals.CONTENT__CTN, 0);
            }
            ContentStatement.LineEndType leType = null == content.getCR() ? ContentStatement.LineEndType.DEFAULT : (null == content.getNoCR() ? ContentStatement.LineEndType.LINE_END : ContentStatement.LineEndType.NO_LINE_END);
            return new ContentStatement(tmp, terminal, indentExpr, leType, (ILanguageElement)((Object)resolver.getCurrentModel()));
        }
        catch (VilException e2) {
            throw new TranslatorException(e2, content, (EStructuralFeature)TemplateLangPackage.Literals.CONTENT__INDENT);
        }
    }

    void error(VilException exception, EObject cause, EStructuralFeature causeFeature) {
        this.expressionTranslator.error(exception, cause, causeFeature);
    }

    void warning(VilException exception, EObject cause, EStructuralFeature causeFeature) {
        this.expressionTranslator.warning(exception, cause, causeFeature);
    }

    protected VariableDeclaration[] createArray(int len) {
        return new VariableDeclaration[len];
    }

    @Override
    protected void addVisibleDeclarationsToResolver(Template model, Resolver resolver) {
        for (int v = 0; v < model.getVariableDeclarationCount(); ++v) {
            VariableDeclaration decl = model.getVariableDeclaration(v);
            if (resolver.contains(decl)) continue;
            resolver.add(decl);
        }
    }

    @Override
    protected Typedef createTypedef(String name, TypeDescriptor<?> type) throws VilException {
        return new TypeDef(name, type, (Template)((Resolver)this.getResolver()).getCurrentModel());
    }

    @Override
    protected Compound createCompound(CompoundTypeDescriptor type) throws VilException {
        return new Compound(type, (Template)((Resolver)this.getResolver()).getCurrentModel());
    }
}

