/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics;

import java.io.File;
import java.net.URL;

public class Environment {
    private Environment() {
    }

    public static boolean runsInEclipse() {
        boolean result;
        if (null != System.getProperty("easy.notInEclipse", null)) {
            result = false;
        } else {
            String eclipseVersion = System.getProperty("eclipse.buildId", "");
            int major = Environment.parseVersionPart(eclipseVersion, 0);
            int minor = Environment.parseVersionPart(eclipseVersion, 1);
            boolean bl = result = (null != System.getProperty("eclipse.product", null) || null != System.getProperty("eclipse.home.location", null)) && null != System.getProperty("eclipse.pde.launch");
            if (major >= 4 && minor >= 7) {
                result &= System.getProperty("eclipse.product", "").indexOf("junit") < 0;
            }
        }
        return result;
    }

    private static int parseVersionPart(String version, int part) {
        int result;
        int pos = 0;
        for (int count = 0; count < part && pos >= 0 && pos < version.length(); ++count) {
            pos = version.indexOf(46, pos + 1);
        }
        if (pos >= 0 && pos < version.length()) {
            int nextPos;
            if (version.charAt(pos) == '.') {
                ++pos;
            }
            version = (nextPos = version.indexOf(46, pos + 1)) > 0 ? version.substring(pos, nextPos) : version.substring(pos);
        }
        try {
            result = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            result = 0;
        }
        return result;
    }

    public static boolean isWinOS() {
        return System.getProperty("os.name").contains("win") || System.getProperty("os.name").contains("Win");
    }

    public static File toFile(URL localURL) {
        String path = localURL.getPath();
        return new File(path);
    }
}

