/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class FileUtils {
    public static boolean isFileURI(URI uri) {
        return null != uri && "file".equals(uri.getScheme());
    }

    public static boolean isFileURL(URL url) {
        return null != url && "file".equals(url.getProtocol());
    }

    public static void copyFile(File target, File source) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            FileUtils.copyToFile(target, in);
            in.close();
        }
        catch (IOException e) {
            if (null != in) {
                FileUtils.closeQuietly(in);
            }
            throw e;
        }
    }

    public static void copyToFile(File file, InputStream in) throws IOException {
        FileUtils.copyToFile(file, in, null);
    }

    public static void copyToFile(File file, InputStream in, byte[] buffer) throws IOException {
        if (null == buffer) {
            buffer = new byte[1024];
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            int read;
            do {
                if ((read = in.read(buffer)) <= 0) continue;
                fos.write(buffer, 0, read);
            } while (read > 0);
        }
        catch (IOException e) {
            FileUtils.closeQuietly(fos);
            throw e;
        }
        fos.close();
    }

    public static void closeQuietly(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void createIfNotExists(File file) {
        if (null != file && !file.exists()) {
            file.mkdirs();
        }
    }

    public static File createTmpDir(String name) {
        return FileUtils.createTmpDir(name, true);
    }

    public static File createTmpDir(String name, boolean deleteIfExists) {
        File result;
        String tmp = System.getProperty("java.io.tempdir");
        if (null == tmp) {
            try {
                File f = File.createTempFile("easy", "tmp");
                result = f.getParentFile();
                f.delete();
            }
            catch (IOException e) {
                result = new File("tmp");
                result.mkdirs();
            }
        } else {
            result = new File(tmp);
        }
        if (null != name) {
            result = new File(result, name);
        }
        if (deleteIfExists && result.exists()) {
            result.delete();
        }
        FileUtils.createIfNotExists(result);
        result.deleteOnExit();
        return result;
    }
}

