/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.logger;

import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.ssehub.easy.basics.logger.DebugLevel;
import net.ssehub.easy.basics.logger.ExceptionLevel;
import net.ssehub.easy.basics.logger.ILogger;
import net.ssehub.easy.basics.logger.LogFormatter;

public abstract class AbstractJavaLogger
implements ILogger {
    public static final Level DEBUG_LEVEL = new DebugLevel();
    public static final Level EXCEPTION_LEVEL = new ExceptionLevel();
    protected static final LogFormatter LOG_FORMATTER = new LogFormatter();
    protected static final Level DEFAULT_LEVEL = Level.ALL;

    protected static final Logger createLogger(Class<? extends AbstractJavaLogger> loggerClass, String appendix) {
        String name = loggerClass.getSimpleName();
        if (null != appendix) {
            name = name + appendix;
        }
        Logger logger = Logger.getLogger(name);
        logger.setLevel(DEFAULT_LEVEL);
        logger.setUseParentHandlers(false);
        return logger;
    }

    protected class ConsoleHandler
    extends Handler {
        private PrintStream console;

        protected ConsoleHandler() {
            this.setConsole(System.err);
            this.setFormatter(LOG_FORMATTER);
            this.setLevel(DEFAULT_LEVEL);
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                String msg = null;
                msg = null != this.getFormatter() ? this.getFormatter().format(record) : record.getMessage();
                this.console.print(msg);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        public void setConsole(PrintStream console) {
            if (console == System.out || console == System.err) {
                this.console = console;
            }
        }
    }
}

