/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class LogFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        Date date = new Date(record.getMillis());
        sb.append("[" + DATE_FORMAT.format(date)).append("]\t");
        sb.append("[" + record.getLevel() + "]\t").append(this.formatMessage(record));
        sb.append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    private void appendEclipseDebugLink(LogRecord record, StringBuilder sb) {
        String fileName;
        String className = record.getMessage().substring(1, record.getMessage().indexOf("]"));
        StackTraceElement callerFrame = this.getCallerStackFrame(className);
        String string = fileName = null != callerFrame ? callerFrame.getFileName() : null;
        if (null != fileName) {
            int lineNumber = callerFrame.getLineNumber();
            sb.append(" (");
            sb.append(fileName);
            if (-1 != lineNumber) {
                sb.append(":");
                sb.append(lineNumber);
            }
            sb.append(")");
        }
    }

    private StackTraceElement getCallerStackFrame(String callerName) {
        StackTraceElement callerFrame = null;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement frame = stack[i];
            if (!frame.getClassName().endsWith(callerName)) continue;
            callerFrame = frame;
            break;
        }
        return callerFrame;
    }
}

