/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.messages;

import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Status;

public class Message
implements IMessage {
    private String description;
    private Status status;

    public Message(String description, Status status) {
        this.description = description;
        this.status = status;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDetailedDescription() {
        return this.description;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public static boolean containsError(List<Message> messages) {
        boolean hasError = false;
        if (null != messages) {
            for (int m = 0; !hasError && m < messages.size(); ++m) {
                hasError = Status.ERROR == messages.get(m).getStatus();
            }
        }
        return hasError;
    }

    public static String toString(List<Message> messages, Status filter) {
        StringBuilder result = new StringBuilder();
        if (null != messages) {
            int count = 0;
            for (int m = 0; m < messages.size(); ++m) {
                Message msg = messages.get(m);
                if (null != filter && filter != msg.getStatus()) continue;
                if (count > 0) {
                    result.append(", ");
                }
                result.append(msg.getStatus());
                result.append(":");
                result.append(msg.getDescription());
            }
        }
        return result.toString();
    }
}

