/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ModelInitializer;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;

public abstract class AbstractModelInitializer<M extends IModel>
implements ModelInitializer.IModelInitializer {
    protected abstract ModelManagement<M> getModelManagement();

    protected abstract IModelLoader<M> getModelLoader();

    public static File stripFile(File file) {
        if (file.isFile()) {
            file = file.getParentFile();
        }
        return file;
    }

    @Override
    public void addLocation(File location, ProgressObserver observer) throws ModelManagementException {
        this.getModelManagement().locations().addLocation(AbstractModelInitializer.stripFile(location), observer);
    }

    @Override
    public void addLocationToFront(File location, ProgressObserver observer) throws ModelManagementException {
        this.getModelManagement().locations().addLocationToFront(AbstractModelInitializer.stripFile(location), observer);
    }

    @Override
    public void removeLocation(File location, ProgressObserver observer) throws ModelManagementException {
        this.getModelManagement().locations().removeLocation(AbstractModelInitializer.stripFile(location), observer);
    }

    @Override
    public void registerLoader(ProgressObserver observer) throws ModelManagementException {
        IModelLoader<M> loader = this.getModelLoader();
        if (null != loader) {
            this.getModelManagement().loaders().registerLoader(loader, observer);
        }
    }

    @Override
    public void unregisterLoader(ProgressObserver observer) throws ModelManagementException {
        IModelLoader<M> loader = this.getModelLoader();
        if (null != loader) {
            this.getModelManagement().loaders().unregisterLoader(loader, observer);
        }
    }
}

