/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelManagementRepository;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;

public class AvailableModels<M extends IModel> {
    private Map<String, List<VersionedModelInfos<M>>> availableModels = new LinkedHashMap<String, List<VersionedModelInfos<M>>>();
    private Map<URI, ModelInfo<M>> tmpInfo = null;

    AvailableModels(IModelManagementRepository<M> repository) {
    }

    void clear() {
        this.availableModels.clear();
    }

    Collection<List<VersionedModelInfos<M>>> versionedModelInfos() {
        return this.availableModels.values();
    }

    Set<String> modelNames() {
        return this.availableModels.keySet();
    }

    boolean updateAvailableModel(ModelInfo<M> info) {
        boolean inconsistent = false;
        String name = info.getName();
        Version version = info.getVersion();
        List<VersionedModelInfos<M>> infoSameName = this.availableModels.get(name);
        if (null == infoSameName) {
            infoSameName = new ArrayList<VersionedModelInfos<M>>();
            this.availableModels.put(name, infoSameName);
        }
        boolean found = false;
        VersionedModelInfos<M> vInfos = VersionedModelInfos.find(infoSameName, version);
        if (null == vInfos) {
            vInfos = new VersionedModelInfos(version);
            infoSameName.add(vInfos);
        }
        for (int i = 0; !found && i < vInfos.size(); ++i) {
            ModelInfo<int> tmp = vInfos.get((M)i);
            if (!Utils.matches(info, tmp) || tmp.getLoader() != info.getLoader() || !tmp.getLocation().equals(info.getLocation())) continue;
            found = true;
        }
        if (!found) {
            vInfos.add(info);
        }
        return inconsistent;
    }

    public synchronized int getModelInfoCount(boolean differURIs) {
        int count = 0;
        for (List<VersionedModelInfos<M>> vInfos : this.availableModels.values()) {
            if (differURIs) {
                for (int v = 0; v < vInfos.size(); ++v) {
                    count += vInfos.get(v).size();
                }
                continue;
            }
            count += vInfos.size();
        }
        return count;
    }

    public ModelInfo<M> getInfo(URI uri) {
        List<ModelInfo<M>> visible = this.getVisibleModelInfo(uri);
        ModelInfo<M> found = null;
        for (int v = 0; null == found && v < visible.size(); ++v) {
            if (!visible.get(v).getLocation().equals(uri)) continue;
            found = visible.get(v);
        }
        if (null == found && null != this.tmpInfo) {
            found = this.tmpInfo.get(uri);
        }
        return found;
    }

    public List<ModelInfo<M>> getVisibleModelInfo(URI uri) {
        return this.getVisibleModelInfo(null, null, uri);
    }

    public synchronized List<ModelInfo<M>> getVisibleModelInfo(String name, Version version, URI uri) {
        ArrayList<ModelInfo<M>> result = new ArrayList<ModelInfo<M>>();
        for (List<VersionedModelInfos<M>> vInfos : this.availableModels.values()) {
            int vInfosSize = vInfos.size();
            for (int i = 0; i < vInfosSize; ++i) {
                ModelInfo<M> info = vInfos.get(i).getByClosestUri(uri, null);
                if (null == info || null != name && (!name.equals(info.getName()) || !Version.equals(info.getVersion(), version))) continue;
                result.add(info);
            }
        }
        return result;
    }

    public synchronized List<ModelInfo<M>> getVisibleModelInfo(String name, URI uri) {
        ArrayList<ModelInfo<M>> result = new ArrayList<ModelInfo<M>>();
        for (List<VersionedModelInfos<M>> vInfos : this.availableModels.values()) {
            int vInfosSize = vInfos.size();
            for (int i = 0; i < vInfosSize; ++i) {
                ModelInfo<M> info = vInfos.get(i).getByClosestUri(uri, null);
                if (null == info || null != name && !name.equals(info.getName())) continue;
                result.add(info);
            }
        }
        return result;
    }

    List<ModelInfo<M>> getModelInfoWith(URI uri) {
        ArrayList<ModelInfo<M>> result = null;
        if (null != uri) {
            for (List<VersionedModelInfos<M>> vInfos : this.availableModels.values()) {
                int vInfosSize = vInfos.size();
                for (int i = 0; i < vInfosSize; ++i) {
                    List<ModelInfo<M>> tmp = vInfos.get(i).getByEqualUri(uri);
                    if (null == tmp) continue;
                    if (null == result) {
                        result = new ArrayList<ModelInfo<M>>();
                    }
                    result.addAll(tmp);
                }
            }
        }
        return result;
    }

    public synchronized ModelInfo<M> getResolvedModelInfo(M model, URI uri) {
        VersionedModelInfos<M> vInfo;
        ModelInfo<M> result = null;
        if (null != model && null != (vInfo = VersionedModelInfos.find(this.availableModels.get(model.getName()), model.getVersion()))) {
            result = vInfo.getByClosestUri(uri, null);
        }
        return result;
    }

    public synchronized ModelInfo<M> getResolvedModelInfo(M model) {
        VersionedModelInfos<M> vInfo;
        ModelInfo<M> result = null;
        if (null != model && null != (vInfo = VersionedModelInfos.find(this.availableModels.get(model.getName()), model.getVersion()))) {
            result = vInfo.get(model);
        }
        return result;
    }

    public synchronized ModelInfo<M> getModelInfo(String name, Version version, URI uri) {
        ModelInfo<M> foundInfo = null;
        List<VersionedModelInfos<M>> vList = this.availableModels.get(name);
        VersionedModelInfos<M> vInfos = VersionedModelInfos.find(vList, version);
        if (null != vInfos) {
            foundInfo = vInfos.find(uri);
        }
        return foundInfo;
    }

    public synchronized List<ModelInfo<M>> getModelInfo(String name, Version version) {
        ArrayList result = null;
        VersionedModelInfos vInfo = VersionedModelInfos.find(this.availableModels.get(name), version);
        if (null != vInfo) {
            result = new ArrayList();
            vInfo.toList(result);
        }
        return result;
    }

    public synchronized List<ModelInfo<M>> getModelInfos(M model) {
        return null == model ? null : this.getModelInfo(model.getName(), model.getVersion());
    }

    public synchronized ModelInfo<M> getModelInfo(M model) {
        ModelInfo<M> result = null;
        List<ModelInfo<M>> info = this.getModelInfos(model);
        if (null != info) {
            int size = info.size();
            for (int i = 0; null == result && i < size; ++i) {
                ModelInfo<M> pInfo = info.get(i);
                if (pInfo.getResolved() != model) continue;
                result = pInfo;
            }
        }
        return result;
    }

    public synchronized List<ModelInfo<M>> getModelInfo(String name, String version) throws VersionFormatException {
        return this.getModelInfo(name, new Version(version));
    }

    public synchronized boolean hasModelInfo(String name) {
        return this.availableModels.containsKey(name);
    }

    public synchronized List<ModelInfo<M>> getModelInfo(String name) {
        ArrayList result;
        List<VersionedModelInfos<M>> vInfo = this.availableModels.get(name);
        if (null != vInfo && vInfo.size() > 0) {
            result = new ArrayList();
            for (int i = 0; i < vInfo.size(); ++i) {
                vInfo.get(i).toList(result);
            }
        } else {
            result = null;
        }
        return result;
    }

    public synchronized ModelInfo<M> getModelInfo(ModelInfo<M> info) {
        ModelInfo<M> result = null;
        VersionedModelInfos<M> vInfo = VersionedModelInfos.find(this.availableModels.get(info.getName()), info.getVersion());
        if (null != vInfo) {
            result = vInfo.get(info.getLocation());
        }
        return result;
    }

    public synchronized M getModel(String name, String version, URI uri) throws VersionFormatException {
        ModelInfo<M> info = this.getModelInfo(name, version, uri);
        M result = null != info ? (M)info.getResolved() : null;
        return result;
    }

    public synchronized M getModel(String name, Version version, URI uri) throws VersionFormatException {
        ModelInfo<M> info = this.getModelInfo(name, version, uri);
        M result = null != info ? (M)info.getResolved() : null;
        return result;
    }

    public synchronized ModelInfo<M> getModelInfo(String name, String version, URI uri) throws VersionFormatException {
        Version ver = null == version ? null : new Version(version);
        return this.getModelInfo(name, ver, uri);
    }

    List<VersionedModelInfos<M>> getAvailable(String name) {
        return this.availableModels.get(name);
    }

    void putAvailable(String name, List<VersionedModelInfos<M>> infos) {
        this.availableModels.put(name, infos);
    }

    void removeAvailable(String name) {
        this.availableModels.remove(name);
    }

    void removeAvailable(ModelInfo<M> info) {
        List<VersionedModelInfos<M>> infos = this.availableModels.get(info.getName());
        VersionedModelInfos<M> vInfs = VersionedModelInfos.find(infos, info.getVersion());
        if (null != vInfs) {
            vInfs.remove(info);
            if (0 == vInfs.size()) {
                infos.remove(vInfs);
            }
        }
    }

    public ModelInfo<M> createTempInfo(M model, URI location) {
        ModelInfo<M> result = new ModelInfo<M>(model, location);
        result.setResolved(model);
        if (null == this.tmpInfo) {
            this.tmpInfo = new HashMap<URI, ModelInfo<M>>();
        }
        this.tmpInfo.put(location, result);
        return result;
    }

    public void releaseTempInfo(ModelInfo<M> info) {
        if (null != info && null != this.tmpInfo && null != info.getLocation()) {
            this.tmpInfo.remove(info.getLocation());
        }
    }

    public boolean isTempInfo(ModelInfo<M> info) {
        boolean result = false;
        if (null != info && null != this.tmpInfo && null != info.getLocation()) {
            result = this.tmpInfo.containsKey(info.getLocation());
        }
        return result;
    }
}

