/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelProcessingListener;
import net.ssehub.easy.basics.modelManagement.IModelRepository;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.ResolutionContext;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;

public class DefaultImportResolver<M extends IModel>
extends ImportResolver<M> {
    public static final boolean IMPORT_WITH_VERSION = true;
    private final ModelInfo<M> conflictMarker = new ModelInfo();
    private final Map<ModelInfo<M>, M> localModelOverride = new HashMap<ModelInfo<M>, M>();
    private boolean allowCycles;

    public DefaultImportResolver() {
        this(false);
    }

    public DefaultImportResolver(boolean allowCycles) {
        this.allowCycles = allowCycles;
    }

    @Override
    public void clear() {
        this.localModelOverride.clear();
        super.clear();
    }

    @Override
    public List<IMessage> resolveImports(M model, URI uri, List<ModelInfo<M>> inProgress, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) {
        ModelInfo<M> info = repository.getModelInfo(model.getName(), model.getVersion(), uri);
        if (null != info) {
            this.localModelOverride.put(info, model);
        }
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        ResolutionContext<M> context = new ResolutionContext<M>(model, uri, inProgress, repository, evaluationContext);
        HashSet done = new HashSet();
        List<ModelImport<M>> conflicts = this.resolveImports(context, done, messages);
        done.clear();
        if (!this.allowCycles) {
            this.checkImportCycles(model, messages, done);
        }
        try {
            if (null != conflicts || null != context.getConflict(model)) {
                messages.add(new Message("import conflict on model '" + model.getName() + "', cannot resolve the import", Status.ERROR));
            }
        }
        catch (RestrictionEvaluationException e) {
            messages.add(new Message(e.getMessage(), Status.ERROR));
        }
        if (null != info) {
            this.localModelOverride.put(info, model);
        }
        return messages;
    }

    private void checkImportCycles(M model, List<IMessage> messages, Set<M> done) {
        if (done.contains(model)) {
            messages.add(new Message("cyclic import of '" + model.getName() + "' is forbidden", Status.ERROR));
        } else {
            done.add(model);
            for (int i = 0; i < model.getImportsCount(); ++i) {
                ModelImport<?> imp = model.getImport(i);
                if (null == imp.getResolved()) continue;
                this.checkImportCycles(imp.getResolved(), messages, done);
            }
            done.remove(model);
        }
    }

    private List<ModelImport<M>> resolveImports(ResolutionContext<M> context, HashSet<M> done, List<IMessage> messages) {
        List<ModelImport<M>> conflicts = null;
        M model = context.getModel();
        if (done.contains(model)) {
            String ver = null == model.getVersion() ? "" : " version '" + model.getVersion().getVersion() + "'";
            messages.add(new Message("Cyclic import with '" + model.getName() + ver + ". Importing stopped here.", Status.ERROR));
        } else {
            ArrayList<ModelImport<M>> todo = new ArrayList<ModelImport<M>>();
            this.handleImports(context, model, todo);
            int lastBacktrack = -1;
            int i = 0;
            while (null == conflicts && lastBacktrack < 0 || lastBacktrack >= 0) {
                while (null == conflicts && i < todo.size()) {
                    ModelImport imp = (ModelImport)todo.get(i);
                    if (null == imp.getResolved()) {
                        context.setToResolve(imp);
                        conflicts = this.resolve(context, done, messages);
                    }
                    if (null != conflicts) continue;
                    ++i;
                }
                if (null == conflicts) break;
                lastBacktrack = lastBacktrack < 0 ? i - 1 : --lastBacktrack;
                if (lastBacktrack < 0) break;
                for (int j = i - 1; j >= lastBacktrack; --j) {
                    this.setUnresolved(context.getModel(), (ModelImport)todo.get(j), j == i - 1 ? null : conflicts);
                }
                i = lastBacktrack;
                conflicts = null;
            }
            for (i = 0; null == conflicts && i < todo.size(); ++i) {
                ModelImport imp = (ModelImport)todo.get(i);
                try {
                    ModelImport<M> conflict = context.getConflict(imp.getResolved());
                    if (null == conflict) continue;
                    String conflictMsg = "";
                    if (null != conflict.getVersionRestriction()) {
                        conflictMsg = " with " + conflict.getVersionRestriction().toSpecification();
                    }
                    messages.add(new Message("Import of '" + imp.getName() + "' conflicts '" + conflictMsg + "'", Status.ERROR));
                    continue;
                }
                catch (RestrictionEvaluationException e) {
                    messages.add(new Message(e.getMessage(), Status.ERROR));
                }
            }
        }
        return conflicts;
    }

    private void setUnresolved(M model, List<ModelImport<M>> conflicts) {
        for (int i = 0; i < model.getImportsCount(); ++i) {
            this.setUnresolved(model, model.getImport(i), conflicts);
        }
        this.setUnresolved(model, model.getSuper(), conflicts);
    }

    private void setUnresolved(M model, ModelImport<M> imp, List<ModelImport<M>> conflicts) {
        if (null != imp) {
            try {
                M resolved = imp.getResolved();
                if (null != resolved) {
                    boolean unresolve = false;
                    if (null != conflicts) {
                        for (int i = 0; unresolve && i < conflicts.size(); ++i) {
                            unresolve = conflicts.get(i).getResolved() == resolved;
                        }
                    } else {
                        unresolve = true;
                    }
                    if (unresolve) {
                        this.setUnresolved(resolved, conflicts);
                        imp.setResolved(null);
                    }
                }
            }
            catch (ModelManagementException e) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").exception(e);
            }
        }
    }

    private void handleImports(ResolutionContext<M> context, M model, List<ModelImport<M>> todo) {
        for (int i = 0; i < model.getImportsCount(); ++i) {
            this.handleImport(context, model.getImport(i), todo);
        }
        this.handleImport(context, model.getSuper(), todo);
    }

    private void handleImport(ResolutionContext<M> context, ModelImport<?> imp, List<ModelImport<M>> todo) {
        if (null != imp) {
            ModelImport<?> i = imp;
            if (i.isConflict()) {
                context.addConflict(i);
            } else if (null != todo) {
                todo.add(i);
            }
        }
    }

    private ModelInfo<M> determineMatching(ResolutionContext<M> context, List<VersionedModelInfos<M>> versions, IVersionRestriction restriction) throws ModelManagementException {
        ModelInfo result;
        int candidatesSize;
        ArrayList<ModelInfo<int>> candidates = new ArrayList<ModelInfo<int>>();
        boolean hasConflicts = false;
        if (null != versions) {
            int n = versions.size();
            for (int v = 0; v < n; ++v) {
                VersionedModelInfos<int> vInfos = versions.get(v);
                int vn = vInfos.size();
                for (int i = 0; i < vn; ++i) {
                    ModelInfo<int> info = vInfos.get(i);
                    try {
                        boolean isOk;
                        boolean bl = isOk = null == restriction || restriction.evaluate(context.getEvaluationContext(), info.getVersion());
                        if (!isOk) continue;
                        if (context.isConflict(info)) {
                            hasConflicts = true;
                            continue;
                        }
                        candidates.add(info);
                        continue;
                    }
                    catch (RestrictionEvaluationException e) {
                        throw new ModelManagementException(e.getMessage(), e.getId());
                    }
                }
            }
        }
        if (0 == (candidatesSize = candidates.size())) {
            result = hasConflicts ? this.conflictMarker : null;
        } else if (1 == candidatesSize) {
            result = (ModelInfo)candidates.get(0);
        } else {
            ModelInfo highest = (ModelInfo)candidates.get(0);
            for (int i = 1; i < candidatesSize; ++i) {
                ModelInfo info = (ModelInfo)candidates.get(i);
                Version iVersion = info.getVersion();
                if (null == highest.getVersion() && null != iVersion) {
                    highest = info;
                    continue;
                }
                if (null == iVersion || iVersion.compareTo(highest.getVersion()) <= 0) continue;
                highest = info;
            }
            result = highest;
            ArrayList tmp = new ArrayList();
            for (int i = 0; i < candidatesSize; ++i) {
                ModelInfo info = (ModelInfo)candidates.get(i);
                if (!Version.equals(highest.getVersion(), info.getVersion())) continue;
                tmp.add(info);
            }
            result = VersionedModelInfos.getByClosestUri(tmp, context.getModelURI(), context.getModelPaths());
            if (null == result) {
                result = highest;
            }
        }
        return result;
    }

    private List<ModelImport<M>> addConflict(List<ModelImport<M>> conflicts, ModelImport<M> conflict) {
        if (null != conflict) {
            if (null == conflicts) {
                conflicts = new ArrayList<ModelImport<M>>();
            }
            conflicts.add(conflict);
        }
        return conflicts;
    }

    private List<ModelImport<M>> resolve(ResolutionContext<M> context, HashSet<M> done, List<IMessage> messages, List<VersionedModelInfos<M>> versions, ModelImport<M> imp) {
        ModelInfo<M> toLoad;
        List<ModelImport<M>> conflicts = null;
        try {
            toLoad = this.determineMatching(context, versions, imp.getVersionRestriction());
            if (this.conflictMarker == toLoad) {
                this.addConflict(conflicts, imp);
            }
        }
        catch (ModelManagementException e) {
            toLoad = null;
            messages.add(new Message(e.getMessage(), Status.ERROR));
        }
        if (null != toLoad && toLoad != this.conflictMarker) {
            conflicts = this.load(context, done, toLoad, messages, imp, conflicts);
        } else if (null == toLoad) {
            messages.add(new Message("model '" + imp.getName() + "' cannot be resolved as no model matches the import specification", Status.ERROR));
        }
        return conflicts;
    }

    protected void cannotResolveImport(ModelImport<M> imp, List<IMessage> messages, URI modelURI, IRestrictionEvaluationContext context) {
        messages.add(new Message("model '" + imp.getName() + "' cannot be found", Status.ERROR));
    }

    private List<ModelImport<M>> load(ResolutionContext<M> context, HashSet<M> done, ModelInfo<M> toLoad, List<IMessage> messages, ModelImport<M> imp, List<ModelImport<M>> conflicts) {
        block15: {
            M model = context.getModel();
            if (null != model && ModelInfo.equals(toLoad, model.getName(), model.getVersion(), context.getModelURI())) {
                messages.add(new Message("model '" + imp.getName() + "' cannot import itself", Status.ERROR));
            } else {
                IModelRepository<M> repository = context.getModelRepository();
                IModel found = (IModel)this.localModelOverride.get(toLoad);
                if (null == found && (null == (found = toLoad.getResolved()) && context.considerLoading(this.isTransitiveLoadingEnabled()) || repository.isOutdated(toLoad))) {
                    if (!context.isLoop(toLoad)) {
                        this.notifyProcessing(toLoad, IModelProcessingListener.Type.LOADING, true);
                        found = repository.load(toLoad, this, messages);
                        this.notifyProcessing(toLoad, IModelProcessingListener.Type.LOADING, false);
                    } else {
                        messages.add(new Message("Model '" + imp.getName() + "' cannot be resolved here due to errors in the imported model", Status.ERROR));
                    }
                }
                try {
                    if (null != found) {
                        if (this.checkImported(imp, found, messages)) {
                            this.handleImports(context, found, null);
                            try {
                                conflicts = this.addConflict(conflicts, context.getConflict((IModel)context.getModel()));
                            }
                            catch (RestrictionEvaluationException e) {
                                messages.add(new Message(e.getMessage(), Status.ERROR));
                            }
                            if (null == conflicts) {
                                imp.setResolved(found);
                            }
                        }
                        if (null == conflicts) {
                            ResolutionContext<IModel> ctx = new ResolutionContext<IModel>(found, toLoad.getLocation(), context);
                            ctx.addConflicts(context);
                            conflicts = ResolutionContext.addConflicts(conflicts, this.resolveImports(ctx, done, messages));
                            if (null == conflicts) {
                                context.addConflicts(ctx);
                            } else {
                                imp.setResolved(null);
                            }
                        }
                        break block15;
                    }
                    imp.setResolved(null);
                    this.localModelOverride.remove(toLoad);
                }
                catch (ModelManagementException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").exception(e);
                }
            }
        }
        return conflicts;
    }

    protected boolean checkImported(ModelImport<M> imp, M model, List<IMessage> messages) {
        return true;
    }

    @Override
    public M resolve(String modelName, IVersionRestriction restrictions, URI baseUri, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) throws ModelManagementException {
        M result = null;
        if (ModelImport.isWildcard(modelName)) {
            ArrayList<M> imports = new ArrayList<M>();
            for (String name : repository.getMatchingModelNames(modelName)) {
                M resolved = this.resolveSingle(name, restrictions, baseUri, repository, evaluationContext);
                if (null == resolved) continue;
                imports.add(resolved);
            }
            result = repository.createModel(modelName, imports);
        } else {
            result = this.resolveSingle(modelName, restrictions, baseUri, repository, evaluationContext);
        }
        return result;
    }

    private M resolveSingle(String modelName, IVersionRestriction restrictions, URI baseUri, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) throws ModelManagementException {
        M result = null;
        ResolutionContext<M> context = new ResolutionContext<M>(modelName, baseUri, repository, evaluationContext);
        List<VersionedModelInfos<M>> versions = context.getModelRepository().getAvailable(modelName);
        ModelInfo<M> toLoad = this.determineMatching(context, versions, restrictions);
        if (null != toLoad && toLoad != this.conflictMarker && (null == (result = (M)toLoad.getResolved()) || repository.isOutdated(toLoad))) {
            ArrayList<IMessage> messages = new ArrayList<IMessage>();
            result = repository.load(toLoad, this, messages);
            if (!messages.isEmpty()) {
                boolean isError = false;
                StringBuilder tmp = new StringBuilder();
                int n = messages.size();
                for (int m = 0; m < n; ++m) {
                    IMessage msg = (IMessage)messages.get(m);
                    isError |= Status.ERROR == msg.getStatus();
                    if (tmp.length() > 0) {
                        tmp.append(", ");
                    }
                    tmp.append(msg.getDescription());
                }
                if (isError) {
                    throw new ModelManagementException(tmp.toString(), 10503);
                }
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").info(tmp.toString());
            }
        }
        return result;
    }

    private List<ModelImport<M>> resolve(ResolutionContext<M> context, HashSet<M> done, List<IMessage> messages) {
        List<ModelImport<M>> conflicts = null;
        ModelImport<M> imp = context.getToResolve();
        if (!imp.isConflict() && null == imp.getResolved()) {
            if (imp.isWildcard()) {
                ArrayList<M> imports = new ArrayList<M>();
                for (String name : context.getModelRepository().getMatchingModelNames(imp.getName())) {
                    ModelImport<M> tmpImp = imp.copy(name);
                    List<VersionedModelInfos<M>> versions = context.getModelRepository().getAvailable(name);
                    if (null != versions && versions.size() > 0) {
                        conflicts = this.add(conflicts, this.resolve(context, done, messages, versions, tmpImp));
                    } else {
                        this.cannotResolveImport(tmpImp, messages, context.getModelURI(), context.getEvaluationContext());
                    }
                    if (null == tmpImp.getResolved()) continue;
                    imports.add(tmpImp.getResolved());
                }
                try {
                    imp.setResolved(context.getModelRepository().createModel(imp.getName(), imports));
                }
                catch (ModelManagementException e) {
                    messages.add(new Message(e.getMessage(), Status.ERROR));
                }
            } else {
                List<VersionedModelInfos<M>> versions = context.getModelRepository().getAvailable(imp.getName());
                if (null != versions && versions.size() > 0) {
                    conflicts = this.resolve(context, done, messages, versions, imp);
                } else {
                    this.cannotResolveImport(imp, messages, context.getModelURI(), context.getEvaluationContext());
                }
            }
        }
        return conflicts;
    }

    private List<ModelImport<M>> add(List<ModelImport<M>> orig, List<ModelImport<M>> add) {
        if (null == orig) {
            orig = add;
        } else if (null != add) {
            orig.addAll(add);
        }
        return orig;
    }
}

