/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelInfo;

public interface IModelLoader<M extends IModel> {
    public LoadResult<M> load(ModelInfo<M> var1, ImportResolver<M> var2);

    public void scan(File var1, IModelInfoHolder<M> var2);

    public static interface IModelInfoHolder<M extends IModel> {
        public void addResult(ModelInfo<M> var1);

        public boolean isKnown(URI var1, IModelLoader<M> var2);

        public void error(String var1);
    }

    public static class LoadResult<M extends IModel> {
        private List<M> models;
        private List<IMessage> messages;

        public LoadResult(List<M> models, List<IMessage> messages) {
            this.models = models;
            this.messages = messages;
        }

        public int getModelCount() {
            return null == this.models ? 0 : this.models.size();
        }

        public M getModel(int index) {
            if (null == this.models) {
                throw new IndexOutOfBoundsException();
            }
            return (M)((IModel)this.models.get(index));
        }

        public int getErrorCount() {
            int count = 0;
            if (null != this.messages) {
                for (int i = 0; i < this.messages.size(); ++i) {
                    if (Status.ERROR != this.messages.get(i).getStatus()) continue;
                    ++count;
                }
            }
            return count;
        }

        public int getMessageCount() {
            return null == this.messages ? 0 : this.messages.size();
        }

        public IMessage getMessage(int index) {
            if (null == this.messages) {
                throw new IndexOutOfBoundsException();
            }
            return this.messages.get(index);
        }
    }
}

