/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.modelManagement.IDeferredModelLoader;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelProcessingListener;
import net.ssehub.easy.basics.modelManagement.IModelRepository;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;

public abstract class ImportResolver<M extends IModel> {
    private boolean transitiveLoading = true;
    private IModelProcessingListener<M> processingListener;
    private List<IDeferredModelLoader<M>> deferredLoaders = new ArrayList<IDeferredModelLoader<M>>();

    public IModelProcessingListener<M> setProcessingListener(IModelProcessingListener<M> processingListener) {
        IModelProcessingListener<M> old = processingListener;
        this.processingListener = processingListener;
        return old;
    }

    public IModelProcessingListener<M> getProcessingListener() {
        return this.processingListener;
    }

    protected void notifyProcessing(ModelInfo<M> info, IModelProcessingListener.Type type, boolean started) {
        IModelProcessingListener<M> listener = this.getProcessingListener();
        if (null != listener) {
            if (started) {
                listener.notifyProcessingStarted(info, type);
            } else {
                listener.notifyProcessingEnded(info, type);
            }
        }
    }

    public void clear() {
        IDeferredModelLoader<M> msgTarget = null;
        if (this.deferredLoaders.size() > 1) {
            msgTarget = this.deferredLoaders.get(this.deferredLoaders.size() - 1);
        }
        for (int l = 0; l < this.deferredLoaders.size(); ++l) {
            this.deferredLoaders.get(l).completeLoading(msgTarget);
        }
        this.deferredLoaders.clear();
        this.transitiveLoading = true;
    }

    public abstract List<IMessage> resolveImports(M var1, URI var2, List<ModelInfo<M>> var3, IModelRepository<M> var4, IRestrictionEvaluationContext var5);

    public abstract M resolve(String var1, IVersionRestriction var2, URI var3, IModelRepository<M> var4, IRestrictionEvaluationContext var5) throws ModelManagementException;

    public boolean setTransitiveLoading(boolean transitiveLoading) {
        boolean old = this.transitiveLoading;
        this.transitiveLoading = transitiveLoading;
        return old;
    }

    public boolean isTransitiveLoadingEnabled() {
        return this.transitiveLoading;
    }

    public void addDeferredLoader(IDeferredModelLoader<M> loader) {
        if (null != loader) {
            for (int l = this.deferredLoaders.size() - 1; l >= 0; --l) {
                IDeferredModelLoader<M> tmp = this.deferredLoaders.get(l);
                if (!tmp.getModelId().equals(loader.getModelId())) continue;
                this.deferredLoaders.remove(l);
                break;
            }
            this.deferredLoaders.add(loader);
        }
    }
}

