/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;

public class ModelImport<M extends IModel> {
    public static final String WILDCARD_POSTFIX = "*";
    private M resolved;
    private String name;
    private IVersionRestriction restriction;
    private boolean isConflict;
    private boolean isInsert;

    ModelImport() {
    }

    public ModelImport(String name) {
        this(name, false, null);
    }

    public ModelImport(String name, boolean isConflict, IVersionRestriction restriction) {
        this(name, isConflict, restriction, false);
    }

    public ModelImport(String name, boolean isConflict, IVersionRestriction restriction, boolean isInsert) {
        this.name = name;
        this.restriction = restriction;
        this.isConflict = isConflict;
        this.isInsert = isInsert;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConflict() {
        return this.isConflict;
    }

    public void setRestrictions(IVersionRestriction restriction) {
        this.restriction = restriction;
    }

    public M getResolved() {
        return this.resolved;
    }

    public boolean isResolved() {
        return null != this.resolved;
    }

    public boolean isWildcard() {
        return ModelImport.isWildcard(this.name);
    }

    public static boolean isWildcard(String name) {
        return name != null && name.endsWith(WILDCARD_POSTFIX);
    }

    public boolean isInsert() {
        return this.isInsert;
    }

    public void setResolved(M resolved) throws ModelManagementException {
        this.resolved = resolved;
    }

    public boolean evaluateRestrictions(IRestrictionEvaluationContext context, Version version) throws RestrictionEvaluationException {
        return null != this.restriction ? this.restriction.evaluate(context, version) : true;
    }

    public IVersionRestriction getVersionRestriction() {
        return this.restriction;
    }

    public IVersionRestriction copyVersionRestriction(M model) throws RestrictionEvaluationException {
        return null != this.restriction ? this.restriction.copy((IModel)model) : null;
    }

    public ModelImport<M> copy(String modelName) {
        return new ModelImport<M>(null == modelName ? this.name : modelName, this.isConflict, this.restriction, this.isInsert);
    }
}

