/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelData;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.Version;

public class ModelInfo<M extends IModel>
implements IModelData {
    private String name;
    private Version version;
    private IModelLoader<M> loader;
    private URI location;
    private M resolved;
    private long timestamp;
    private List<ModelImport<M>> imports;
    private Locale locale;

    ModelInfo() {
        this(null, null, null, null, null);
    }

    public ModelInfo(M model, URI location) {
        this(model.getName(), model.getVersion(), null, location, null);
    }

    public ModelInfo(M model, URI location, IModelLoader<M> loader) {
        this(model.getName(), model.getVersion(), loader, location, null);
    }

    public ModelInfo(String name, Version version, IModelLoader<M> loader, URI location, List<ModelImport<M>> imp) {
        this.name = name;
        this.version = version;
        this.loader = loader;
        this.location = null != location ? location.normalize() : null;
        this.imports = new ArrayList<ModelImport<M>>();
        if (null != imp) {
            this.imports.addAll(imp);
        }
        this.adjustTimestamp();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public URI getLocation() {
        return this.location;
    }

    public IModelLoader<M> getLoader() {
        return this.loader;
    }

    public String nameVersionToString() {
        return "'" + this.name + "'" + Version.toString(this.version);
    }

    public String toString() {
        return this.name + " v" + this.version + " " + this.location + " " + this.loader + " " + this.isResolved() + " " + this.locale;
    }

    void setResolved(M resolved) {
        this.resolved = resolved;
        this.adjustTimestamp();
    }

    private void adjustTimestamp() {
        this.timestamp = null == this.resolved ? -1L : System.currentTimeMillis();
    }

    public M getResolved() {
        return this.resolved;
    }

    public boolean isResolved() {
        return null != this.resolved;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isOutdated() {
        boolean actual = false;
        if (null != this.location) {
            if ("file".equalsIgnoreCase(this.location.getScheme())) {
                try {
                    File file = new File(this.location);
                    actual = file.lastModified() > this.timestamp;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            actual = true;
        }
        return actual;
    }

    public int getImportsCount() {
        int result = null != this.resolved ? this.resolved.getImportsCount() : this.imports.size();
        return result;
    }

    public ModelImport<M> getImport(int index) {
        ModelImport<Object> result = null != this.resolved ? this.resolved.getImport(index) : this.imports.get(index);
        return result;
    }

    public boolean isContainedIn(URI uri) {
        return this.isContainedIn(ModelInfo.toComparablePath(uri));
    }

    public boolean isContainedIn(String path) {
        boolean result = false;
        if (null != path && null != this.location) {
            result = ModelInfo.toComparablePath(this.location).startsWith(path);
        }
        return result;
    }

    public static String toComparablePath(URI uri) {
        String result;
        if (null == uri) {
            result = null;
        } else {
            result = uri.getPath();
            if (!result.endsWith("/")) {
                result = result + "/";
            }
        }
        return result;
    }

    public static <M extends IModel> List<ModelInfo<M>> selectOutdated(List<ModelInfo<M>> info, boolean requireResolved, URI uri) {
        ArrayList<ModelInfo<M>> result = new ArrayList<ModelInfo<M>>();
        for (int i = 0; i < info.size(); ++i) {
            ModelInfo<M> pi = info.get(i);
            if (!pi.isOutdated() || requireResolved && (!requireResolved || !pi.isResolved()) || null != uri && !pi.isContainedIn(uri)) continue;
            result.add(pi);
        }
        return result;
    }

    public static <M extends IModel> List<ModelInfo<M>> selectContained(List<ModelInfo<M>> info, URI uri) {
        ArrayList<ModelInfo<M>> result = new ArrayList<ModelInfo<M>>();
        for (int i = 0; i < info.size(); ++i) {
            ModelInfo<M> pi = info.get(i);
            if (null != uri && !pi.isContainedIn(uri)) continue;
            result.add(pi);
        }
        return result;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public URI getCommentsResource() {
        return this.composeCommentsURI(this.getLocale(), false);
    }

    public URI getDefaultCommentsResource() {
        return this.composeCommentsURI(null, false);
    }

    public URI getBaseCommentsResource() {
        return this.composeCommentsURI(this.getLocale(), true);
    }

    public URI getDefaultBaseCommentsResource() {
        return this.composeCommentsURI(null, true);
    }

    private URI composeCommentsURI(Locale locale, boolean base) {
        URI result = null;
        if (null != this.location) {
            String path = this.location.getPath();
            int pos = path.lastIndexOf(47);
            if (pos >= 0 && pos < path.length()) {
                String name = path.substring(++pos);
                path = path.substring(0, pos);
                path = base ? path + this.composeLocaleCommentsName("easy-base", locale) : ((pos = name.lastIndexOf(46)) >= 0 && pos < path.length() ? path + this.composeLocaleCommentsName(name.substring(0, pos), locale) : null);
            } else {
                path = null;
            }
            if (null != path) {
                try {
                    result = new URI(this.location.getScheme(), this.location.getUserInfo(), this.location.getHost(), this.location.getPort(), path, this.location.getQuery(), this.location.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String composeLocaleCommentsName(String name, Locale locale) {
        if (null != locale) {
            name = name + "_" + locale.getLanguage();
        }
        return name + ".text";
    }

    void updateModelLoader(IModelLoader<M> loader) {
        if (null == this.loader) {
            this.loader = loader;
        }
    }

    public static <M extends IModel> boolean equals(ModelInfo<M> i1, ModelInfo<M> i2) {
        boolean equals = null == i1 ? null == i2 : (null != i2 ? ModelInfo.equals(i1, i2.getName(), i2.getVersion(), i2.getLocation()) : false);
        return equals;
    }

    public static <M extends IModel> boolean equals(ModelInfo<M> info, String name, Version version, URI location) {
        if (null == info) {
            return null == name && null == version && null == location;
        }
        boolean equals = null != location ? info.getName().equals(name) && Version.equals(info.getVersion(), version) && info.getLocation().normalize().equals(location.normalize()) : false;
        return equals;
    }
}

