/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;

public class ModelInitializer {
    private static final List<IModelInitializer> INITIALIZERS = new ArrayList<IModelInitializer>();

    public static void register(IModelInitializer initializer) {
        if (null != initializer && !INITIALIZERS.contains(initializer)) {
            INITIALIZERS.add(initializer);
        }
    }

    public static void unregister(IModelInitializer initializer) {
        if (null != initializer) {
            INITIALIZERS.remove(initializer);
        }
    }

    public static void addLocation(File location, ProgressObserver observer) throws ModelManagementException {
        if (null != location) {
            for (IModelInitializer initializer : INITIALIZERS) {
                initializer.addLocation(location, observer);
            }
        }
    }

    public static void removeLocation(File location, ProgressObserver observer) throws ModelManagementException {
        if (null != location) {
            for (IModelInitializer initializer : INITIALIZERS) {
                initializer.removeLocation(location, observer);
            }
        }
    }

    public static void registerLoader(ProgressObserver observer) throws ModelManagementException {
        for (IModelInitializer initializer : INITIALIZERS) {
            initializer.registerLoader(observer);
        }
    }

    public static void unregisterLoader(ProgressObserver observer) throws ModelManagementException {
        for (IModelInitializer initializer : INITIALIZERS) {
            initializer.unregisterLoader(observer);
        }
    }

    public static interface IModelInitializer {
        public void addLocation(File var1, ProgressObserver var2) throws ModelManagementException;

        public void addLocationToFront(File var1, ProgressObserver var2) throws ModelManagementException;

        public void removeLocation(File var1, ProgressObserver var2) throws ModelManagementException;

        public void registerLoader(ProgressObserver var1) throws ModelManagementException;

        public void unregisterLoader(ProgressObserver var1) throws ModelManagementException;
    }
}

