/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.IModelManagementRepository;
import net.ssehub.easy.basics.modelManagement.ModelInfoHolder;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;

public class ModelLoaders<M extends IModel> {
    private List<IModelLoader<M>> loaders = new ArrayList<IModelLoader<M>>();
    private IModelManagementRepository<M> repository;

    ModelLoaders(IModelManagementRepository<M> repository) {
        this.repository = repository;
    }

    void scanAll(File location, ModelInfoHolder<M> holder) {
        for (int l = 0; l < this.loaders.size(); ++l) {
            this.loaders.get(l).scan(location, holder);
        }
    }

    public synchronized boolean isRegistered(IModelLoader<M> loader) {
        return this.loaders.contains(loader);
    }

    public synchronized void registerLoader(IModelLoader<M> loader, ProgressObserver observer) throws ModelManagementException {
        if (null != loader && !this.loaders.contains(loader)) {
            this.loaders.add(loader);
            this.repository.updateForLoader(loader, observer);
        }
    }

    public synchronized void unregisterLoader(IModelLoader<M> loader, ProgressObserver observer) {
        if (null != loader) {
            this.loaders.remove(loader);
        }
    }

    public synchronized int getLoaderCount() {
        return this.loaders.size();
    }

    public IModelLoader<M> getDefaultLoader() {
        IModelLoader<M> result = null;
        if (this.loaders.size() > 0) {
            result = this.loaders.get(0);
        }
        return result;
    }
}

