/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.io.FileUtils;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.IModelManagementRepository;
import net.ssehub.easy.basics.modelManagement.ModelInfoHolder;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ObservableTask;
import net.ssehub.easy.basics.progress.ProgressObserver;

public class ModelLocations<M extends IModel> {
    private Map<String, Location> knownLocations = new HashMap<String, Location>();
    private IModelManagementRepository<M> repository;
    private List<Location> locations = new ArrayList<Location>();
    private Set<File> excludedLocations = new HashSet<File>();

    ModelLocations(IModelManagementRepository<M> repository) {
        this.repository = repository;
    }

    void clear() {
        this.knownLocations.clear();
        this.locations.clear();
    }

    public synchronized void addExcludedLocation(File location) {
        if (!this.excludedLocations.contains(location)) {
            this.excludedLocations.add(location);
        }
    }

    public synchronized void removeExcludedLocation(File location) {
        this.excludedLocations.remove(location);
    }

    public Location getLocationFor(URI uri) {
        Location result;
        block5: {
            result = null;
            try {
                if (!FileUtils.isFileURI(uri)) break block5;
                File f = new File(uri).getCanonicalFile();
                while (null == result) {
                    for (int l = 0; l < this.locations.size(); ++l) {
                        Location tmp = this.locations.get(l);
                        if (!tmp.contains(f) || null != result && !tmp.contains(result.getLocation())) continue;
                        result = tmp;
                    }
                    if (null == result && null != f.getParentFile()) {
                        f = f.getParentFile();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private Location getLocationFor(File file) throws ModelManagementException {
        return this.getLocationFor(file, false);
    }

    private synchronized Location getLocationFor(File file, boolean create) throws ModelManagementException {
        try {
            File cFile = file.getCanonicalFile();
            String key = cFile.toString();
            Location location = this.knownLocations.get(key);
            if (null == location && create) {
                location = new Location(file);
                this.knownLocations.put(key, location);
            }
            return location;
        }
        catch (IOException e) {
            throw new ModelManagementException(e.getMessage(), 10599);
        }
    }

    public synchronized Location addLocation(File file, ProgressObserver observer) throws ModelManagementException {
        return this.addLocation(file, false, observer);
    }

    public synchronized Location addLocationToFront(File file, ProgressObserver observer) throws ModelManagementException {
        return this.addLocation(file, true, observer);
    }

    private Location addLocation(File file, boolean front, ProgressObserver observer) throws ModelManagementException {
        Location location = null;
        if (null != file) {
            location = this.getLocationFor(file, true);
            if (!this.locations.contains(location)) {
                if (front) {
                    this.locations.add(0, location);
                } else {
                    this.locations.add(location);
                }
            }
            this.repository.updateModelInformation(file, observer);
        }
        return location;
    }

    public synchronized void removeLocation(Location location, ProgressObserver observer) throws ModelManagementException {
        if (null != location) {
            this.repository.clearLocation(location.getLocation(), observer);
        }
    }

    public synchronized void removeLocation(File file, ProgressObserver observer) throws ModelManagementException {
        if (null != file) {
            Location location = this.getLocationFor(file, false);
            this.removeLocation(location, observer);
        }
    }

    public synchronized void updateLocation(File file, ProgressObserver observer) throws ModelManagementException {
        Location location;
        if (null != file && null != (location = this.getLocationFor(file, false)) && this.locations.contains(location)) {
            this.repository.updateModelInformation(file, observer);
        }
    }

    public synchronized boolean isLocationKnown(File file) {
        boolean found = false;
        for (int l = 0; l < this.locations.size(); ++l) {
            found = this.locations.get(l).getLocation().equals(file);
        }
        return found;
    }

    private static int count(File location, Set<File> excludedLocations) {
        int count = 0;
        if (!(null == location || null != excludedLocations && excludedLocations.contains(location))) {
            if (location.isDirectory()) {
                File[] files = location.listFiles();
                if (null != files) {
                    for (int f = 0; f < files.length; ++f) {
                        count += ModelLocations.count(files[f], excludedLocations);
                    }
                }
            } else {
                count = 1;
            }
        }
        return count;
    }

    int countFilesInLocations() {
        int count = 0;
        HashSet done = new HashSet();
        for (int f = 0; f < this.locations.size(); ++f) {
            count += this.locations.get(f).countFilesInLocations(this.excludedLocations, done);
        }
        return count;
    }

    public synchronized int getLocationCount() {
        return this.locations.size();
    }

    public synchronized Location getLocation(int index) {
        return this.locations.get(index);
    }

    synchronized void scan(File location, ModelInfoHolder<M> holder, IModelLoader<M> loader, ObservableTask task, Set<File> done) {
        if (null != location && !this.excludedLocations.contains(location)) {
            if (location.isDirectory()) {
                if (!done.contains(location)) {
                    done.add(location);
                    File[] files = location.listFiles();
                    if (null != files) {
                        for (int f = 0; f < files.length; ++f) {
                            this.scan(files[f], holder, loader, task, done);
                        }
                    }
                }
            } else {
                if (null != loader) {
                    loader.scan(location, holder);
                } else {
                    this.repository.loaders().scanAll(location, holder);
                }
                task.notifyProgress();
            }
        }
    }

    synchronized void removeLocationFor(File file) throws ModelManagementException {
        Location location = this.getLocationFor(file);
        this.removeLocation(location);
    }

    synchronized void removeLocation(Location location) {
        if (null != location) {
            HashSet done = new HashSet();
            this.locations.remove(location);
            for (int l = 0; l < this.locations.size(); ++l) {
                this.locations.get(l).removeFromDependentLocations(location, done);
                done.clear();
            }
            String toRemove = null;
            boolean depsExist = false;
            for (Map.Entry<String, Location> entry : this.knownLocations.entrySet()) {
                Location loc = entry.getValue();
                if (loc == location) {
                    toRemove = entry.getKey();
                    continue;
                }
                depsExist = loc.isDependentLocation(location, done);
                done.clear();
            }
            if (!depsExist && null != toRemove) {
                this.knownLocations.remove(toRemove);
            }
        }
    }

    public void updateModelInformation() throws ModelManagementException {
        ModelManagementException ex = null;
        for (int l = 0; l < this.locations.size(); ++l) {
            try {
                this.repository.updateModelInformation(this.locations.get(l).getLocation(), ProgressObserver.NO_OBSERVER);
                continue;
            }
            catch (ModelManagementException e) {
                if (null != ex) continue;
                ex = e;
            }
        }
        if (null != ex) {
            throw ex;
        }
    }

    public static class Location {
        private File location;
        private List<Location> dependent;

        private Location(File location) {
            this.location = location;
        }

        public File getLocation() {
            return this.location;
        }

        public int getDependentLocationCount() {
            return null == this.dependent ? 0 : this.dependent.size();
        }

        public Location getDependentLocation(int index) {
            return this.dependent.get(index);
        }

        public void addDependentLocation(Location location) {
            if (null != location) {
                if (null == this.dependent) {
                    this.dependent = new ArrayList<Location>();
                }
                if (!this.dependent.contains(location)) {
                    this.dependent.add(location);
                }
            }
        }

        private int countFilesInLocations(Set<File> excludedLocations, Set<Location> done) {
            int count = 0;
            if (!done.contains(this)) {
                done.add(this);
                count = ModelLocations.count(this.location, excludedLocations);
                if (null != this.dependent) {
                    for (int d = 0; d < this.dependent.size(); ++d) {
                        count += this.dependent.get(d).countFilesInLocations(excludedLocations, done);
                    }
                }
            }
            return count;
        }

        private boolean contains(File file) {
            boolean result;
            try {
                String sFile = file.toString();
                result = this.location.length() > 0L && sFile.startsWith(this.location.toString()) || sFile.startsWith(this.location.getCanonicalPath().toString());
            }
            catch (IOException e) {
                result = false;
            }
            return result;
        }

        private void removeFromDependentLocations(Location location, Set<Location> processed) {
            if (!processed.contains(location)) {
                processed.add(location);
                if (null != this.dependent) {
                    this.dependent.remove(location);
                    for (int d = 0; d < this.dependent.size(); ++d) {
                        this.dependent.get(d).removeFromDependentLocations(location, processed);
                    }
                }
            }
        }

        private boolean isDependentLocation(Location location, Set<Location> processed) {
            boolean found = false;
            if (!processed.contains(location)) {
                processed.add(location);
                if (null != this.dependent) {
                    for (int d = 0; !found && d < this.dependent.size(); ++d) {
                        Location dep = this.dependent.get(d);
                        found = location == dep || dep.isDependentLocation(location, processed);
                    }
                }
            }
            return found;
        }

        public String toString() {
            return "Location: " + this.location + " " + this.dependent;
        }
    }
}

