/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.IModelProcessingListener;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelEvents;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelInfoHolder;
import net.ssehub.easy.basics.modelManagement.ModelLoaders;
import net.ssehub.easy.basics.modelManagement.ModelLocale;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.ModelRepository;
import net.ssehub.easy.basics.modelManagement.ModelUpdateUtils;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.basics.progress.ObservableTask;
import net.ssehub.easy.basics.progress.ProgressObserver;

public abstract class ModelManagement<M extends IModel> {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ModelManagement.class, "net.ssehub.easy.basics");
    private ModelLocale locale = new ModelLocale();
    private List<M> models = new ArrayList<M>();
    private Set<ModelInfo<M>> outdated = new HashSet<ModelInfo<M>>();
    private AvailableModels<M> availableModels;
    private ModelRepository<M> repository;
    private ModelEvents<M> events = new ModelEvents();
    private ModelLocations<M> locations;
    private ModelLoaders<M> loaders;
    private transient Set<ModelInfo<M>> loading = new HashSet<ModelInfo<M>>();
    private transient boolean inUpdate = false;
    private Pool<ImportResolver<M>> resolverPool = new Pool(new IPoolManager<ImportResolver<M>>(){

        @Override
        public ImportResolver<M> create() {
            return ModelManagement.this.createResolver();
        }

        @Override
        public void clear(ImportResolver<M> instance) {
            instance.clear();
        }
    });

    protected ModelManagement() {
        this.repository = this.createRepository();
        this.availableModels = new AvailableModels<M>(this.repository);
        this.locations = new ModelLocations<M>(this.repository);
        this.loaders = new ModelLoaders<M>(this.repository);
    }

    protected abstract ModelRepository<M> createRepository();

    protected abstract ImportResolver<M> createResolver();

    public ModelLocale locale() {
        return this.locale;
    }

    public ModelEvents<M> events() {
        return this.events;
    }

    public ModelLoaders<M> loaders() {
        return this.loaders;
    }

    public ModelLocations<M> locations() {
        return this.locations;
    }

    public AvailableModels<M> availableModels() {
        return this.availableModels;
    }

    protected ModelRepository<M> repository() {
        return this.repository;
    }

    public ImportResolver<M> getResolverFromPool() {
        return this.resolverPool.getInstance();
    }

    public void releaseResolver(ImportResolver<M> resolver) {
        this.resolverPool.releaseInstance(resolver);
    }

    public synchronized void updateModel(M model, URI uri, IModelLoader<M> loader) {
        this.updateModel(model, uri, loader, true);
    }

    public synchronized void notifyLoadingCompleted(M model, URI uri) {
        ModelInfo<M> info;
        List<VersionedModelInfos<M>> vList = this.availableModels.getAvailable(model.getName());
        VersionedModelInfos<M> vInfos = VersionedModelInfos.find(vList, model.getVersion());
        if (null != vInfos && null != (info = vInfos.find(uri))) {
            try {
                this.postLoadModel(info);
            }
            catch (IOException e) {
                EASyLoggerFactory.INSTANCE.getLogger(ModelManagement.class, "net.ssehub.easy.basics").exception(e);
            }
        }
    }

    public synchronized void updateModel(M model, URI uri, IModelLoader<M> loader, boolean deepReload) {
        ModelInfo<M> info;
        if (null != uri) {
            uri = uri.normalize();
        }
        IModel oldModel = null;
        List<VersionedModelInfos<M>> vList = this.availableModels.getAvailable(model.getName());
        VersionedModelInfos<M> vInfos = VersionedModelInfos.find(vList, model.getVersion());
        boolean done = false;
        if (null != vInfos && null != (info = vInfos.find(uri))) {
            oldModel = this.setResolved(info, model);
            if (null == info.getLocale()) {
                info.setLocale(this.locale.getActualLocale());
            }
            done = true;
        }
        if (!done) {
            info = new ModelInfo<M>(model, uri, loader);
            oldModel = this.setResolved(info, model);
            if (null == vList) {
                vList = new ArrayList<VersionedModelInfos<M>>();
                this.availableModels.putAvailable(model.getName(), vList);
            }
            if (null == vInfos) {
                vInfos = new VersionedModelInfos(model.getVersion());
                vList.add(vInfos);
            }
            vInfos.add(info);
        }
        if (!this.inUpdate) {
            this.inUpdate = true;
            if (null != oldModel && deepReload) {
                this.reload((M)ModelUpdateUtils.determineUpdateSeqence(model, ModelUpdateUtils.collectImporting(this.models, ModelUpdateUtils.addReplacing(oldModel, model))));
            }
            this.inUpdate = false;
        }
    }

    private void reload(List<M> models) {
        IModel tmp;
        int m;
        for (m = 0; m < models.size(); ++m) {
            tmp = (IModel)models.get(m);
            if (null == tmp) continue;
            this.setOutdated((IModel)models.get(m));
        }
        for (m = models.size() - 1; m >= 0; --m) {
            tmp = (IModel)models.get(m);
            if (null == tmp || !this.isOutdated(tmp)) continue;
            this.reload(tmp);
        }
    }

    public M reload(M model) {
        return this.reload(model, false);
    }

    public M reload(M model, boolean deepReload) {
        M result = model;
        ModelInfo<M> info = this.availableModels.getModelInfo(model);
        if (null != info) {
            try {
                result = this.load(info, true);
                this.setResolved(info, result);
            }
            catch (ModelManagementException e) {
                LOGGER.warn("updating model " + info.getName() + " " + Version.toString(info.getVersion()) + " failed: " + e.getMessage());
            }
        } else {
            LOGGER.warn("updating model: no information object found for " + model.getName() + " " + Version.toString(model.getVersion()) + " (syntax/semantic error?)");
        }
        if (model == result) {
            this.events.notifyModelReloadFailed(model);
        } else if (null != model && deepReload) {
            this.reload((M)ModelUpdateUtils.determineUpdateSeqence(result, ModelUpdateUtils.collectImporting(this.models, ModelUpdateUtils.addReplacing(model, result))));
        }
        return result;
    }

    public synchronized int unload(M model, ProgressObserver observer) throws ModelManagementException {
        ProgressObserver.ITask task = observer.registerTask("unload model");
        observer.notifyStart(task, 2 + this.models.size());
        int step = 0;
        HashSet toUnload = new HashSet();
        HashSet tmpImported = new HashSet();
        HashSet allUnloads = new HashSet();
        Utils.enumerateImported(model, allUnloads, null);
        observer.notifyProgress(task, step++);
        toUnload.addAll(allUnloads);
        int modelsCount = this.models.size();
        for (int p = 0; p < modelsCount; ++p) {
            IModel tmp = (IModel)this.models.get(p);
            if (allUnloads.contains(tmp)) continue;
            Utils.enumerateImported(tmp, tmpImported, toUnload);
            tmpImported.clear();
            observer.notifyProgress(task, step++);
        }
        allUnloads.clear();
        int count = 0;
        for (IModel p : toUnload) {
            this.unloadImpl(p);
            ++count;
        }
        observer.notifyProgress(task, step++);
        observer.notifyEnd(task);
        return count;
    }

    private void unloadImpl(M model) {
        this.models.remove(model);
        this.events.removeAllListeners(model);
        List<ModelInfo<M>> info = this.availableModels.getModelInfos(model);
        if (null != info) {
            int size = info.size();
            for (int i = 0; i < size; ++i) {
                ModelInfo<M> pInfo = info.get(i);
                if (pInfo.getResolved() != model) continue;
                pInfo.setResolved(null);
            }
        }
    }

    public synchronized void updateModel(M model, URI uri) {
        this.updateModel(model, uri, null);
    }

    private M setResolved(ModelInfo<M> info, M model) {
        int pos;
        M current = info.getResolved();
        info.setResolved(model);
        this.outdated.remove(info);
        int n = pos = null == current ? -1 : this.models.indexOf(current);
        if (pos >= 0) {
            this.models.set(pos, model);
            if (model != current) {
                current.dispose();
            }
        } else {
            this.models.add(model);
        }
        this.events.notifyModelReplacement(current, model);
        return current;
    }

    public synchronized int getModelCount() {
        return this.models.size();
    }

    public synchronized M getModel(int index) {
        return (M)((IModel)this.models.get(index));
    }

    public synchronized List<IMessage> resolveImports(M model, URI uri, List<ModelInfo<M>> inProgress) {
        return this.resolveImports(model, uri, inProgress, true);
    }

    public synchronized List<IMessage> resolveImports(M model, URI uri, List<ModelInfo<M>> inProgress, boolean transitiveLoading) {
        ImportResolver<M> resolver = this.getResolverFromPool();
        resolver.setTransitiveLoading(transitiveLoading);
        List<IMessage> result = resolver.resolveImports(model, uri, inProgress, this.repository, model.getRestrictionEvaluationContext());
        this.releaseResolver(resolver);
        return result;
    }

    public synchronized List<IMessage> resolveImports(M model, URI uri, List<ModelInfo<M>> inProgress, ImportResolver<M> resolver) {
        return this.resolveImports(model, uri, inProgress, resolver, true);
    }

    public synchronized List<IMessage> resolveImports(M model, URI uri, List<ModelInfo<M>> inProgress, ImportResolver<M> resolver, boolean transitiveLoading) {
        List<IMessage> result;
        if (null == resolver) {
            result = this.resolveImports(model, uri, inProgress, transitiveLoading);
        } else {
            boolean old = resolver.setTransitiveLoading(transitiveLoading);
            result = resolver.resolveImports(model, uri, inProgress, this.repository, model.getRestrictionEvaluationContext());
            resolver.setTransitiveLoading(old);
        }
        return result;
    }

    public synchronized M resolve(String modelName, IVersionRestriction restriction, URI baseURI, IRestrictionEvaluationContext evaluationContext) throws ModelManagementException {
        ImportResolver<M> resolver = this.getResolverFromPool();
        M result = resolver.resolve(modelName, restriction, baseURI, this.repository, evaluationContext);
        this.releaseResolver(resolver);
        return result;
    }

    M load(ModelInfo<M> info, List<IMessage> messages) {
        return this.load(info, null, messages);
    }

    M load(ModelInfo<M> info, ImportResolver<M> resolver, List<IMessage> messages) {
        M result = null;
        IModelLoader<M> loader = info.getLoader();
        if (null == loader) {
            loader = this.loaders.getDefaultLoader();
        }
        if (null != loader) {
            this.notifyLoading(info, true);
            IModelLoader.LoadResult<M> loadResult = loader.load(info, resolver);
            this.notifyLoading(info, false);
            if (loadResult.getModelCount() > 0 && 0 == loadResult.getErrorCount()) {
                for (int i = 0; i < loadResult.getModelCount(); ++i) {
                    M model = loadResult.getModel(i);
                    info.setLocale(this.locale.getActualLocale());
                    if (null != result || !Utils.matches(model, info)) continue;
                    this.setResolved(info, model);
                    result = model;
                }
            }
            for (int m = 0; m < loadResult.getMessageCount(); ++m) {
                messages.add(loadResult.getMessage(m));
            }
        } else {
            messages.add(new Message("loader for model '" + info.getName() + "' is undefined", Status.ERROR));
        }
        return result;
    }

    private void notifyLoading(ModelInfo<M> info, boolean started) {
        if (started) {
            this.loading.add(info);
        } else {
            this.loading.remove(info);
        }
        this.events().notifyModelProcessing(info, started, IModelProcessingListener.Type.LOADING);
    }

    public boolean isLoading(ModelInfo<M> info) {
        return this.loading.contains(info);
    }

    public boolean isLoading(URI location) {
        ModelInfo<M> info;
        boolean result = false;
        if (null != location && null != (info = this.availableModels().getInfo(location))) {
            result = this.isLoading(info);
        }
        return result;
    }

    protected void postLoadModel(ModelInfo<M> info) throws IOException {
    }

    public synchronized M load(ModelInfo<M> info) throws ModelManagementException {
        return this.load(info, false);
    }

    public synchronized void updateModelInformation(File file, ProgressObserver observer) throws ModelManagementException {
        ModelInfoHolder<M> holder = new ModelInfoHolder<M>(this.availableModels);
        this.updateModelInformation(file, holder, observer, null);
    }

    public synchronized void updateModelInformation(ProgressObserver observer) throws ModelManagementException {
        ModelInfoHolder<M> holder = new ModelInfoHolder<M>(this.availableModels);
        ProgressObserver.ITask task = observer.registerTask("update model model information");
        observer.notifyStart(task, this.locations.getLocationCount());
        HashSet<ModelLocations.Location> done = new HashSet<ModelLocations.Location>();
        for (int l = 0; l < this.locations.getLocationCount(); ++l) {
            this.updateModelInformation(this.locations.getLocation(l), holder, observer, task, done);
            observer.notifyProgress(task, l);
        }
        observer.notifyEnd(task);
    }

    private void updateModelInformation(ModelLocations.Location location, ModelInfoHolder<M> holder, ProgressObserver observer, ProgressObserver.ITask task, Set<ModelLocations.Location> done) throws ModelManagementException {
        if (!done.contains(location)) {
            done.add(location);
            this.updateModelInformation(location.getLocation(), holder, observer, task);
            for (int d = 0; d < location.getDependentLocationCount(); ++d) {
                this.updateModelInformation(location.getDependentLocation(d), holder, observer, task, done);
            }
        }
    }

    synchronized void updateForLoader(IModelLoader<M> loader, ProgressObserver observer) throws ModelManagementException {
        StringBuilder errors = new StringBuilder();
        ModelInfoHolder<M> holder = new ModelInfoHolder<M>(this.availableModels);
        ObservableTask task = new ObservableTask("register model loader", this.locations.countFilesInLocations(), observer);
        int locationsCount = this.locations.getLocationCount();
        if (locationsCount > 0) {
            HashSet<ModelLocations.Location> done = new HashSet<ModelLocations.Location>();
            for (int l = 0; l < locationsCount; ++l) {
                this.updateForLoader(this.locations.getLocation(l), loader, holder, task, done);
            }
        }
        Utils.appendErrors(errors, this.updateAvailableModels(holder));
        task.notifyEnd();
        if (errors.length() > 0) {
            throw new ModelManagementException("inconsistencies in model information (location, model loader) for: " + errors, 10500);
        }
    }

    private void updateForLoader(ModelLocations.Location location, IModelLoader<M> loader, ModelInfoHolder<M> holder, ObservableTask task, Set<ModelLocations.Location> done) {
        if (!done.contains(location)) {
            done.add(location);
            HashSet<File> fileDone = new HashSet<File>();
            this.locations.scan(location.getLocation(), holder, loader, task, fileDone);
            for (int d = 0; d < location.getDependentLocationCount(); ++d) {
                this.updateForLoader(location.getDependentLocation(d), loader, holder, task, done);
            }
        }
    }

    synchronized void clearLocation(File file, ProgressObserver observer) {
        if (null != file) {
            URI uri = file.toURI().normalize();
            ArrayList infos = new ArrayList();
            Utils.collectModelInfo(this.availableModels.versionedModelInfos(), infos, null);
            for (int i = 0; i < infos.size(); ++i) {
                Object resolved;
                ModelInfo info = (ModelInfo)infos.get(i);
                if (!info.isContainedIn(uri)) continue;
                List<VersionedModelInfos<M>> vInfos = this.availableModels.getAvailable(info.getName());
                VersionedModelInfos<M> vInfo = VersionedModelInfos.find(vInfos, info.getVersion());
                if (null != vInfo) {
                    vInfo.remove(info);
                }
                if (null != (resolved = info.getResolved())) {
                    this.models.remove(resolved);
                    this.events.removeAllListeners(resolved);
                    resolved.dispose();
                }
                if (!vInfos.isEmpty()) continue;
                this.availableModels.removeAvailable(info.getName());
            }
            try {
                this.locations.removeLocationFor(file);
            }
            catch (ModelManagementException modelManagementException) {
                // empty catch block
            }
        }
    }

    public List<VersionedModelInfos<M>> getAvailable(String name) {
        return this.availableModels.getAvailable(name);
    }

    private String updateAvailableModels(ModelInfoHolder<M> holder) {
        String result = "";
        if (null != holder) {
            StringBuilder errors = new StringBuilder();
            for (int i = 0; i < holder.getResultCount(); ++i) {
                ModelInfo<M> info = holder.getResult(i);
                if (!this.availableModels.updateAvailableModel(info)) continue;
                if (errors.length() > 0) {
                    errors.append(", ");
                }
                errors.append(info.nameVersionToString());
            }
            if (errors.length() > 0) {
                result = errors.toString();
            }
        }
        return result;
    }

    private void updateModelInformation(File file, ModelInfoHolder<M> holder, ProgressObserver observer, ProgressObserver.ITask task) throws ModelManagementException {
        ModelInfo info;
        int o;
        StringBuilder errors = new StringBuilder();
        ObservableTask subtask = new ObservableTask("update model information", this.locations.countFilesInLocations(), observer, task);
        HashSet<File> done = new HashSet<File>();
        this.locations.scan(file, holder, null, subtask, done);
        done = null;
        Utils.appendErrors(errors, this.updateAvailableModels(holder));
        subtask.notifyEnd();
        URI uri = file.toURI().normalize();
        ArrayList allInfos = new ArrayList();
        HashMap modelInfoMap = new HashMap();
        Utils.collectModelInfo(this.availableModels.versionedModelInfos(), allInfos, modelInfoMap);
        List outdated = ModelInfo.selectOutdated(allInfos, true, uri);
        List topLevel = Utils.augmentByDepending(outdated, allInfos, modelInfoMap);
        for (o = 0; o < outdated.size(); ++o) {
            info = outdated.get(o);
            Object resolved = info.getResolved();
            if (null == resolved) continue;
            this.models.remove(resolved);
            this.outdated.add(outdated.get(o));
            resolved.dispose();
        }
        subtask = new ObservableTask("update outdated models", topLevel.size(), observer, task);
        for (o = 0; o < topLevel.size(); ++o) {
            try {
                this.load(topLevel.get(o), true);
            }
            catch (ModelManagementException e) {
                Utils.appendErrors(errors, e.getMessage());
            }
            subtask.notifyProgress();
        }
        for (o = 0; o < outdated.size(); ++o) {
            info = outdated.get(o);
            this.outdated.remove(info);
        }
        subtask.notifyEnd();
        if (errors.length() > 0) {
            throw new ModelManagementException("inconsistencies in model information (location, model loader) for: " + errors, 10500);
        }
    }

    private synchronized M load(ModelInfo<M> info, boolean force) throws ModelManagementException {
        boolean reload;
        if (null == info) {
            throw new ModelManagementException("model info must not be null", 10599);
        }
        M result = info.getResolved();
        boolean bl = reload = force || this.outdated.contains(info) || info.isOutdated();
        if (null == result || reload) {
            ArrayList<IMessage> messages = new ArrayList<IMessage>();
            if (!info.isResolved() || reload) {
                List<IMessage> rmessages;
                result = this.load(info, messages);
                if (null != result && null != (rmessages = this.resolveImports(result, info.getLocation(), null))) {
                    messages.addAll(rmessages);
                }
                if (messages.size() > 0) {
                    int errorCount = 0;
                    StringBuilder builder = new StringBuilder();
                    for (int m = 0; m < messages.size(); ++m) {
                        IMessage message = messages.get(m);
                        if (builder.length() > 0) {
                            builder.append("\n");
                        }
                        builder.append(message.getDetailedDescription());
                        if (Status.ERROR != message.getStatus() && Status.UNSUPPORTED != message.getStatus()) continue;
                        ++errorCount;
                    }
                    if (errorCount > 0) {
                        throw new ModelManagementException(builder.toString(), 10503);
                    }
                }
            }
        }
        return result;
    }

    public void clear() {
        this.availableModels.clear();
        this.locations.clear();
    }

    public void clearModel(M model) {
        if (null != model) {
            this.clearModel(this.availableModels.getModelInfo(model));
        }
    }

    public void clearModel(ModelInfo<M> info) {
        if (null != info) {
            M model = info.getResolved();
            if (null != model) {
                this.models.remove(model);
            }
            this.availableModels.removeAvailable(info);
        }
    }

    public void outdateAll() {
        for (IModel model : this.models) {
            ModelInfo<IModel> info = this.availableModels.getModelInfo(model);
            if (null == info) continue;
            this.outdated.add(info);
        }
    }

    public boolean isOutdated(M model) {
        return this.isOutdated(this.availableModels.getModelInfo(model));
    }

    public boolean isOutdated(ModelInfo<M> info) {
        return null == info ? false : this.outdated.contains(info);
    }

    public void setOutdated(M model) {
        this.setOutdated(this.availableModels.getModelInfo(model));
    }

    public void setOutdated(ModelInfo<M> info) {
        if (null != info) {
            this.outdated.add(info);
        }
    }
}

