/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;

class ModelUpdateUtils {
    ModelUpdateUtils() {
    }

    static <M extends IModel> Map<M, M> addReplacing(M old, M model) {
        return ModelUpdateUtils.addReplacing(old, model, null);
    }

    static <M extends IModel> Map<M, M> addReplacing(M old, M model, Map<M, M> result) {
        if (null == result) {
            result = new HashMap<M, M>();
        }
        result.put(old, model);
        return result;
    }

    static <M extends IModel> Map<M, List<M>> collectImporting(List<M> models, Map<M, M> replacing) {
        HashMap result = new HashMap();
        for (int m = 0; m < models.size(); ++m) {
            IModel model = (IModel)models.get(m);
            if (null == model) continue;
            for (int i = 0; i < model.getImportsCount(); ++i) {
                ArrayList<IModel> importing;
                IModel tmp;
                Object imported = model.getImport(i).getResolved();
                if (null == imported) continue;
                if (null != replacing && null != (tmp = (IModel)replacing.get(imported))) {
                    imported = tmp;
                }
                if (null == (importing = (ArrayList<IModel>)result.get(imported))) {
                    importing = new ArrayList<IModel>();
                    result.put(imported, importing);
                }
                importing.add(model);
            }
        }
        return result;
    }

    static <M extends IModel> List<M> determineUpdateSeqence(M model, Map<M, List<M>> using) {
        ArrayList<IModel> result = new ArrayList<IModel>();
        HashMap updateSequence = new HashMap();
        int max = ModelUpdateUtils.followImporting(model, using, updateSequence, 0, new HashSet());
        while (result.size() < max) {
            result.add(null);
        }
        for (Map.Entry entry : updateSequence.entrySet()) {
            result.set((Integer)entry.getValue(), (IModel)entry.getKey());
        }
        return result;
    }

    private static <M extends IModel> int followImporting(M model, Map<M, List<M>> using, Map<M, Integer> sequence, int start, Set<M> done) {
        if (!done.contains(model)) {
            done.add(model);
            List<M> importing = using.get(model);
            if (null != importing) {
                for (int i = 0; i < importing.size(); ++i) {
                    IModel tmp = (IModel)importing.get(i);
                    if (tmp == model) continue;
                    sequence.put(tmp, start++);
                    start = ModelUpdateUtils.followImporting(tmp, using, sequence, start, done);
                }
            }
        }
        return start;
    }
}

