/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelRepository;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.basics.modelManagement.Version;

class ResolutionContext<M extends IModel> {
    private String modelName;
    private IModelRepository<M> repository;
    private M model;
    private ModelImport<M> toResolve;
    private URI modelUri;
    private List<ModelInfo<M>> inProgress;
    private IRestrictionEvaluationContext evaluationContext;
    private List<ModelImport<M>> conflicts;
    private boolean topLevel = true;

    public ResolutionContext(M model, URI modelUri, ResolutionContext<M> context) {
        this(model, modelUri, context.inProgress, context.repository, context.evaluationContext);
        this.topLevel = false;
    }

    public ResolutionContext(M model, URI modelUri, List<ModelInfo<M>> inProgress, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) {
        this.model = model;
        this.modelUri = modelUri;
        this.inProgress = inProgress;
        this.repository = repository;
        this.evaluationContext = evaluationContext;
    }

    public ResolutionContext(String modelName, URI baseUri, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) {
        this.modelName = modelName;
        this.modelUri = baseUri;
        this.inProgress = null;
        this.repository = repository;
        this.evaluationContext = evaluationContext;
    }

    public void setToResolve(ModelImport<M> toResolve) {
        this.toResolve = toResolve;
    }

    public ModelImport<M> getToResolve() {
        return this.toResolve;
    }

    public URI getModelURI() {
        return this.modelUri;
    }

    public M getModel() {
        return this.model;
    }

    public String getModelName() {
        return null != this.modelName ? this.modelName : this.model.getName();
    }

    public IModelRepository<M> getModelRepository() {
        return this.repository;
    }

    public List<String> getModelPaths() {
        ModelLocations.Location location;
        ArrayList<String> result = null;
        URI uri = this.getModelURI();
        if (null != uri && null != (location = this.repository.getLocationFor(uri)) && location.getDependentLocationCount() > 0) {
            result = new ArrayList<String>();
            HashSet<ModelLocations.Location> done = new HashSet<ModelLocations.Location>();
            this.enumerateDependent(location, result, done);
        }
        return result;
    }

    private void enumerateDependent(ModelLocations.Location location, List<String> results, Set<ModelLocations.Location> done) {
        if (!done.contains(location)) {
            if (!done.isEmpty()) {
                results.add(location.getLocation().toURI().toString());
            }
            done.add(location);
            for (int d = 0; d < location.getDependentLocationCount(); ++d) {
                this.enumerateDependent(location.getDependentLocation(d), results, done);
            }
        }
    }

    public boolean isLoop(ModelInfo<M> info) {
        boolean isLoop = false;
        if (null != this.inProgress) {
            int size = this.inProgress.size();
            for (int i = 0; !isLoop && i < size; ++i) {
                isLoop = Utils.matches(info, this.inProgress.get(i));
            }
        }
        return isLoop;
    }

    public IRestrictionEvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    private void lazyInitConflicts() {
        if (null == this.conflicts) {
            this.conflicts = new ArrayList<ModelImport<M>>();
        }
    }

    public void addConflicts(ResolutionContext<M> context) {
        if (null != context.conflicts) {
            this.lazyInitConflicts();
            ResolutionContext.addConflicts(this.conflicts, context.conflicts);
        }
    }

    public static <M extends IModel> List<ModelImport<M>> addConflicts(List<ModelImport<M>> conflicts, List<ModelImport<M>> toAdd) {
        if (null != toAdd) {
            if (null == conflicts) {
                conflicts = new ArrayList<ModelImport<M>>();
            }
            if (conflicts.isEmpty()) {
                conflicts.addAll(toAdd);
            } else {
                int c;
                HashSet<ModelImport<M>> present = new HashSet<ModelImport<M>>();
                int n = conflicts.size();
                for (c = 0; c < n; ++c) {
                    present.add(conflicts.get(c));
                }
                n = toAdd.size();
                for (c = 0; c < n; ++c) {
                    ModelImport<M> imp = toAdd.get(c);
                    if (present.contains(imp)) continue;
                    conflicts.add(imp);
                }
            }
        }
        return conflicts;
    }

    public void addConflict(ModelImport<M> conflict) {
        if (conflict.isConflict()) {
            this.lazyInitConflicts();
            this.conflicts.add(conflict);
        }
    }

    public ModelImport<M> getConflict(M model) throws RestrictionEvaluationException {
        return this.getConflict(model, new HashSet());
    }

    private ModelImport<M> getConflict(M model, Set<M> done) throws RestrictionEvaluationException {
        ModelImport<Object> result = null;
        if (null != model && !done.contains(model)) {
            done.add(model);
            result = this.getConflict(model.getName(), model.getVersion());
            for (int i = 0; null == result && i < model.getImportsCount(); ++i) {
                ModelImport<?> imp = model.getImport(i);
                if (imp.isConflict() || null == imp.getResolved()) continue;
                result = this.getConflict(imp.getResolved(), done);
            }
        }
        return result;
    }

    private ModelImport<M> getConflict(String modelName, Version version) throws RestrictionEvaluationException {
        ModelImport<M> result = null;
        if (null != this.conflicts) {
            int n = this.conflicts.size();
            for (int c = 0; null == result && c < n; ++c) {
                ModelImport<M> tmp = this.conflicts.get(c);
                if (!modelName.equals(tmp.getName()) || !tmp.evaluateRestrictions(this.evaluationContext, version)) continue;
                result = tmp;
            }
        }
        return result;
    }

    public boolean isConflict(ModelInfo<M> info) throws RestrictionEvaluationException {
        return null != this.getConflict(info.getName(), info.getVersion());
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public boolean considerLoading(boolean isTransitiveEnabled) {
        return this.topLevel || !this.topLevel && isTransitiveEnabled;
    }
}

