/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelData;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;

public class Utils {
    private Utils() {
    }

    public static boolean matches(IModelData data1, IModelData data2) {
        boolean result;
        boolean bl = result = data1.getName().equals(data2.getName()) && Utils.sameVersion(data1.getVersion(), data2.getVersion());
        if (data1 instanceof ModelInfo && data2 instanceof ModelInfo) {
            ModelInfo info1 = (ModelInfo)data1;
            ModelInfo info2 = (ModelInfo)data2;
            result = result && info1.getLocation().compareTo(info2.getLocation()) == 0;
        }
        return result;
    }

    static boolean sameVersion(Version version1, Version version2) {
        boolean result = null == version1 ? null == version2 : 0 == version1.compareTo(version2);
        return result;
    }

    static StringBuilder appendErrors(StringBuilder builder, String errors) {
        if (null != errors && errors.length() > 0) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(errors);
        }
        return builder;
    }

    static <M extends IModel> void collectModelInfo(Collection<List<VersionedModelInfos<M>>> availableModels, List<ModelInfo<M>> info, Map<M, ModelInfo<M>> modelInfoMap) {
        for (List<VersionedModelInfos<M>> vInfos : availableModels) {
            int vInfosSize = vInfos.size();
            for (int i = 0; i < vInfosSize; ++i) {
                VersionedModelInfos<int> vInfo = vInfos.get(i);
                for (int j = 0; j < vInfo.size(); ++j) {
                    ModelInfo<int> pi = vInfo.get(j);
                    if (null != info) {
                        info.add(pi);
                    }
                    if (null == modelInfoMap || !pi.isResolved()) continue;
                    modelInfoMap.put(pi.getResolved(), pi);
                }
            }
        }
    }

    static <M extends IModel> List<ModelInfo<M>> augmentByDepending(List<ModelInfo<M>> infos, List<ModelInfo<M>> allInfos, Map<M, ModelInfo<M>> modelInfoMap) {
        ArrayList<ModelInfo<M>> topLevel = new ArrayList<ModelInfo<M>>();
        topLevel.addAll(infos);
        HashSet<ModelInfo<M>> known = new HashSet<ModelInfo<M>>();
        known.addAll(infos);
        int lastSize = infos.size();
        while (true) {
            for (int j = 0; j < allInfos.size(); ++j) {
                ModelInfo<M> info = allInfos.get(j);
                if (!info.isResolved() || known.contains(info)) continue;
                boolean isInteresting = false;
                for (int p = 0; p < info.getImportsCount(); ++p) {
                    ModelInfo<M> resolved;
                    ModelImport<M> imp = info.getImport(p);
                    if (imp.isConflict() || !imp.isResolved() || !known.contains(resolved = modelInfoMap.get(imp.getResolved()))) continue;
                    isInteresting = true;
                    topLevel.remove(resolved);
                }
                if (!isInteresting) continue;
                known.add(info);
                infos.add(info);
                topLevel.add(info);
            }
            int curSize = infos.size();
            if (curSize == lastSize) break;
            lastSize = curSize;
        }
        return topLevel;
    }

    public static File toExistingFile(URI uri) {
        File result = null;
        if (null != uri && !(result = new File(uri)).exists()) {
            result = null;
        }
        return result;
    }

    static <M extends IModel> void enumerateImported(M model, Set<M> result, Set<M> deleteFrom) {
        if (null != model && !result.contains(model)) {
            result.add(model);
            if (null != deleteFrom) {
                deleteFrom.remove(model);
            }
            int iCount = model.getImportsCount();
            for (int i = 0; i < iCount; ++i) {
                Utils.enumerateImported(model.getImport(i).getResolved(), result, deleteFrom);
            }
        }
    }

    public static synchronized <M extends IModel> List<M> discoverImports(M mainModel) {
        ArrayList allModels = new ArrayList();
        Utils.findImportedModels(mainModel, allModels, new HashSet());
        return Utils.arrangeImportedModels(allModels);
    }

    private static <M extends IModel> void findImportedModels(M model, List<M> allModels, Set<M> done) {
        if (!done.contains(model)) {
            done.add(model);
            allModels.add(model);
            int n = model.getImportsCount();
            for (int i = 0; i < n; ++i) {
                Object importedModel = model.getImport(i).getResolved();
                if (null == importedModel) continue;
                Utils.findImportedModels(importedModel, allModels, done);
            }
        }
    }

    private static <M extends IModel> List<M> arrangeImportedModels(List<M> models) {
        ArrayList sequence = new ArrayList();
        HashSet done = new HashSet();
        for (int y = models.size() - 1; y >= 0; --y) {
            IModel project = (IModel)models.get(y);
            if (done.contains(project)) continue;
            Utils.arrangeImportedModels(project, done, sequence);
        }
        return sequence;
    }

    private static <M extends IModel> void arrangeImportedModels(M model, Set<M> alreadyVisited, List<M> sequence) {
        alreadyVisited.add(model);
        int n = model.getImportsCount();
        for (int i = 0; i < n; ++i) {
            Object importedProject = model.getImport(i).getResolved();
            if (null == importedProject || alreadyVisited.contains(importedProject)) continue;
            Utils.arrangeImportedModels(importedProject, alreadyVisited, sequence);
        }
        sequence.add(model);
    }
}

