/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;

public class VersionedModelInfos<M extends IModel> {
    private Version version;
    private List<ModelInfo<M>> infos = new ArrayList<ModelInfo<M>>();

    public VersionedModelInfos(Version version) {
        this.version = version;
    }

    public void add(ModelInfo<M> info) {
        ModelInfo<M> first;
        assert (null != info);
        if (!Version.equals(info.getVersion(), this.version)) {
            throw new IllegalArgumentException("versions do not match");
        }
        if (!this.infos.isEmpty() && !(first = this.infos.get(0)).getName().equals(info.getName())) {
            throw new IllegalArgumentException("names do not match");
        }
        for (int i = 0; i < this.infos.size(); ++i) {
            ModelInfo<M> tmp = this.infos.get(i);
            if (!VersionedModelInfos.isSame(tmp.getLocation(), info.getLocation()) || tmp.getLoader() != info.getLoader()) continue;
            throw new IllegalArgumentException("URI and loader match");
        }
        this.infos.add(info);
    }

    public static final boolean isSame(URI uri1, URI uri2) {
        return null == uri1 && uri1 == uri2 || null != uri1 && uri1.equals(uri2);
    }

    public ModelInfo<M> get(int index) {
        return this.infos.get(index);
    }

    public ModelInfo<M> get(M model) {
        ModelInfo<M> result = null;
        int size = this.infos.size();
        for (int i = 0; i < size; ++i) {
            ModelInfo<M> tmp = this.infos.get(i);
            if (tmp.getResolved() != model) continue;
            result = tmp;
        }
        return result;
    }

    public ModelInfo<M> get(URI uri) {
        ModelInfo<M> result = null;
        int size = this.infos.size();
        for (int i = 0; i < size; ++i) {
            ModelInfo<M> tmp = this.infos.get(i);
            if ((null != uri || tmp.getLocation() != uri) && (null == uri || !uri.equals(tmp.getLocation()))) continue;
            result = tmp;
        }
        return result;
    }

    public int size() {
        return this.infos.size();
    }

    public ModelInfo<M> remove(int index) {
        return this.infos.remove(index);
    }

    public void clear() {
        this.infos.clear();
    }

    public boolean remove(ModelInfo<M> info) {
        return this.infos.remove(info);
    }

    public Version getVersion() {
        return this.version;
    }

    public List<ModelInfo<M>> getByEqualUri(URI uri) {
        ArrayList<ModelInfo<M>> result = null;
        if (null != uri) {
            uri = uri.normalize();
            int size = this.infos.size();
            for (int i = 0; i < size; ++i) {
                ModelInfo<M> info = this.infos.get(i);
                if (null == info.getLocation() || !uri.equals(info.getLocation())) continue;
                if (null == result) {
                    result = new ArrayList<ModelInfo<M>>();
                }
                result.add(info);
            }
        }
        return result;
    }

    public ModelInfo<M> getByClosestUri(URI uri, List<String> modelPath) {
        return VersionedModelInfos.getByClosestUri(this.infos, uri, modelPath);
    }

    public static <M extends IModel> ModelInfo<M> getByClosestUri(List<ModelInfo<M>> infos, URI uri, List<String> modelPath) {
        ModelInfo<M> result = null;
        int size = infos.size();
        if (size > 0) {
            if (null == uri) {
                result = infos.get(0);
            } else {
                for (int i = 0; null == result && i < size; ++i) {
                    ModelInfo<M> info = infos.get(i);
                    if (!VersionedModelInfos.isSame(uri, info.getLocation())) continue;
                    result = info;
                }
                String searchUriText = VersionedModelInfos.pathWithoutLastFragment(uri.normalize());
                if (null == result) {
                    result = VersionedModelInfos.search(infos, searchUriText, modelPath);
                    if (null == result) {
                        result = VersionedModelInfos.searchOnParentLevel(infos, uri, modelPath);
                    }
                    if (null == result) {
                        result = VersionedModelInfos.searchOnSameFolderLevel(infos, uri, modelPath);
                    }
                }
                if (null != modelPath) {
                    for (int i = 0; null == result && i < size; ++i) {
                        ModelInfo<M> info = infos.get(i);
                        for (int m = 0; null == result && m < modelPath.size(); ++m) {
                            if (!VersionedModelInfos.isMatching(info.getLocation().toString(), modelPath.get(m), false)) continue;
                            result = info;
                        }
                    }
                }
            }
        }
        return result;
    }

    private static <M extends IModel> ModelInfo<M> search(List<ModelInfo<M>> infos, String searchUriText, List<String> modelPath) {
        ModelInfo<M> result = null;
        int matchLength = 0;
        for (int b = 0; null == result && 0 == matchLength && b < 2; ++b) {
            int size = infos.size();
            for (int i = 0; i < size; ++i) {
                ModelInfo<M> info = infos.get(i);
                URI infoUri = info.getLocation();
                if (null == infoUri) continue;
                String infoUriText = VersionedModelInfos.pathWithoutLastFragment(infoUri);
                if (!VersionedModelInfos.isMatching(searchUriText, modelPath, infoUriText, 0 == b)) continue;
                boolean isBestMatch = 0 == matchLength;
                isBestMatch |= 0 == b && infoUriText.length() < matchLength;
                if (!(isBestMatch |= 1 == b && infoUriText.length() > matchLength)) continue;
                result = infos.get(i);
                matchLength = infoUriText.length();
            }
        }
        return result;
    }

    private static <M extends IModel> ModelInfo<M> searchOnParentLevel(List<ModelInfo<M>> infos, URI uri, List<String> modelPath) {
        ModelInfo<M> result = null;
        if (VersionedModelInfos.isFileScheme(uri)) {
            File[] siblings;
            File uriFile = new File(uri);
            File uriParent = uriFile.getParentFile();
            File parent = uriParent;
            if (null != parent) {
                parent = parent.getName().startsWith(".") ? parent.getParentFile() : null;
            }
            if (null != parent && null != (siblings = parent.listFiles())) {
                for (int s = 0; null == result && s < siblings.length; ++s) {
                    File sibling = siblings[s];
                    if (!sibling.isDirectory() || sibling.equals(uriParent)) continue;
                    URI siblingUri = sibling.toURI().normalize();
                    result = VersionedModelInfos.search(infos, siblingUri.toString(), modelPath);
                }
            }
        }
        return result;
    }

    private static <M extends IModel> ModelInfo<M> searchOnSameFolderLevel(List<ModelInfo<M>> infos, URI uri, List<String> modelPath) {
        ModelInfo result = null;
        if (VersionedModelInfos.isFileScheme(uri)) {
            ArrayList<ModelInfo<M>> tmp = new ArrayList<ModelInfo<M>>();
            File uriFile = new File(uri).getParentFile();
            File searchFolder = uriFile.getParentFile();
            if (null != searchFolder) {
                File[] files = searchFolder.listFiles();
                for (int f = 0; null != files && f < files.length; ++f) {
                    String searchUriText;
                    ModelInfo<M> searchResult;
                    File file = files[f];
                    if (!file.isDirectory() || file.equals(uriFile) || null == (searchResult = VersionedModelInfos.search(infos, searchUriText = file.toURI().normalize().toString(), modelPath))) continue;
                    tmp.add(searchResult);
                }
            }
            if (1 == tmp.size()) {
                result = (ModelInfo)tmp.get(0);
            }
        }
        return result;
    }

    public static boolean isFileScheme(URI uri) {
        return "file".equals(uri.getScheme());
    }

    private static boolean isMatching(String searchUriText, List<String> modelPath, String importUriText, boolean contained) {
        boolean matches = VersionedModelInfos.isMatching(searchUriText, importUriText, contained);
        if (!matches && null != modelPath) {
            int size = modelPath.size();
            for (int p = 0; !matches && p < size; ++p) {
                matches = VersionedModelInfos.isMatching(searchUriText, modelPath.get(p), contained);
            }
        }
        return matches;
    }

    private static boolean isMatching(String searchUriText, String importUriText, boolean contained) {
        return contained ? importUriText.startsWith(searchUriText) : searchUriText.startsWith(importUriText);
    }

    public static String pathWithoutLastFragment(URI uri) {
        String uriText = uri.toString();
        int pos = uriText.lastIndexOf(47);
        if (pos > 0) {
            uriText = uriText.substring(0, pos + 1);
        }
        return uriText;
    }

    public List<ModelInfo<M>> toList(List<ModelInfo<M>> list) {
        if (null == list) {
            list = new ArrayList<ModelInfo<M>>();
        }
        for (int i = 0; i < this.infos.size(); ++i) {
            list.add(this.infos.get(i));
        }
        return list;
    }

    public String toString() {
        return this.version + " " + this.infos;
    }

    public ModelInfo<M> find(URI uri) {
        ModelInfo<M> result = null;
        if (null != uri) {
            int size = this.infos.size();
            for (int i = 0; null == result && i < size; ++i) {
                ModelInfo<M> info = this.infos.get(i);
                if (!uri.equals(info.getLocation())) continue;
                result = info;
            }
        }
        return result;
    }

    public static <M extends IModel> VersionedModelInfos<M> find(List<VersionedModelInfos<M>> infos, Version version) {
        VersionedModelInfos<M> result = null;
        if (null != infos) {
            for (int i = 0; null == result && i < infos.size(); ++i) {
                VersionedModelInfos<M> info = infos.get(i);
                if (!Version.equals(info.getVersion(), version)) continue;
                result = info;
            }
        }
        return result;
    }

    public static <M extends IModel> ModelInfo<M> maxVersion(List<ModelInfo<M>> list) {
        ModelInfo<M> result = null;
        if (null != list) {
            Version highest = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ModelInfo<M> tmp = list.get(i);
                Version tmpVersion = tmp.getVersion();
                if (null != result && Version.compare(tmpVersion, highest) <= 0) continue;
                result = tmp;
                highest = tmpVersion;
            }
        }
        return result;
    }
}

