/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.progress;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.progress.ProgressObserver;

public class BasicProgressObserver
extends ProgressObserver {
    private IProgressMonitor monitor;
    private Task parent;
    private List<Task> subtasks = new ArrayList<Task>();

    public void register(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void unregister(IProgressMonitor monitor) {
        if (this.monitor == monitor) {
            this.monitor = null;
        }
    }

    @Override
    public ProgressObserver.ITask registerTask(String task) {
        if (null == this.parent) {
            this.parent = new Task(task);
            return this.parent;
        }
        EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").warn("only one task supported");
        return this.parent;
    }

    @Override
    public ProgressObserver.ISubtask registerSubtask(String subtask) {
        Task result = new Task(subtask);
        this.subtasks.add(result);
        return result;
    }

    @Override
    public void notifyStart(ProgressObserver.ITask task, ProgressObserver.ISubtask subtask, int max) {
        if (NO_SUBTASK == subtask) {
            if (null == this.parent) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").warn("no parent registered");
            }
            if (this.parent.equals(task)) {
                this.monitor.setTaskName(this.parent.getName());
                this.parent.setMax(max);
                this.monitor.beginTask(this.parent.getName(), max);
            } else {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").warn("task not registered");
            }
        } else {
            int pos = this.subtasks.indexOf(subtask);
            if (pos >= 0) {
                Task t = this.subtasks.get(pos);
                t.setMax(max);
                this.monitor.subTask(t.getName());
            }
        }
    }

    @Override
    public void notifyProgress(ProgressObserver.ITask task, ProgressObserver.ISubtask subtask, int step, int max) {
        if (NO_SUBTASK == subtask || null == subtask) {
            if (null == this.parent) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").warn("no parent registered");
            }
            if (this.parent.equals(task)) {
                if (max > 0) {
                    this.parent.setMax(max);
                }
                this.monitor.worked(this.parent.setCurrent(step));
            }
        }
    }

    @Override
    public void notifyEnd(ProgressObserver.ITask task, ProgressObserver.ISubtask subtask) {
        if (NO_SUBTASK == subtask) {
            if (null == this.parent) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").warn("no task registered");
            }
            if (this.parent.equals(task)) {
                this.monitor.worked(this.parent.getRemainder());
                this.parent = null;
            }
        } else if (this.subtasks.contains(subtask)) {
            if (null == this.parent) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").warn("no task registered");
            }
            this.monitor.setTaskName(this.parent.getName());
            this.subtasks.remove(subtask);
        }
    }

    public static interface IProgressMonitor {
        public void setTaskName(String var1);

        public void beginTask(String var1, int var2);

        public void worked(int var1);

        public void subTask(String var1);
    }

    private static class Task
    implements ProgressObserver.ITask,
    ProgressObserver.ISubtask {
        private String name;
        private int max;
        private int current;

        public Task(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setMax(int max) {
            if (max > 0) {
                this.max = max;
            }
        }

        public int setCurrent(int current) {
            int result = current - this.current;
            this.current = current;
            return result;
        }

        public int getRemainder() {
            return this.max - this.current;
        }
    }
}

