/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.progress;

import net.ssehub.easy.basics.progress.ProgressObserver;

public class ObservableTask {
    private ProgressObserver.ITask task;
    private ProgressObserver.ISubtask subtask = ProgressObserver.NO_SUBTASK;
    private ProgressObserver observer;
    private int count = 0;

    public ObservableTask(String name, int max, ProgressObserver observer) {
        this(name, max, observer, null);
    }

    public ObservableTask(String name, int max, ProgressObserver observer, ProgressObserver.ITask task) {
        if (null == task) {
            this.task = observer.registerTask(name);
            this.subtask = ProgressObserver.NO_SUBTASK;
        } else {
            this.task = task;
            this.subtask = observer.registerSubtask(name);
        }
        this.observer = observer;
        this.observer.notifyStart(this.task, this.subtask, max);
    }

    public ObservableTask(String name, int max, ObservableTask parent) {
        this(name, max, parent.observer, parent.task);
    }

    public void notifyProgress() {
        this.notifyProgress(1);
    }

    public void notifyProgress(int steps) {
        this.count += steps;
        this.observer.notifyProgress(this.task, this.subtask, this.count);
    }

    public void notifyEnd() {
        this.observer.notifyEnd(this.task, this.subtask);
    }
}

