/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore;

import com.google.inject.Injector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.Environment;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.dslCore.EclipseResourceInitializer;
import net.ssehub.easy.dslCore.IResourceInitializer;
import net.ssehub.easy.dslCore.StandaloneInitializer;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.parser.BaseEPackageAccess;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.XtextResourceSet;

public abstract class ModelUtility<E extends EObject, R extends IModel>
implements IModelLoader<R> {
    private static IResourceInitializer resourceInitializer;
    private static final List<ModelUtility<?, ?>> SCHEDULED;
    private Map<Thread, Set<String>> beingLoaded = Collections.synchronizedMap(new HashMap());
    private XtextResourceSet resourceSet;
    private Injector injector;
    private Grammar grammar;

    protected ModelUtility() {
        if (null != resourceInitializer) {
            this.initializeAfterResourceInitializer();
        } else {
            SCHEDULED.add(this);
        }
    }

    public static void setResourceInitializer(IResourceInitializer initializer) {
        resourceInitializer = initializer;
        if (null != resourceInitializer) {
            for (int i = 0; i < SCHEDULED.size(); ++i) {
                SCHEDULED.get(i).initializeAfterResourceInitializer();
            }
            SCHEDULED.clear();
        }
    }

    protected abstract void initializeAfterResourceInitializer();

    public static IResourceInitializer getResourceInitializer() {
        return resourceInitializer;
    }

    public static final java.net.URI toNetUri(URI uri) throws URISyntaxException {
        java.net.URI result = null;
        if (null != resourceInitializer) {
            result = resourceInitializer.toNetUri(uri);
        }
        return result;
    }

    protected XtextResourceSet getResourceSet() {
        if (null == this.resourceSet) {
            this.resourceSet = ModelUtility.getResourceInitializer().createResourceSet(this.getInjector());
        }
        return this.resourceSet;
    }

    protected Injector getInjector() {
        return this.injector;
    }

    protected void setInjector(Injector injector) {
        this.injector = injector;
    }

    public TranslationResult<R> parse(File file) throws IOException {
        if (file.exists()) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            return this.parse(uri);
        }
        throw new FileNotFoundException(file.toString());
    }

    public TranslationResult<R> parse(URI uri) throws IOException {
        return this.parse(uri, null);
    }

    public abstract TranslationResult<R> parse(URI var1, ImportResolver<R> var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Grammar getGrammar() {
        if (null != this.grammar) return this.grammar;
        XtextResourceSet resourceSet = this.getResourceSet();
        XtextPackage.eINSTANCE.getClass();
        Class<ModelUtility> clazz = ModelUtility.class;
        synchronized (ModelUtility.class) {
            resourceSet.setClasspathURIContext((Object)this.getLanguageClassLoader());
            this.grammar = (Grammar)BaseEPackageAccess.loadGrammarFile((String)("classpath:/" + this.getLanguageName().replace('.', '/') + ".xtextbin"), (XtextResourceSet)resourceSet);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.grammar;
        }
    }

    protected abstract String getLanguageName();

    protected abstract ClassLoader getLanguageClassLoader();

    protected IParseResult parseFragment(String ruleName, String input) {
        AbstractRule rule;
        IParseResult result = null;
        Grammar grammar = this.getGrammar();
        if (null != grammar && (rule = GrammarUtil.findRuleForName((Grammar)grammar, (String)ruleName)) instanceof ParserRule) {
            IParser parser = (IParser)this.getInjector().getInstance(IParser.class);
            result = parser.parse((ParserRule)rule, (Reader)new StringReader(input));
        }
        return result;
    }

    public static StringBuilder append(StringBuilder builder, String text, String separator) {
        if (builder.length() > 0) {
            builder.append(separator);
        }
        builder.append(text);
        return builder;
    }

    public static StringBuilder appendWithNewLine(StringBuilder builder, String text) {
        return ModelUtility.append(builder, text, "\n");
    }

    protected E parse(URI uri, boolean unload, MessageReceiver receiver, Class<E> cls) throws IOException {
        XtextResourceSet resourceSet = this.getResourceSet();
        EObject result = null;
        Resource resource = resourceSet.getResource(uri, true);
        if (null == resource) {
            resource = resourceSet.createResource(uri);
        }
        resource.load(null);
        if (resource.isLoaded()) {
            boolean hasErrors = false;
            for (Resource.Diagnostic diag : resource.getErrors()) {
                if (null != receiver) {
                    receiver.error(diag);
                }
                hasErrors = true;
            }
            EObject rootObject = null;
            if (!hasErrors) {
                rootObject = (EObject)resource.getContents().get(0);
            }
            if (cls.isInstance(rootObject)) {
                result = (EObject)cls.cast(rootObject);
            }
        } else {
            throw new IOException("resource for uri '" + uri + "' not loaded");
        }
        if (unload) {
            resource.unload();
        }
        return (E)result;
    }

    protected boolean handles(File location) {
        return location.isFile() && location.getName().endsWith("." + this.getExtension());
    }

    @Override
    public void scan(File location, IModelLoader.IModelInfoHolder<R> holder) {
        if (this.handles(location) && !holder.isKnown(location.toURI(), this)) {
            try {
                List<ModelInfo<R>> info = this.obtainInfo(location);
                if (null != info) {
                    for (int i = 0; i < info.size(); ++i) {
                        holder.addResult(info.get(i));
                    }
                }
            }
            catch (IOException e) {
                holder.error(e.getMessage());
            }
        }
    }

    public List<ModelInfo<R>> obtainInfo(File file) throws IOException {
        if (file.exists()) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            return this.obtainInfo(uri);
        }
        throw new FileNotFoundException(file.toString());
    }

    public abstract List<ModelInfo<R>> obtainInfo(URI var1) throws IOException;

    @Override
    public IModelLoader.LoadResult<R> load(ModelInfo<R> info, ImportResolver<R> resolver) {
        List<R> models = null;
        List<IMessage> messages = null;
        if (null != info) {
            String location = info.getLocation().toString();
            Thread currentThread = Thread.currentThread();
            Set<String> beingLoadedInThread = this.beingLoaded.get(currentThread);
            if (null == beingLoadedInThread) {
                beingLoadedInThread = new HashSet<String>();
                this.beingLoaded.put(currentThread, beingLoadedInThread);
            }
            if (!beingLoadedInThread.contains(location)) {
                block5: {
                    beingLoadedInThread.add(location);
                    try {
                        TranslationResult<R> parseResult = this.parse(URI.createURI((String)location), resolver);
                        models = parseResult.getResultsList();
                        messages = parseResult.getMessageList();
                    }
                    catch (IOException e) {
                        if (null != messages) break block5;
                        messages = new ArrayList<Message>();
                        messages.add(new Message(e.getMessage(), Status.ERROR));
                    }
                }
                beingLoadedInThread.remove(location);
            }
        }
        return new IModelLoader.LoadResult(models, messages);
    }

    public abstract String getExtension();

    static {
        SCHEDULED = Collections.synchronizedList(new ArrayList());
        EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(ModelUtility.class, "net.ssehub.easy.dslCore");
        if (Environment.runsInEclipse()) {
            logger.info("Setting up Eclipse resource initializer");
            resourceInitializer = new EclipseResourceInitializer();
        } else {
            logger.info("Setting up Standalone resource initializer");
            resourceInitializer = new StandaloneInitializer();
        }
    }
}

