/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.MessageReceiver;

public class TranslationResult<R> {
    private MessageReceiver receiver;
    private List<R> results;

    public TranslationResult() {
        this(null, null);
    }

    public TranslationResult(List<R> results, MessageReceiver receiver) {
        this.receiver = receiver;
        this.results = results;
    }

    public int getMessageCount() {
        return null == this.receiver ? 0 : this.receiver.getMessageCount();
    }

    public int getErrorCount() {
        return null == this.receiver ? 0 : this.receiver.getErrorCount();
    }

    public Message getMessage(int index) {
        if (null == this.receiver) {
            throw new IndexOutOfBoundsException();
        }
        return this.receiver.getMessage(index);
    }

    public List<IMessage> getMessageList() {
        ArrayList<Message> result;
        int count = this.getMessageCount();
        if (count > 0) {
            result = new ArrayList<Message>(count);
            for (int m = 0; m < count; ++m) {
                result.add(this.getMessage(m));
            }
        } else {
            result = null;
        }
        return result;
    }

    public List<Message> getMessageListSpecific() {
        ArrayList<Message> result;
        int count = this.getMessageCount();
        if (count > 0) {
            result = new ArrayList<Message>(count);
            for (int m = 0; m < count; ++m) {
                result.add(this.getMessage(m));
            }
        } else {
            result = null;
        }
        return result;
    }

    public int getResultCount() {
        return null == this.results ? 0 : this.results.size();
    }

    public R getResult(int index) {
        if (null == this.results) {
            throw new IndexOutOfBoundsException();
        }
        return this.results.get(index);
    }

    public List<R> getResultsList() {
        ArrayList<R> result = new ArrayList<R>();
        if (null != this.results) {
            result.addAll(this.results);
        }
        return result;
    }
}

