/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore.validation;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.dslCore.ModelUtility;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.Message;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class ValidationUtils {
    public static final boolean PERFORM_XTEXT_VALIDATION = true;

    public static void processMessages(TranslationResult<?> result, BasicDiagnostic diagnostic) {
        for (int m = 0; m < result.getMessageCount(); ++m) {
            Message message = result.getMessage(m);
            diagnostic.add(ValidationUtils.processMessage(message));
        }
    }

    public static Diagnostic processMessage(Message message) {
        Severity severity;
        switch (message.getStatus()) {
            case ERROR: {
                severity = Severity.ERROR;
                break;
            }
            case WARNING: {
                severity = Severity.WARNING;
                break;
            }
            default: {
                severity = Severity.INFO;
            }
        }
        return ValidationUtils.createDiagnostic(severity, message.getDescription(), message.getCause(), message.getCausingFeature(), message.getCode(), null, new String[0]);
    }

    private static Diagnostic createDiagnostic(Severity severity, String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        int diagnosticSeverity = ValidationUtils.toDiagnosticSeverity(severity);
        FeatureBasedDiagnostic result = new FeatureBasedDiagnostic(diagnosticSeverity, message, object, feature, index, CheckType.NORMAL, code, issueData);
        return result;
    }

    private static int toDiagnosticSeverity(Severity severity) {
        int diagnosticSeverity = -1;
        switch (severity) {
            case ERROR: {
                diagnosticSeverity = 4;
                break;
            }
            case WARNING: {
                diagnosticSeverity = 2;
                break;
            }
            case INFO: {
                diagnosticSeverity = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow severity " + severity);
            }
        }
        return diagnosticSeverity;
    }

    private static final EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(ValidationUtils.class, "net.ssehub.easy.dslCore");
    }

    public static <R extends EObject, T> void checkModel(R unit, IModelValidationCallback<R, T> callback, boolean debug) {
        URI uri = null;
        if (null != unit.eResource() && null != unit.eResource().getURI()) {
            try {
                uri = ModelUtility.toNetUri(unit.eResource().getURI());
                if (!"file".equals(uri.getScheme())) {
                    uri = null;
                }
            }
            catch (URISyntaxException e) {
                ValidationUtils.getLogger().error("error translating '" + unit.eResource().getURI() + "' during validation" + e.getMessage());
            }
        }
        if (null != uri && callback.isValidationEnabled(uri)) {
            try {
                TranslationResult<T> result = callback.createModel(unit, uri);
                block8: for (int m = 0; m < result.getMessageCount(); ++m) {
                    Message message = result.getMessage(m);
                    switch (message.getStatus()) {
                        case ERROR: 
                        case UNSUPPORTED: {
                            callback.message(MessageType.ERROR, message.getDescription(), message.getCause(), message.getCausingFeature(), message.getCode());
                            continue block8;
                        }
                        case WARNING: {
                            callback.message(MessageType.WARNING, message.getDescription(), message.getCause(), message.getCausingFeature(), message.getCode());
                            continue block8;
                        }
                        default: {
                            callback.message(MessageType.INFO, message.getDescription(), message.getCause(), message.getCausingFeature(), message.getCode());
                        }
                    }
                }
                if (debug && 0 == result.getMessageCount()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PrintWriter pOut = new PrintWriter(out);
                    pOut.println(">TRANSLATED MODEL");
                    callback.print(result, pOut);
                    pOut.println("<TRANSLATED MODEL");
                    ValidationUtils.getLogger().info(out.toString());
                }
            }
            catch (Exception e) {
                String uriText = "";
                if (null != unit.eResource() && null != unit.eResource().getURI()) {
                    uriText = " " + unit.eResource().getURI().toString();
                }
                ValidationUtils.getLogger().error("while validating:" + e.getMessage() + uriText);
                e.printStackTrace();
            }
        }
    }

    public static interface IModelValidationCallback<R, T> {
        public boolean isValidationEnabled(URI var1);

        public TranslationResult<T> createModel(R var1, URI var2);

        public void message(MessageType var1, String var2, EObject var3, EStructuralFeature var4, int var5);

        public void print(TranslationResult<T> var1, Writer var2);
    }

    public static enum MessageType {
        ERROR,
        WARNING,
        INFO;

    }
}

