/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreatorNode;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

public class ArtifactFactory {
    private static final String DEFAULT_MODEL_BASE = "";
    private static final ArtifactCreatorNode ARTIFACT_CREATORS = new ArtifactCreatorNode(null);
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ArtifactFactory.class, "net.ssehub.easy.instantiation.core");
    private static final List<ArtifactModel> MODELS = new ArrayList<ArtifactModel>();

    private ArtifactFactory() {
    }

    private static void initialize() {
        if (MODELS.isEmpty()) {
            MODELS.add(new ArtifactModel(new File(DEFAULT_MODEL_BASE)));
        }
    }

    public static void clear() {
        MODELS.clear();
        ArtifactFactory.initialize();
    }

    public static ArtifactModel createArtifactModel(File base) {
        ArtifactFactory.initialize();
        ArtifactModel model = new ArtifactModel(base);
        MODELS.add(model);
        return model;
    }

    public static synchronized void release(ArtifactModel model) {
        ArtifactFactory.initialize();
        MODELS.remove(model);
        model.clear();
    }

    public static synchronized void clearDefaultModel() {
        ArtifactModel m;
        if (!MODELS.isEmpty() && DEFAULT_MODEL_BASE.equals((m = MODELS.get(0)).getBase().getPath())) {
            m.clear();
        }
    }

    public static IArtifact createArtifact(Object real) throws VilException {
        return ArtifactFactory.createArtifact(IArtifact.class, real, null);
    }

    public static <T extends IArtifact> T createArtifact(Class<T> kind, Object real, ArtifactModel model) throws VilException {
        IArtifact artifact;
        if (null == real) {
            throw new VilException("given object must not be null", 30005);
        }
        if (null == model) {
            model = ArtifactFactory.findModel(real);
        }
        if (null == (artifact = model.getArtifact(real))) {
            IArtifactCreator creator = ArtifactFactory.findCreator(kind, real);
            if (null == creator) {
                throw new VilException("no artifact creator handles " + real.getClass().getName() + " " + real, 30004);
            }
            artifact = creator.createArtifactInstance(real, model);
            model.register(real, artifact);
        } else {
            artifact.update();
        }
        try {
            return (T)((IArtifact)kind.cast(artifact));
        }
        catch (ClassCastException e) {
            throw new VilException("obtained artifact is of type " + artifact.getClass().getName() + " but " + kind.getName() + " is requested", 30006);
        }
    }

    public static IFileSystemArtifact createFileSystemArtifact(File real) throws VilException {
        return ArtifactFactory.createArtifact(IFileSystemArtifact.class, real, null);
    }

    static IFileSystemArtifact createFileSystemArtifact(File real, ArtifactModel model) throws VilException {
        return ArtifactFactory.createArtifact(IFileSystemArtifact.class, real, model);
    }

    static ArtifactCreator getCreator(Class<?> cls) {
        return cls.getAnnotation(ArtifactCreator.class);
    }

    public static String checkReplacement(Class<?> registered, Class<?> replacing) {
        String message = null;
        ArtifactCreator regCreator = ArtifactFactory.getCreator(registered);
        if (null != regCreator && null == ArtifactFactory.getCreator(replacing)) {
            message = "replacing class " + replacing.getName() + " must also be an artifact creator";
        }
        return message;
    }

    public static void registered(Class<?> cls) {
        ArtifactCreator creatorAnnotation = ArtifactFactory.getCreator(cls);
        if (null != creatorAnnotation) {
            Class<? extends IArtifactCreator> creatorClass = creatorAnnotation.value();
            if (null == creatorClass) {
                LOGGER.error("artifact creator class empty at class " + cls.getName());
            } else {
                try {
                    ArtifactFactory.addArtifactCreator(creatorClass.newInstance());
                }
                catch (InstantiationException e) {
                    LOGGER.error("cannot create artifact creator of class " + creatorClass.getName() + ": " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("cannot create artifact creator of class " + creatorClass.getName() + ": " + e.getMessage());
                }
            }
        }
    }

    public static void addArtifactCreator(IArtifactCreator creator) {
        String creatorArtifactName = creator.getArtifactClass().getSimpleName();
        Class<?> creatorClass = creator.getClass();
        ArtifactCreatorNode node = ARTIFACT_CREATORS;
        boolean replaced = false;
        do {
            ArtifactCreatorNode found = null;
            for (int c = 0; null == found && c < node.getChildrenCount(); ++c) {
                ArtifactCreatorNode tmp = node.getChild(c);
                if (!tmp.isMoreGeneralThan(creatorClass)) continue;
                if (tmp.getArtifactName().equals(creatorArtifactName)) {
                    tmp.setCreator(creator);
                    replaced = true;
                    break;
                }
                found = tmp;
            }
            if (replaced) continue;
            if (null == found) {
                node.addChild(creator);
                break;
            }
            node = found;
        } while (null != node && !replaced);
        if (null != node) {
            String parent = null == node.getCreator() ? "as root creator" : "below " + node.getCreator().getClass().getName();
            LOGGER.info((replaced ? "replaced" : "registered") + " " + creatorClass.getName() + " " + parent);
        } else {
            LOGGER.error("internal error: " + creatorClass.getName() + " not registered");
        }
    }

    private static IArtifactCreator findCreator(Class<? extends IArtifact> kind, Object real) {
        return ArtifactFactory.findCreator(kind, real, ARTIFACT_CREATORS, null).getCreator();
    }

    private static ArtifactCreatorNode findCreator(Class<? extends IArtifact> kind, Object real, ArtifactCreatorNode node, ArtifactCreatorNode actualResult) {
        ArtifactCreatorNode candidateResult = node;
        for (int c = 0; c < node.getChildrenCount(); ++c) {
            ArtifactCreatorNode tmp = node.getChild(c);
            boolean handles = tmp.handlesArtifact(kind, real);
            if (!handles && !tmp.subtreeMayHandle(kind)) continue;
            ArtifactCreatorNode tmpResult = ArtifactFactory.findCreator(kind, real, tmp, actualResult);
            if (!handles && tmpResult == tmp) {
                tmpResult = null;
            }
            if (null == tmpResult) continue;
            candidateResult = tmpResult;
        }
        if (null != candidateResult) {
            if (null != actualResult && null != actualResult.getCreator()) {
                LOGGER.warn(candidateResult.getCreatorClassName() + " is another handling creator for " + real.getClass().getName() + "in addition to " + actualResult.getCreatorClassName());
            } else {
                actualResult = candidateResult;
            }
        }
        return actualResult;
    }

    private static void configureArtifactCreators(ArtifactCreatorNode node, Properties properties, List<Message> messages) {
        node.configure(properties, messages);
        for (int c = 0; c < node.getChildrenCount(); ++c) {
            ArtifactFactory.configureArtifactCreators(node.getChild(c), properties, messages);
        }
    }

    public static List<Message> configureArtifactCreators(Properties properties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArtifactFactory.configureArtifactCreators(ARTIFACT_CREATORS, properties, messages);
        return messages;
    }

    public static synchronized Set<FileArtifact> selectByType(Path path, Class<?> type, boolean byKind, boolean negate) {
        ArtifactFactory.initialize();
        LinkedList<FileArtifact> result = new LinkedList<FileArtifact>();
        for (int m = MODELS.size() - 1; m >= 0; --m) {
            MODELS.get(m).selectByType(path, type, result, byKind, negate);
        }
        return new ListSet<FileArtifact>(result, type);
    }

    public static synchronized ArtifactModel findModel(Object real) {
        ArtifactFactory.initialize();
        if (real instanceof String) {
            real = new File(real.toString()).getAbsoluteFile();
        }
        ArtifactModel result = null;
        int maxPrio = 0;
        for (int m = MODELS.size() - 1; null == result && m >= 0; --m) {
            ArtifactModel model = MODELS.get(m);
            int prio = model.handles(real);
            if (prio <= 0 || null != result && prio <= maxPrio) continue;
            result = model;
            maxPrio = prio;
        }
        if (null == result) {
            result = MODELS.get(0);
        }
        return result;
    }

    static ArtifactModel getDefaultArtifactModel() {
        ArtifactFactory.initialize();
        return MODELS.get(0);
    }
}

