/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.FolderArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.ProjectSettings;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SettingsInitializerRegistry;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class ArtifactModel {
    private File base;
    private String basePath;
    private TreeMap<String, IFileSystemArtifact> fileArtifacts = new TreeMap();
    private TreeMap<Object, IArtifact> otherArtifacts = new TreeMap();
    private Map<ProjectSettings, Object> settings;
    private Map<String, Path> pathCache = new HashMap<String, Path>();

    ArtifactModel(File base) {
        this.base = base;
        this.basePath = PathUtils.normalize(base.getAbsolutePath());
        if (!this.basePath.endsWith("/")) {
            this.basePath = this.basePath + "/";
        }
        this.settings = SettingsInitializerRegistry.initializeSettings(base);
    }

    public File getBase() {
        return this.base;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void scanAll(ProgressObserver observer) throws VilException {
        if (null != this.base) {
            ProgressObserver.ITask task = observer.registerTask("creating complete artifact model for " + this.base.getAbsolutePath());
            int count = 0;
            if (ProgressObserver.NO_OBSERVER != observer) {
                count = this.scanAll(this.base, 0, null, null, null);
            }
            observer.notifyProgress(task, 0, count);
            ArrayList<VilException> errors = new ArrayList<VilException>();
            this.scanAll(this.base, 0, observer, task, errors);
            observer.notifyEnd(task);
            if (errors.size() > 0) {
                throw new VilException(errors);
            }
        }
    }

    private int scanAll(File location, int count, ProgressObserver observer, ProgressObserver.ITask task, List<VilException> errors) {
        if (null != location) {
            if (location.isDirectory()) {
                File[] files = location.listFiles();
                if (null != files) {
                    for (int f = 0; f < files.length; ++f) {
                        count = this.scanAll(files[f], count, observer, task, errors);
                    }
                }
            } else {
                if (null != observer && null != errors) {
                    try {
                        ArtifactFactory.createFileSystemArtifact(location, this);
                    }
                    catch (VilException e) {
                        errors.add(e);
                    }
                    if (null != task) {
                        observer.notifyProgress(task, count);
                    }
                }
                ++count;
            }
        }
        return count;
    }

    public Set<FolderArtifact> selectAllFolders() {
        ArrayList<FolderArtifact> result = new ArrayList<FolderArtifact>();
        for (IFileSystemArtifact artifact : this.fileArtifacts.values()) {
            if (!FolderArtifact.class.isInstance(artifact)) continue;
            result.add((FolderArtifact)artifact);
        }
        return new ListSet<FolderArtifact>(result, FolderArtifact.class);
    }

    public Set<FileArtifact> selectByType(Class<?> type, boolean negate) {
        ArrayList<FileArtifact> result = new ArrayList<FileArtifact>();
        this.selectByType(null, type, result, false, negate);
        return new ListSet<FileArtifact>(result, type);
    }

    public Set<FileArtifact> selectByKind(Class<?> type, boolean negate) {
        ArrayList<FileArtifact> result = new ArrayList<FileArtifact>();
        this.selectByType(null, type, result, true, negate);
        return new ListSet<FileArtifact>(result, type);
    }

    public Set<FileArtifact> selectByName(String name) {
        Pattern pattern;
        ArrayList<FileArtifact> result = new ArrayList<FileArtifact>();
        try {
            pattern = Pattern.compile(name);
        }
        catch (PatternSyntaxException e) {
            pattern = null;
        }
        this.selectByName(pattern, name, result);
        return new ListSet<FileArtifact>(result, FileArtifact.class);
    }

    void selectByName(Pattern pattern, String name, List<FileArtifact> result) {
        for (IFileSystemArtifact artifact : this.fileArtifacts.values()) {
            if (!(artifact instanceof FileArtifact)) continue;
            try {
                String aName = artifact.getPath().getPath();
                boolean ok = null == pattern ? aName.equals(name) : pattern.matcher(aName).matches();
                if (!ok) continue;
                result.add((FileArtifact)artifact);
            }
            catch (VilException vilException) {}
        }
    }

    void selectByType(Path path, Class<?> type, List<FileArtifact> result, boolean byKind, boolean negate) {
        if (null == type) {
            type = FileArtifact.class;
        }
        if (null == type || FileArtifact.class.isAssignableFrom(type)) {
            for (IFileSystemArtifact artifact : this.fileArtifacts.values()) {
                if (null != type && !ArtifactModel.isOfType(type, artifact, byKind, negate) || !ArtifactModel.matchesPath(path, artifact)) continue;
                result.add((FileArtifact)artifact);
            }
        }
    }

    private static boolean isOfType(Class<?> type, IFileSystemArtifact artifact, boolean byKind, boolean negate) {
        boolean result;
        if (byKind) {
            result = type.isInstance(artifact);
        } else {
            boolean bl = result = null != artifact && type == artifact.getClass();
        }
        if (negate) {
            result = !result;
        }
        return result;
    }

    private static boolean matchesPath(Path path, IFileSystemArtifact artifact) {
        boolean match;
        if (null == path) {
            match = true;
        } else {
            try {
                match = path.matches(artifact.getPath());
            }
            catch (VilException e) {
                match = false;
            }
        }
        return match;
    }

    boolean register(Object real, IArtifact artifact) {
        boolean result = false;
        if (null == this.base) {
            result = true;
        } else {
            if (artifact instanceof IFileSystemArtifact && real instanceof File) {
                this.fileArtifacts.put(this.makeRelativeFile((File)real), (IFileSystemArtifact)artifact);
            } else {
                this.otherArtifacts.put(real, artifact);
            }
            result = true;
        }
        return result;
    }

    String makeRelativeFile(File file) {
        return this.makeRelative(file.getAbsolutePath());
    }

    String makeRelative(File file) {
        return this.makeRelative(file.getAbsolutePath());
    }

    String makeRelative(String path) {
        String parentPath;
        String tmp = PathUtils.normalize(path);
        if (tmp.startsWith(parentPath = this.getBasePath())) {
            tmp = tmp.substring(parentPath.length());
        }
        return tmp;
    }

    static String makeRelative(String path, ArtifactModel model) {
        String tmp = null == model ? PathUtils.normalize(path) : model.makeRelative(path);
        return tmp;
    }

    static String makeRelative(File file, ArtifactModel model) {
        return ArtifactModel.makeRelative(file.getAbsolutePath(), model);
    }

    IArtifact getArtifact(Object real) {
        IArtifact result = real instanceof File ? (IArtifact)this.fileArtifacts.get(this.makeRelativeFile((File)real)) : (real instanceof Comparable ? this.otherArtifacts.get(real) : null);
        return result;
    }

    int handles(Object real) {
        int result = 0;
        if (real instanceof File) {
            File file = (File)real;
            String absFile = PathUtils.normalize(file.getAbsolutePath());
            if (absFile.startsWith(this.basePath)) {
                result = this.basePath.length();
            }
        } else {
            result = this.basePath.length();
        }
        return result;
    }

    synchronized void delete(File path) {
        String key = this.makeRelativeFile(path);
        this.fileArtifacts.remove(key);
        this.pathCache.remove(key);
    }

    private String getPathKey(Path path) {
        return this.makeRelativeFile(path.getAbsolutePath());
    }

    synchronized void discardPath(Path path) {
        this.pathCache.remove(this.getPathKey(path));
    }

    synchronized Path getPathFromCache(String pathKey) {
        return this.pathCache.get(pathKey);
    }

    synchronized void registerPath(Path path) {
        String key = this.getPathKey(path);
        Path known = this.pathCache.get(key);
        if (null == known) {
            this.pathCache.put(key, path);
        }
    }

    synchronized void beforeRename(IFileSystemArtifact artifact) throws VilException {
        this.delete(artifact.getPath());
    }

    synchronized void afterRename(IFileSystemArtifact artifact) throws VilException {
        ArrayList<VilException> errors = new ArrayList<VilException>();
        this.scanAll(artifact.getPath().getAbsolutePath(), 0, ProgressObserver.NO_OBSERVER, null, errors);
    }

    synchronized void beforeRename(Path path) {
        this.pathCache.remove(this.getPathKey(path));
    }

    synchronized void afterRename(Path path) {
        this.registerPath(path);
    }

    synchronized void delete(Path path) {
        if (FileUtils.isFile(path.getPath())) {
            this.fileArtifacts.remove(path.getPath());
        } else if (path.isPattern()) {
            String pattern = path.getPath();
            Iterator<String> iter = this.fileArtifacts.keySet().iterator();
            while (iter.hasNext()) {
                String pathKey = iter.next();
                if (!SelectorUtils.matchPath((String)pattern, (String)pathKey)) continue;
                this.pathCache.remove(pathKey);
                iter.remove();
            }
        } else {
            String sPath = path.getPath();
            if (!sPath.endsWith("/")) {
                sPath = sPath + "/";
            }
            Iterator<String> iter = this.fileArtifacts.keySet().iterator();
            while (iter.hasNext()) {
                String pathKey = iter.next();
                if (!pathKey.startsWith(sPath)) continue;
                this.pathCache.remove(pathKey);
                iter.remove();
            }
        }
        this.pathCache.remove(this.getPathKey(path));
    }

    void clear() {
        ArrayList<IFileSystemArtifact> files = new ArrayList<IFileSystemArtifact>(this.fileArtifacts.size());
        files.addAll(this.fileArtifacts.values());
        for (IFileSystemArtifact fa : files) {
            if (!fa.isTemporary()) continue;
            try {
                fa.delete();
            }
            catch (VilException vilException) {}
        }
        this.fileArtifacts.clear();
        this.otherArtifacts.clear();
        this.pathCache.clear();
    }

    public void setSettings(ProjectSettings key, Object object) {
        this.settings.put(key, object);
    }

    public Object getSettings(ProjectSettings key) {
        return this.settings.get(key);
    }
}

