/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.CompositeArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.DefaultFileArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileSystemArtifactOperations;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.FolderArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

@ArtifactCreator(value=DefaultFileArtifactCreator.class)
public class FileArtifact
extends CompositeArtifact
implements IFileSystemArtifact,
IActualValueProvider {
    @DefaultValue
    public static final FileArtifact DEFAULT = new FileArtifact();
    private Path path;
    private boolean isTemporary;

    FileArtifact() {
    }

    protected FileArtifact(File file, ArtifactModel model) {
        this.path = Path.createInstance(file, model);
    }

    protected FileArtifact(Path path, ArtifactModel model) {
        this.path = path.getArtifactModel() != model ? Path.createInstance(path.getPath(), model) : path;
    }

    public static FileArtifact create() throws VilException {
        try {
            File file = File.createTempFile("fileArtifact", "vil");
            file.deleteOnExit();
            FileArtifact result = ArtifactFactory.createArtifact(FileArtifact.class, file, null);
            result.isTemporary = true;
            return result;
        }
        catch (IOException e) {
            throw new VilException(e, 50001);
        }
    }

    @Override
    @Invisible
    public boolean isTemporary() {
        return this.isTemporary && this.getPath().isTemporary();
    }

    @Override
    @OperationMeta(storeArtifactsBefore=true)
    public void delete() throws VilException {
        this.path.delete();
    }

    @Invisible
    public ArtifactModel getArtifactModel() {
        return this.path.getArtifactModel();
    }

    @Override
    public String getName() throws VilException {
        return this.path.getName();
    }

    public String getPlainName() throws VilException {
        String name = this.getName();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public String getPathSegments() {
        return this.path.getPathSegments();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    @OperationMeta(storeArtifactsBefore=true)
    public void rename(String name) throws VilException {
        this.path.getArtifactModel().beforeRename(this);
        this.path = this.path.rename(name);
        this.path.getArtifactModel().afterRename(this);
    }

    @Override
    public void accept(IArtifactVisitor visitor) {
        visitor.visitFileArtifact(this);
    }

    @Override
    @OperationMeta(returnGenerics={IFileSystemArtifact.class}, storeArtifactsBefore=true)
    public Set<IFileSystemArtifact> move(IFileSystemArtifact target) throws VilException {
        return new ListSet<IFileSystemArtifact>(FileUtils.move(this, target), IFileSystemArtifact.class);
    }

    @Override
    @OperationMeta(returnGenerics={IFileSystemArtifact.class}, storeArtifactsBefore=true)
    public Set<IFileSystemArtifact> copy(IFileSystemArtifact target) throws VilException {
        return new ListSet<IFileSystemArtifact>(FileUtils.copy(this, target), IFileSystemArtifact.class);
    }

    @Override
    @Invisible
    public Set<? extends FragmentArtifact> selectAll() {
        return ArraySet.empty(FragmentArtifact.class);
    }

    @Override
    protected Text createText() throws VilException {
        return new Text(this.path.getAbsolutePath(), true);
    }

    @Override
    protected Binary createBinary() throws VilException {
        return new Binary(this.path.getAbsolutePath(), true);
    }

    public Path substituteExtension(String extension) throws VilException {
        return this.getPath();
    }

    @Invisible
    @Conversion
    public static FileArtifact convert(String val) throws VilException {
        Path path = Path.convert(val);
        return FileArtifact.convert(path);
    }

    @Invisible
    @Conversion
    public static FileArtifact convert(IFileSystemArtifact val) {
        FileArtifact convertedValue = null;
        if (val instanceof FileArtifact) {
            convertedValue = (FileArtifact)val;
        }
        return convertedValue;
    }

    @Invisible
    @Conversion
    public static Path convert(FileArtifact val) throws VilException {
        return val.getPath();
    }

    @Invisible
    @Conversion
    public static FileArtifact convert(Path path) throws VilException {
        return ArtifactFactory.createArtifact(FileArtifact.class, path.getAbsolutePath(), path.getArtifactModel());
    }

    @Override
    public long lastModification() {
        return this.path.lastModification();
    }

    @Override
    public boolean exists() {
        return this.path.exists();
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        String result = null != comparator && comparator.inTracer() && this.isTemporary() ? "<temp>" : this.getPath().getPath();
        return result;
    }

    @Override
    public void store() throws VilException {
        if (this.getRepresentationChanged(true)) {
            File file = this.path.getAbsolutePath();
            Text text = this.getTextInstance();
            Binary binary = this.getBinaryInstance();
            if (null != text) {
                file.getParentFile().mkdirs();
                PrintWriter out = null;
                try {
                    out = new PrintWriter(new FileWriter(file));
                    text.write(out);
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new VilException(e, 50001);
                }
            }
            if (null != binary) {
                file.getParentFile().mkdirs();
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    binary.write(out);
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new VilException(e, 50001);
                }
            }
        }
    }

    @Override
    public Object determineActualValue(Object object) {
        FolderArtifact folder;
        Object result = object;
        if (object instanceof FolderArtifact && !(folder = (FolderArtifact)object).exists()) {
            Path path = folder.getPath();
            result = new FileArtifact(path, path.getArtifactModel());
        }
        return result;
    }

    @Override
    public void setExecutable(boolean ownerOnly) throws VilException {
        FileSystemArtifactOperations.setExecutable(this, ownerOnly);
    }
}

