/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    private FileUtils() {
    }

    static void delete(File file) throws VilException {
        block7: {
            if (file.exists()) {
                try {
                    if (FileUtils.isDirectory(file)) {
                        try {
                            org.apache.commons.io.FileUtils.deleteDirectory((File)file);
                            break block7;
                        }
                        catch (IOException e) {
                            throw new VilException(e.getMessage(), 50001);
                        }
                    }
                    if (!file.delete()) {
                        throw new VilException("cannot delete " + file.getAbsolutePath(), 50001);
                    }
                }
                catch (SecurityException e) {
                    throw new VilException(e, 30001);
                }
            }
        }
    }

    static void rename(File file, File newFile) throws VilException {
        try {
            file.renameTo(newFile);
        }
        catch (SecurityException e) {
            throw new VilException(e, 30001);
        }
    }

    static void rename(File file, String name) throws VilException {
        FileUtils.rename(file, new File(name));
    }

    static List<IFileSystemArtifact> move(IFileSystemArtifact source, IFileSystemArtifact target) throws VilException {
        return FileUtils.copyOrMove(source, target, true);
    }

    static Set<IFileSystemArtifact> copyOrMove(Path source, IFileSystemArtifact target, boolean move) throws VilException {
        ArrayList<IFileSystemArtifact> result = new ArrayList<IFileSystemArtifact>();
        Path tp = target.getPath();
        File tf = tp.getAbsolutePath();
        if (!tf.exists() && FileUtils.isDirectory(tf)) {
            tf.mkdirs();
        }
        ArtifactModel tm = tp.getArtifactModel();
        for (FileArtifact f : source.selectAll()) {
            Path sp = f.getPath();
            File destinationFile = FileUtils.determineDestination(source, f, tf);
            ArtifactModel sm = move ? sp.getArtifactModel() : null;
            FileUtils.copyOrMove(sp.getAbsolutePath(), destinationFile, sm, tm, result);
        }
        return new ListSet<IFileSystemArtifact>(result, IFileSystemArtifact.class);
    }

    private static List<IFileSystemArtifact> copyOrMove(IFileSystemArtifact source, IFileSystemArtifact target, boolean move) throws VilException {
        ArrayList<IFileSystemArtifact> result = new ArrayList<IFileSystemArtifact>();
        Path sp = source.getPath();
        Path tp = target.getPath();
        if (!sp.isPattern() && !tp.isPattern()) {
            File sf = sp.getAbsolutePath();
            File tf = tp.getAbsolutePath();
            if (!tf.exists() && FileUtils.isDirectory(tf)) {
                tf.mkdirs();
            }
            ArtifactModel sm = move ? sp.getArtifactModel() : null;
            FileUtils.copyOrMove(sf, tf, sm, tp.getArtifactModel(), result);
        }
        return result;
    }

    private static void copyOrMove(File source, File target, ArtifactModel sourceModel, ArtifactModel targetModel, List<IFileSystemArtifact> artifacts) throws VilException {
        if (source.isDirectory()) {
            File[] files;
            if (target.isFile()) {
                target = target.getParentFile();
            }
            if (null != (files = source.listFiles())) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        target = new File(target, f.getName());
                        target.mkdir();
                    }
                    FileUtils.copyOrMove(f, target, sourceModel, targetModel, artifacts);
                }
            }
        } else {
            boolean move;
            boolean bl = move = null != sourceModel;
            if (move) {
                sourceModel.delete(source);
            }
            try {
                if (target.isDirectory()) {
                    if (move) {
                        org.apache.commons.io.FileUtils.moveFileToDirectory((File)source, (File)target, (boolean)true);
                    } else {
                        org.apache.commons.io.FileUtils.copyFileToDirectory((File)source, (File)target, (boolean)false);
                    }
                    target = new File(target, source.getName());
                } else if (move) {
                    org.apache.commons.io.FileUtils.moveFile((File)source, (File)target);
                } else {
                    org.apache.commons.io.FileUtils.copyFile((File)source, (File)target, (boolean)false);
                }
            }
            catch (IOException e) {
                throw new VilException(e, 50001);
            }
            IFileSystemArtifact artifact = ArtifactFactory.createArtifact(IFileSystemArtifact.class, target, targetModel);
            if (null != artifacts) {
                artifacts.add(artifact);
            }
        }
    }

    static List<IFileSystemArtifact> copy(IFileSystemArtifact source, IFileSystemArtifact target) throws VilException {
        return FileUtils.copyOrMove(source, target, false);
    }

    public static boolean isFile(String path) {
        int lastDotPos;
        boolean isFile = true;
        int lastSepPos = (path = FilenameUtils.normalize((String)path, (boolean)true)).lastIndexOf(47);
        isFile = lastSepPos == path.length() - 1 ? false : (lastDotPos = path.lastIndexOf(46)) >= 0 && lastDotPos > lastSepPos;
        return isFile;
    }

    public static boolean isFile(File file) {
        boolean isFile = !file.exists() ? FileUtils.isFile(file.getAbsolutePath()) : file.isFile();
        return isFile;
    }

    public static boolean isDirectory(File file) {
        boolean isDirectory = !file.exists() ? !FileUtils.isFile(file.getAbsolutePath()) : file.isDirectory();
        return isDirectory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends IArtifact> void scan(File location, ArtifactModel model, long timestamp, ScanResult<T> result, Class<T> type) {
        if (null == location) return;
        if (location.isDirectory()) {
            File[] files = location.listFiles();
            if (null == files) return;
            for (int f = 0; f < files.length; ++f) {
                FileUtils.scan(files[f], model, timestamp, result, type);
            }
            return;
        } else {
            if (PathUtils.normalizeTime(location) < timestamp) return;
            try {
                T artifact = ArtifactFactory.createArtifact(type, location, model);
                if (null == result || null == ((ScanResult)result).result) return;
                ((ScanResult)result).result.add(artifact);
                return;
            }
            catch (VilException e) {
                if (null == result || null == ((ScanResult)result).errors) return;
                ((ScanResult)result).errors.add(e);
            }
        }
    }

    public static File getTempDirectory() {
        return org.apache.commons.io.FileUtils.getTempDirectory();
    }

    private static File determineDestination(Path sourcePath, FileArtifact sourceArtefakt, File targetFile) {
        String srcFile = sourceArtefakt.getPath().getPath();
        String relativeFile = sourcePath.getArtifactModel().makeRelative(srcFile);
        String relativeDir = sourcePath.getArtifactModel().makeRelative(sourcePath.getAbsolutePath());
        String[] segmentsDir = relativeDir.split("/");
        String[] segmentsFile = relativeFile.split("/");
        boolean constantPart = true;
        int variableSegment = 0;
        int end = Math.min(segmentsDir.length, segmentsFile.length);
        for (int i = 0; i < end && constantPart; ++i) {
            if (segmentsDir[i].equals(segmentsFile[i])) {
                ++variableSegment;
                continue;
            }
            constantPart = false;
        }
        StringBuffer variablePart = new StringBuffer();
        for (int i = variableSegment; i < segmentsFile.length; ++i) {
            variablePart.append(segmentsFile[i]);
            variablePart.append("/");
        }
        return new File(targetFile, variablePart.toString());
    }

    public static class ScanResult<T extends IArtifact> {
        private List<T> result;
        private List<VilException> errors;

        public ScanResult(List<T> result) {
            this(result, new ArrayList<VilException>());
        }

        public ScanResult(List<T> result, List<VilException> errors) {
            this.result = result;
            this.errors = errors;
        }

        public void checkForException() throws VilException {
            if (null != this.errors && !this.errors.isEmpty()) {
                throw new VilException(this.errors);
            }
        }
    }
}

