/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.FolderArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.JavaPath;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class Path
implements IVilType,
IStringValueProvider {
    public static final String SEPARATOR = "/";
    @DefaultValue
    public static final Path DUMMY = new Path("", null);
    private String path;
    private ArtifactModel model;

    protected Path(String path, ArtifactModel model) {
        this.model = model;
        this.path = ArtifactModel.makeRelative(path, model);
    }

    @Invisible
    public static Path createInstance(Path path, ArtifactModel model) {
        return Path.lookupOrCreate(path.getPath(), model);
    }

    @Invisible
    public static Path createInstance(String path, ArtifactModel model) {
        return Path.lookupOrCreate(path, model);
    }

    @Invisible
    public static Path createInstance(File file, ArtifactModel model) {
        return Path.lookupOrCreate(file.getAbsolutePath(), model);
    }

    private static Path lookupOrCreate(String path, ArtifactModel model) {
        String relPath;
        ArtifactModel qModel = null == model ? ArtifactFactory.getDefaultArtifactModel() : model;
        Path result = qModel.getPathFromCache(relPath = ArtifactModel.makeRelative(path, model));
        if (null == result) {
            result = new Path(path, model);
            if (null != model) {
                model.registerPath(result);
            }
        }
        return result;
    }

    @Invisible
    public ArtifactModel getArtifactModel() {
        return this.model;
    }

    public static Path create(String path) throws VilException {
        return Path.createInstance(path, ArtifactFactory.findModel(path));
    }

    public String getPath() {
        return this.path;
    }

    @Invisible(inherit=true)
    public File getAbsolutePath() {
        File result = null != this.model ? this.getAbsolutePath(new File(this.model.getBasePath())) : new File("");
        return result;
    }

    public Path getParent() {
        Path result = this;
        File f = new File(this.path);
        File parent = f.getParentFile();
        if (null != parent) {
            result = Path.createInstance(parent, ArtifactFactory.findModel(parent));
        }
        return result;
    }

    private File getAbsolutePath(File base) {
        File result = new File(this.path);
        if (!result.isAbsolute() && null != base) {
            result = new File(base, this.path);
        }
        return result.getAbsoluteFile();
    }

    public boolean isPattern() {
        return PathUtils.isPattern(this.path);
    }

    public JavaPath toJavaPath() throws VilException {
        return new JavaPath(this);
    }

    public JavaPath toJavaPath(String prefixRegEx) throws VilException {
        return new JavaPath(this, prefixRegEx);
    }

    public String toOSPath() {
        return FilenameUtils.separatorsToSystem((String)this.path);
    }

    public String toAbsoluteOSPath() throws VilException {
        return FilenameUtils.separatorsToSystem((String)this.getAbsolutePath().getPath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteAll() throws VilException {
        if (this.isPattern()) {
            Set<FileArtifact> all = this.selectAll();
            if (null == all) return;
            for (FileArtifact f : all) {
                f.delete();
            }
            return;
        } else {
            try {
                File file = this.getAbsolutePath();
                if (file.isFile()) return;
                org.apache.commons.io.FileUtils.cleanDirectory((File)file);
                return;
            }
            catch (IOException e) {
                throw new VilException(e, 50001);
            }
        }
    }

    public void mkdir() throws VilException {
        if (this.isPattern()) {
            throw new VilException("cannot create a directory from the pattern '" + this.path + "'", 50001);
        }
        this.getAbsolutePath().mkdirs();
        ArtifactFactory.createArtifact(this.getAbsolutePath());
    }

    @Invisible
    @Conversion
    public static Path convert(String val) {
        return Path.createInstance(val, ArtifactFactory.findModel(val));
    }

    @Invisible
    @Conversion
    public static IFileSystemArtifact convert(Path path) throws VilException {
        IActualValueProvider result = path.getAbsolutePath().isFile() ? FileArtifact.convert(path) : FolderArtifact.convert(path);
        return result;
    }

    @Invisible
    public boolean matches(Path path) {
        boolean result = path.isPattern() ? (this.isPattern() ? false : Path.match(path, this, false)) : Path.match(this, path, !this.isPattern());
        return result;
    }

    private static boolean match(Path pattern, Path path, boolean prefix) {
        String sPattern = PathUtils.normalize(pattern.getAbsolutePath().getAbsolutePath());
        String sPath = PathUtils.normalize(path.getAbsolutePath().getAbsolutePath());
        boolean result = prefix ? sPath.startsWith(sPattern) : SelectorUtils.matchPath((String)sPattern, (String)sPath);
        return result;
    }

    @OperationMeta(name={"selectByKind", "typeSelect"}, returnGenerics={FileArtifact.class})
    public Set<FileArtifact> selectByType(Class<?> type) {
        return ArtifactFactory.selectByType(this, type, false, false);
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> selectByKind(Class<?> type) {
        return ArtifactFactory.selectByType(this, type, true, false);
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> typeReject(Class<?> type) {
        return ArtifactFactory.selectByType(this, type, true, true);
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> selectAll() {
        LinkedList<FileArtifact> result = new LinkedList<FileArtifact>();
        this.model.selectByType(this, null, result, true, false);
        return new ListSet<FileArtifact>(result, FileArtifact.class);
    }

    @OperationMeta(name={"+"}, opType=OperationType.INFIX)
    public static String concat(Path path, String string) {
        return PathUtils.normalize(path.getAbsolutePath()) + string;
    }

    @OperationMeta(name={"+"}, opType=OperationType.INFIX)
    public static String concat(String string, Path path) {
        return string + PathUtils.normalize(path.getAbsolutePath());
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        String result = DUMMY == this ? "" : PathUtils.normalize(this.getAbsolutePath().getAbsolutePath());
        return result;
    }

    public String toString() {
        return PathUtils.normalize(this.getAbsolutePath().getAbsolutePath());
    }

    @Invisible(inherit=true)
    public long lastModification() {
        long result;
        try {
            result = this.getAbsolutePath().lastModified();
        }
        catch (SecurityException e) {
            result = 0L;
        }
        return result;
    }

    public boolean exists() {
        boolean exists = this.isPattern() ? false : this.getAbsolutePath().exists();
        return exists;
    }

    public void delete() throws VilException {
        this.model.delete(this);
        if (this.isPattern()) {
            Set<FileArtifact> all = this.selectAll();
            if (null != all) {
                for (FileArtifact f : all) {
                    f.delete();
                }
            }
        } else {
            FileUtils.delete(this.getAbsolutePath());
        }
    }

    public String getName() throws VilException {
        String result = this.isPattern() ? this.path : this.getAbsolutePath().getName();
        return result;
    }

    public String getPathSegments() {
        int pos = this.path.lastIndexOf(47);
        String result = pos > 0 ? this.path.substring(0, pos) : null;
        return result;
    }

    public Path rename(String name) throws VilException {
        if (null != this.model) {
            this.model.beforeRename(this);
        }
        Path result = this;
        File file = new File(name);
        if (!file.isAbsolute()) {
            file = this.getAbsolutePath().getParentFile();
            file = null == file ? new File(this.model.getBase(), name) : new File(file, name);
        }
        FileUtils.rename(this.getAbsolutePath(), file);
        ArtifactModel model = ArtifactFactory.findModel(file);
        if (null != model) {
            this.model = model;
        }
        this.path = ArtifactModel.makeRelative(file.getAbsolutePath(), model);
        if (null != this.model) {
            this.model.afterRename(this);
        }
        return result;
    }

    @Invisible
    public boolean isTemporary() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        String tmpN = PathUtils.normalize(tmp);
        String pathN = PathUtils.normalize(this.getAbsolutePath());
        return pathN.startsWith(tmpN);
    }

    public Set<IFileSystemArtifact> copy(IFileSystemArtifact target) throws VilException {
        return FileUtils.copyOrMove(this, target, false);
    }

    public Set<IFileSystemArtifact> move(IFileSystemArtifact target) throws VilException {
        return FileUtils.copyOrMove(this, target, true);
    }
}

