/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.representation;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactChangedListener;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.AbstractArtifactRepresentation;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import org.apache.commons.io.FileUtils;

public class Text
extends AbstractArtifactRepresentation
implements IArtifactChangedListener,
IStringValueProvider {
    public static final Text CONSTANT_EMPTY = new Text(false);
    private String text;
    private File file;

    public Text(boolean modifiable) {
        super(modifiable);
        this.text = "";
    }

    public Text(File file, boolean modifiable) throws VilException {
        super(modifiable);
        this.file = file;
        this.updateContents();
    }

    public Text(String text, boolean modifiable) throws VilException {
        super(modifiable);
        this.text = text;
    }

    @Override
    public void updateContents() throws VilException {
        if (null != this.file && this.file.exists()) {
            try {
                this.text = FileUtils.readFileToString((File)this.file);
            }
            catch (IOException e) {
                throw new VilException(e, 50001);
            }
        } else {
            this.text = "";
        }
    }

    @Override
    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public Text substitute(String regex, String replacement) throws VilException {
        if (this.isModifiable()) {
            this.text = this.text.replaceAll(regex, replacement);
            this.triggerArtifactChanged();
        }
        return this;
    }

    public boolean matches(String regex) throws VilException {
        try {
            Pattern pattern = Pattern.compile(regex, 32);
            return pattern.matcher(this.text).matches();
        }
        catch (PatternSyntaxException e) {
            throw new VilException(e.getMessage(), 30009);
        }
    }

    public Text replace(String search, String replacement) throws VilException {
        if (this.isModifiable()) {
            this.text = this.text.replace(search, replacement);
            this.triggerArtifactChanged();
        }
        return this;
    }

    public Text append(String text) throws VilException {
        if (this.isModifiable()) {
            this.text = this.text + text;
            this.triggerArtifactChanged();
        }
        return this;
    }

    public Text prepend(String text) throws VilException {
        if (this.isModifiable()) {
            this.text = text + this.text;
            this.triggerArtifactChanged();
        }
        return this;
    }

    public Text append(Text text) throws VilException {
        if (this.isModifiable()) {
            this.text = this.text + text.text;
            this.triggerArtifactChanged();
        }
        return this;
    }

    public Text prepend(Text text) throws VilException {
        if (this.isModifiable()) {
            this.text = text.text + this.text;
            this.triggerArtifactChanged();
        }
        return this;
    }

    public Text insert(int index, Text insertion) throws VilException {
        return this.insert(index, insertion.text);
    }

    public Text insert(int index, String insertion) throws VilException {
        if (this.isModifiable() && index <= this.text.length()) {
            String before = this.text.substring(0, index);
            String after = this.text.substring(index, this.text.length());
            this.text = before + insertion + after;
            this.triggerArtifactChanged();
        }
        return this;
    }

    public int indexOf(Text search) {
        return this.indexOf(search.text);
    }

    public int indexOf(String search) {
        int index = this.text.indexOf(search);
        if (index == -1) {
            index = this.indexOfRegex(search);
        }
        return index;
    }

    private int indexOfRegex(String regex) {
        Matcher matcher;
        int index = -1;
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            pattern = null;
        }
        if (pattern != null && (matcher = pattern.matcher(this.text)) != null && matcher.find()) {
            index = matcher.start();
        }
        return index;
    }

    public int indexOf(Text search, int fromIndex) {
        return this.indexOf(search.text, fromIndex);
    }

    public int indexOf(String search, int fromIndex) {
        int index = this.text.indexOf(search, fromIndex);
        if (index == -1) {
            index = this.indexOfRegex(search, fromIndex);
        }
        return index;
    }

    private int indexOfRegex(String regex, int fromIndex) {
        Matcher matcher;
        int index = -1;
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            pattern = null;
        }
        if (pattern != null && (matcher = pattern.matcher(this.text)) != null && matcher.find(fromIndex)) {
            index = matcher.start();
        }
        return index;
    }

    public Text remove(Text part) throws VilException {
        return this.remove(part.text);
    }

    public Text remove(String part) throws VilException {
        if (this.isModifiable()) {
            if (this.text.contains(part)) {
                String before = this.text.substring(0, this.indexOf(part));
                String after = this.text.substring(this.indexOf(part) + part.length(), this.text.length());
                this.text = before + after;
            } else {
                this.removeRegex(part);
            }
            this.triggerArtifactChanged();
        }
        return this;
    }

    private void removeRegex(String regex) {
        int regexMatchLength = this.getRegexMatchLength(regex);
        if (regexMatchLength > 0) {
            String before = this.text.substring(0, this.indexOf(regex));
            String after = this.text.substring(this.indexOf(regex) + regexMatchLength, this.text.length());
            this.text = before + after;
        }
    }

    private int getRegexMatchLength(String regex) {
        Matcher matcher;
        int regexMatchLength = -1;
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            pattern = null;
        }
        if (pattern != null && (matcher = pattern.matcher(this.text)) != null && matcher.find()) {
            regexMatchLength = matcher.end() - matcher.start();
        }
        return regexMatchLength;
    }

    public Text removeAll(Text part) throws VilException {
        return this.removeAll(part.text);
    }

    public Text removeAll(String part) throws VilException {
        Text result = this;
        if (this.isModifiable()) {
            while (this.text.contains(part) || this.containsRegex(part)) {
                result = this.remove(part);
            }
        }
        return result;
    }

    private boolean containsRegex(String regex) {
        Matcher matcher;
        boolean containtsRegex = false;
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            pattern = null;
        }
        if (pattern != null && (matcher = pattern.matcher(this.text)) != null) {
            containtsRegex = matcher.find();
        }
        return containtsRegex;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void artifactChanged(Object cause) throws VilException {
        this.updateContents();
    }

    public void setText(String text) {
        this.text = text;
        try {
            this.triggerArtifactChanged();
        }
        catch (VilException vilException) {
            // empty catch block
        }
    }

    @Invisible
    public void write(Writer out) throws IOException {
        out.append(this.text);
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "<text>";
    }
}

