/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.xml;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlElement;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class AttributeSynchronizer
extends DefaultHandler {
    private static final int INDEX_NODE = -1;
    private XmlNode iter;
    private Map<XmlNode, Integer> positions = new HashMap<XmlNode, Integer>();

    AttributeSynchronizer(XmlElement root) {
        this.iter = this.checkPositions(root);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (null != this.iter) {
            if (qName.equals(this.iter.getNameSafe())) {
                this.iter.sortAttributes(attributes);
                this.iter.synchronizeAttributeSequence();
            } else {
                this.iter = this.checkPositions(this.advanceIter(this.iter));
            }
        }
    }

    private XmlNode checkPositions(XmlNode node) {
        if (null != node && !this.positions.containsKey(node)) {
            this.positions.put(node, -1);
        }
        return node;
    }

    private XmlNode advanceIter(XmlNode current) {
        XmlNode next = this.checkPositions(current);
        if (null != current) {
            int pos = this.positions.get(current);
            if (-1 == pos) {
                if (current.getChildCount() > 0) {
                    this.positions.put(current, 0);
                    next = this.consumeNonXmlElements(current.getChild(0));
                } else {
                    this.positions.remove(current);
                    next = this.advanceIter(current.getParent());
                }
            } else if (pos + 1 < current.getChildCount()) {
                this.positions.put(current, ++pos);
                next = this.consumeNonXmlElements(current.getChild(pos));
            } else {
                this.positions.remove(current);
                next = this.advanceIter(current.getParent());
            }
        } else {
            next = null;
        }
        return next;
    }

    private XmlNode consumeNonXmlElements(XmlNode node) {
        XmlNode result = null != node && !(node instanceof XmlElement) ? this.advanceIter(node) : node;
        return result;
    }
}

