/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.xml;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.IXmlContainer;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PathUtils {
    public static final String SEPARATOR = "/";

    public static String normalize(String path) {
        if ((path = path.replace("//", SEPARATOR)).startsWith(SEPARATOR)) {
            path = path.substring(1);
        }
        if (path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static Set<XmlElement> selectByPath(IXmlContainer container, String path) throws VilException {
        Set<XmlElement> result;
        int pos = path.indexOf(47);
        if (pos > 0) {
            String name = path.substring(0, pos);
            String remainder = path.substring(pos + 1);
            Iterator elts = container.selectByName(name).iterator();
            ArrayList<XmlElement> tmp = new ArrayList<XmlElement>();
            while (elts.hasNext()) {
                XmlElement elt = (XmlElement)elts.next();
                Iterator iter = elt.selectByPath(remainder).iterator();
                while (iter.hasNext()) {
                    tmp.add((XmlElement)iter.next());
                }
            }
            result = new ListSet(tmp, XmlElement.class);
        } else {
            result = container.selectByName(path);
        }
        return result;
    }

    public static Set<XmlElement> selectByXPath(String path, Object root, IXmlContainer container) throws VilException {
        ListSet<XmlElement> result = null;
        try {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression expr = xpath.compile(path);
            NodeList nodes = (NodeList)expr.evaluate(root, XPathConstants.NODESET);
            ArrayList<XmlElement> tmp = new ArrayList<XmlElement>(nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodePath = "";
                Node par = node;
                while (null != par.getParentNode()) {
                    if (nodePath.length() > 0) {
                        nodePath = nodePath + SEPARATOR;
                    }
                    nodePath = nodePath + node.getNodeName();
                    par = par.getParentNode();
                }
                Set<XmlElement> nodeRes = PathUtils.selectByPath(container, nodePath);
                for (XmlElement elt : nodeRes) {
                    tmp.add(elt);
                }
            }
            result = new ListSet<XmlElement>(tmp, XmlElement.class);
        }
        catch (XPathExpressionException e) {
            throw new VilException(e.getMessage(), 50502);
        }
        return result;
    }
}

