/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.xml;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.IXmlContainer;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.PathUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlAttribute;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlComment;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlFileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlNode;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ParameterMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class XmlElement
extends XmlNode
implements IXmlContainer {
    private XmlNode[] nodes;
    private XmlAttribute[] attributes;
    private String name;

    XmlElement(XmlElement parent, String name, XmlAttribute[] attributes, Node node) {
        super(parent, node);
        this.name = name;
        this.attributes = attributes;
    }

    public static XmlElement create(XmlElement parent, String name, @ParameterMeta(name="contents") String contents) throws VilException {
        XmlElement newElement = null;
        if (null == parent) {
            throw new VilException("Can not append child from NULL element!", 30005);
        }
        try {
            Element newNode = parent.getNode().getOwnerDocument().createElement(name);
            parent.getNode().appendChild(newNode);
            newElement = new XmlElement(parent, name, null, newNode);
            parent.addChild(newElement);
            parent.synchronizeAttributeSequence();
        }
        catch (DOMException exc) {
            throw new VilException("Invalid character, name or ID!", 30003);
        }
        if (null != contents && contents.length() > 0) {
            newElement.setCdata(contents);
        }
        return newElement;
    }

    public static XmlElement create(XmlFileArtifact parent, String name, @ParameterMeta(name="contents") String contents) throws VilException {
        return XmlElement.create(parent.getRootElement(), name, contents);
    }

    public static XmlElement buildElement(XmlElement parent, String name, @ParameterMeta(name="contents") String contents) throws VilException {
        XmlElement.create(parent, name, contents);
        return parent;
    }

    public static XmlElement buildAttribute(XmlElement parent, String name, String value) throws VilException {
        XmlAttribute.create(parent, name, value);
        return parent;
    }

    public static XmlElement buildAttribute(XmlElement parent, String name, String value, boolean forceOverwrite) throws VilException {
        XmlAttribute.create(parent, name, value, forceOverwrite);
        return parent;
    }

    private Field findField(Class<?> cls, String name) {
        Field result = null;
        if (null != cls && Object.class != cls) {
            try {
                result = cls.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                result = this.findField(cls.getSuperclass(), name);
            }
        }
        return result;
    }

    @Override
    void sortAttributes(final Attributes att) {
        Arrays.sort(this.attributes, new Comparator<XmlAttribute>(){

            @Override
            public int compare(XmlAttribute o1, XmlAttribute o2) {
                int i1 = att.getIndex(o1.getNameSafe());
                int i2 = att.getIndex(o2.getNameSafe());
                return Integer.compare(i1, i2);
            }
        });
    }

    @Override
    void synchronizeAttributeSequence() {
        boolean synchronize;
        XmlFileArtifact artifact = this.getFile();
        boolean bl = synchronize = null != artifact ? artifact.synchronizeAttributeSequence() : true;
        if (synchronize && null != this.attributes && this.attributes.length > 1) {
            NamedNodeMap attr = this.getNode().getAttributes();
            Class<?> nnmClass = attr.getClass();
            Field fNodes = this.findField(nnmClass, "nodes");
            Object nnmNodes = null;
            if (null != fNodes) {
                fNodes.setAccessible(true);
                try {
                    nnmNodes = fNodes.get(attr);
                }
                catch (SecurityException e) {
                    this.logSequenceException("Security", e);
                }
                catch (IllegalArgumentException e) {
                    this.logSequenceException("Illegal argument", e);
                }
                catch (IllegalAccessException e) {
                    this.logSequenceException("Illegal access", e);
                }
            } else {
                this.logSequenceException("No nodes field", null);
            }
            if (nnmNodes instanceof List) {
                List lNodes = (List)nnmNodes;
                Collections.sort(lNodes, new NodeComparator(this.attributes));
            }
        }
    }

    private void logSequenceException(String text, Exception ex) {
        String name;
        try {
            name = this.getName();
        }
        catch (VilException e) {
            name = "?";
        }
        EASyLoggerFactory.INSTANCE.getLogger(XmlElement.class, "net.ssehub.easy.instantiation.core").error("Cannot change sequence of XML attributes for element " + name + ": " + text + (null == ex ? "" : " " + ex.getMessage()));
    }

    @Override
    void deleteChild(XmlNode child) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != child) continue;
            this.nodes[i] = null;
            XmlNode[] newElements = new XmlNode[this.nodes.length - 1];
            for (int j = 0; j < newElements.length; ++j) {
                newElements[j] = j < i ? this.nodes[j] : this.nodes[j + 1];
            }
            i = this.nodes.length;
            this.nodes = newElements;
            this.notifyChange();
        }
    }

    @Override
    public String getName() throws VilException {
        return this.name;
    }

    @Override
    String getNameSafe() {
        return this.name;
    }

    @Override
    public void rename(String name) throws VilException {
        int i;
        this.checkRoot();
        this.name = name;
        Element newNode = this.getNode().getOwnerDocument().createElement(name);
        newNode.setNodeValue(this.getNode().getNodeValue());
        if (this.getTextDirect() != null) {
            newNode.setTextContent(this.getNode().getTextContent());
        } else if (this.getCdataDirect() != null) {
            newNode.appendChild(this.getNode().getOwnerDocument().createCDATASection(this.getCdataDirect().getText()));
        }
        for (i = 0; i < this.nodes.length; ++i) {
            newNode.appendChild(this.nodes[i].getNode());
        }
        for (i = 0; i < this.attributes.length; ++i) {
            newNode.setAttribute(this.attributes[i].getName(), this.attributes[i].getValue());
        }
        this.getNode().getParentNode().insertBefore(newNode, this.getNode());
        this.getNode().getParentNode().removeChild(this.getNode());
        this.setNode(newNode);
        this.notifyChange();
    }

    @Override
    @OperationMeta(returnGenerics={FragmentArtifact.class})
    public Set<? extends FragmentArtifact> selectAll() throws VilException {
        return new ArraySet<XmlAttribute>(this.attributes, FragmentArtifact.class);
    }

    @Override
    public boolean exists() {
        boolean exists = true;
        try {
            this.checkValidity();
        }
        catch (VilException exc) {
            exists = false;
        }
        return exists;
    }

    @OperationMeta(returnGenerics={XmlAttribute.class})
    public Sequence<XmlAttribute> attributes() throws VilException {
        return new ArraySequence<XmlAttribute>(this.attributes, XmlAttribute.class);
    }

    @OperationMeta(returnGenerics={XmlNode.class})
    public Set<XmlNode> nodes() throws VilException {
        return new ArraySet<XmlNode>(this.nodes, XmlNode.class);
    }

    @OperationMeta(returnGenerics={XmlComment.class})
    public Sequence<XmlComment> comments() {
        return this.projectNodes(XmlComment.class);
    }

    @OperationMeta(returnGenerics={XmlElement.class})
    public Sequence<XmlElement> elements() throws VilException {
        return this.projectNodes(XmlElement.class);
    }

    private <T> Sequence<T> projectNodes(Class<? extends T> type) {
        ArrayList<T> elts = new ArrayList<T>();
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!type.isInstance(this.nodes[i])) continue;
            elts.add(type.cast(this.nodes[i]));
        }
        return new ListSequence(elts, type);
    }

    public XmlAttribute getAttribute(String name) throws VilException {
        XmlAttribute result = null;
        if (null != this.attributes) {
            Pattern pattern;
            ArrayList<VilException> caught = null;
            try {
                pattern = Pattern.compile(name);
            }
            catch (PatternSyntaxException e) {
                pattern = null;
            }
            for (int a = 0; null == result && a < this.attributes.length; ++a) {
                XmlAttribute attr = this.attributes[a];
                if (null == attr) continue;
                try {
                    String aName = attr.getName();
                    if (aName.equals(name)) {
                        result = attr;
                        continue;
                    }
                    if (null == pattern || !pattern.matcher(aName).matches()) continue;
                    result = attr;
                    continue;
                }
                catch (VilException e) {
                    if (null == caught) {
                        caught = new ArrayList<VilException>();
                    }
                    caught.add(e);
                }
            }
            if (null != caught && !caught.isEmpty()) {
                throw new VilException((List<VilException>)caught);
            }
        }
        return result;
    }

    public void setAttribute(String name, String value) throws VilException {
        this.checkRoot();
        if (null != this.attributes) {
            for (int a = 0; a < this.attributes.length; ++a) {
                String aName;
                XmlAttribute attr = this.attributes[a];
                if (null == attr || !(aName = attr.getName()).equals(name)) continue;
                attr.setValue(value);
                if (this.getNode().getNodeType() != 1) break;
                Element element = (Element)this.getNode();
                element.setAttribute(name, value);
                this.notifyChange();
                break;
            }
        }
    }

    @OperationMeta(returnGenerics={XmlAttribute.class})
    public Set<XmlAttribute> selectAttributeByRegex(String regEx) throws VilException {
        Pattern pattern;
        ArrayList<XmlAttribute> result = new ArrayList<XmlAttribute>();
        try {
            pattern = Pattern.compile(regEx);
        }
        catch (PatternSyntaxException e) {
            throw new VilException(e, 30002);
        }
        if (null != this.attributes) {
            for (int a = 0; a < this.attributes.length; ++a) {
                String aName;
                XmlAttribute attr = this.attributes[a];
                if (null == attr || !pattern.matcher(aName = attr.getName()).matches()) continue;
                result.add(attr);
            }
        }
        return new ListSet<XmlAttribute>(result, XmlAttribute.class);
    }

    @Override
    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByName(String name) throws VilException {
        return this.selectByName(name, true);
    }

    @Override
    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByPath(String path) throws VilException {
        return PathUtils.selectByPath(this, PathUtils.normalize(path));
    }

    @Override
    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByXPath(String path) throws VilException {
        return PathUtils.selectByXPath(path, this.getNode(), this);
    }

    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByName(String name, boolean caseSensitive) throws VilException {
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        if (caseSensitive) {
            if (this.name.equals(name)) {
                result.add(this);
            }
        } else if (this.name.equalsIgnoreCase(name)) {
            result.add(this);
        }
        if (null != this.nodes) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!(this.nodes[i] instanceof XmlElement)) continue;
                Iterator subIterator = ((XmlElement)this.nodes[i]).selectByName(name, caseSensitive).iterator();
                while (subIterator.hasNext()) {
                    result.add((XmlElement)subIterator.next());
                }
            }
        }
        return new ListSet<XmlElement>(result, XmlElement.class);
    }

    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByRegEx(String regEx) throws VilException {
        Pattern pattern;
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        try {
            pattern = Pattern.compile(regEx);
        }
        catch (PatternSyntaxException e) {
            throw new VilException(e, 30002);
        }
        if (pattern.matcher(this.getName()).matches()) {
            result.add(this);
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!(this.nodes[i] instanceof XmlElement)) continue;
            Iterator subIterator = ((XmlElement)this.nodes[i]).selectByRegEx(regEx).iterator();
            while (subIterator.hasNext()) {
                result.add((XmlElement)subIterator.next());
            }
        }
        return new ListSet<XmlElement>(result, XmlElement.class);
    }

    void deleteAttribute(XmlAttribute attribute) {
        if (null != this.attributes) {
            for (int a = 0; a < this.attributes.length; ++a) {
                if (this.attributes[a] != attribute) continue;
                try {
                    this.getNode().getAttributes().removeNamedItem(attribute.getName());
                }
                catch (DOMException e) {
                    this.getLogger().info(e.getMessage());
                }
                catch (VilException e) {
                    this.getLogger().info(e.getMessage());
                }
                this.attributes[a] = null;
                this.notifyChange();
                break;
            }
        }
    }

    void renameAttribute(XmlAttribute attribute, String name) throws VilException {
        if (null != this.attributes) {
            ArrayList<VilException> caught = null;
            boolean foundAttribute = false;
            boolean foundName = false;
            for (int a = 0; a < this.attributes.length; ++a) {
                XmlAttribute attr = this.attributes[a];
                foundAttribute |= attr == attribute;
                try {
                    foundName |= attr != attribute && attr.getName().equals(name);
                    continue;
                }
                catch (VilException e) {
                    if (null == caught) {
                        caught = new ArrayList<VilException>();
                    }
                    caught.add(e);
                }
            }
            if (foundAttribute && !foundName) {
                this.getNode().getAttributes().removeNamedItem(attribute.getName());
                Element element = (Element)this.getNode();
                element.setAttribute(name, attribute.getValue());
                attribute.setName(name);
                this.notifyChange(attribute);
            }
            if (null != caught && !caught.isEmpty()) {
                throw new VilException((List<VilException>)caught);
            }
        }
    }

    void setName(String name) {
        this.name = name;
    }

    void setNodes(XmlNode[] nodes) {
        this.nodes = nodes;
    }

    boolean hasChild(XmlElement child) {
        boolean has = false;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != child) continue;
            has = true;
            i = this.nodes.length;
        }
        return has;
    }

    void addChild(XmlNode child) throws VilException {
        if (null == child) {
            throw new VilException("NULL can not be added as a child of an XmlElement!", 30005);
        }
        XmlNode[] newElements = null != this.nodes ? new XmlNode[this.nodes.length + 1] : new XmlNode[1];
        for (int i = 0; i < newElements.length - 1; ++i) {
            newElements[i] = this.nodes[i];
        }
        newElements[newElements.length - 1] = child;
        this.nodes = newElements;
        this.notifyChange();
    }

    XmlElement appendChild(XmlElement child, Node childNode) throws VilException {
        if (null == child || null == childNode) {
            throw new VilException("NULL can not be added as a child of an XmlElement!", 30005);
        }
        this.insertElement(child, this.nodes[this.nodes.length - 1]);
        try {
            this.getNode().appendChild(childNode);
        }
        catch (DOMException exc) {
            throw new VilException("Unable to append a child from a " + this.getNode().getNodeName() + " Node!", 30003);
        }
        this.notifyChange();
        return child;
    }

    XmlAttribute addAttribute(String name, String value) throws VilException {
        return this.addAttribute(name, value, true);
    }

    XmlAttribute addAttribute(String name, String value, boolean forceOverwrite) throws VilException {
        XmlAttribute previousAtt = this.getAttribute(name);
        XmlAttribute newAtt = null;
        if (previousAtt == null) {
            XmlAttribute[] newAttributes = null != this.attributes ? new XmlAttribute[this.attributes.length + 1] : new XmlAttribute[1];
            for (int i = 0; i < newAttributes.length - 1; ++i) {
                newAttributes[i] = this.attributes[i];
            }
            newAttributes[newAttributes.length - 1] = newAtt = new XmlAttribute(this, name, value);
            this.attributes = newAttributes;
        } else {
            previousAtt.setValue(value);
            ((Element)this.getNode()).setAttribute(name, value);
            newAtt = previousAtt;
        }
        this.notifyChange();
        return newAtt;
    }

    private void insertElement(XmlNode elem, XmlNode previous) throws VilException {
        if (null == elem) {
            throw new VilException("Tried to insert NULL element as child!", 30005);
        }
        XmlNode[] newElements = null != this.nodes ? new XmlNode[this.nodes.length + 1] : new XmlNode[1];
        for (int i = 0; i < newElements.length - 1; ++i) {
            newElements[i] = this.nodes[i];
            if (null == previous || !newElements[i].equals(previous)) continue;
            newElements[i + 1] = elem;
            ++i;
        }
        if (null == previous) {
            newElements[newElements.length - 1] = elem;
        }
        this.nodes = newElements;
        this.notifyChange();
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "xmlElement \"" + this.name + "\"";
    }

    @Override
    int getChildCount() {
        return this.nodes == null ? 0 : this.nodes.length;
    }

    @Override
    XmlNode getChild(int index) {
        if (null == this.nodes) {
            throw new IndexOutOfBoundsException();
        }
        return this.nodes[index];
    }

    private EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core");
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private HashMap<String, Integer> pos = new HashMap();

        private NodeComparator(XmlAttribute[] attributes) {
            for (int a = 0; a < attributes.length; ++a) {
                try {
                    this.pos.put(attributes[a].getName(), a);
                    continue;
                }
                catch (VilException vilException) {
                    // empty catch block
                }
            }
        }

        @Override
        public int compare(Node o1, Node o2) {
            Integer p1 = this.pos.get(o1.getNodeName());
            Integer p2 = this.pos.get(o2.getNodeName());
            int result = p1 != null && this.pos != null ? Integer.compare(p1, p2) : 1;
            return result;
        }
    }
}

