/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.IArtifactRepresentation;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.AttributeSynchronizer;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.DefaultXmlFileArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.Dtd;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.DtdParser;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.IXmlContainer;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.PathUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlAttribute;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlComment;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlElement;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlNode;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.XmlRootElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@ArtifactCreator(value=DefaultXmlFileArtifactCreator.class)
public class XmlFileArtifact
extends FileArtifact
implements IXmlContainer {
    private XmlElement rootElement;
    private Document doc;
    private File file;
    private Dtd dtd;
    private boolean omitXmlDeclaration = false;
    private boolean omitXmlStandalone = true;
    private boolean synchronizeAttributeSequence = true;
    private int indentation = 4;
    private long lastModification = -1L;
    private long lastPersisted = -1L;
    private String encoding = null;

    XmlFileArtifact(File file, ArtifactModel model) throws VilException {
        super(file, model);
        this.file = file;
        this.initialize();
    }

    private void initialize() throws VilException {
        this.readDtd();
        this.load(this.file);
        if (null != this.doc) {
            XmlNode rt = this.build(this.doc.getDocumentElement(), null);
            if (rt instanceof XmlElement) {
                this.rootElement = (XmlElement)rt;
            }
            if (null != this.doc.getDocumentElement()) {
                this.cleanTree(this.doc.getDocumentElement());
            }
            this.synchronizeAttributes(this.file);
            this.lastPersisted = System.currentTimeMillis();
        }
    }

    public static FileArtifact create() throws VilException {
        try {
            File file = File.createTempFile("xmlFileArtifact", "vil");
            file.deleteOnExit();
            return ArtifactFactory.createArtifact(XmlFileArtifact.class, file, null);
        }
        catch (IOException e) {
            throw new VilException(e, 50001);
        }
    }

    @Override
    @OperationMeta(storeArtifactsBefore=true)
    public void delete() throws VilException {
        super.delete();
        this.doc = null;
        this.rootElement = null;
    }

    @Override
    public void artifactChanged(Object cause) throws VilException {
        boolean fromRepresentation = cause instanceof IArtifactRepresentation;
        if (fromRepresentation) {
            this.omitXmlDeclaration = true;
        }
        super.artifactChanged(cause);
        if (fromRepresentation) {
            try {
                FileOutputStream out = new FileOutputStream(this.file);
                PrintStream ps = new PrintStream(out);
                ps.print(this.getText().getText());
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            this.initialize();
        }
        this.lastModification = System.currentTimeMillis();
    }

    @Override
    public void store() throws VilException {
        if (this.getRepresentationChanged(true)) {
            this.writeToFile();
            this.lastPersisted = System.currentTimeMillis();
        }
    }

    @Override
    @OperationMeta(returnGenerics={FragmentArtifact.class})
    public Set<? extends FragmentArtifact> selectAll() {
        XmlElement[] elements = null;
        if (this.rootElement != null) {
            elements = new XmlElement[]{this.rootElement};
        }
        return new ArraySet<XmlElement>(elements, FragmentArtifact.class);
    }

    public XmlElement getRootElement() {
        return this.rootElement;
    }

    public XmlElement createRootElement(String name) throws VilException {
        if (null == this.rootElement) {
            if (null == this.doc) {
                try {
                    DocumentBuilder builder = this.getDocumentBuilderFactory().newDocumentBuilder();
                    this.doc = builder.newDocument();
                }
                catch (ParserConfigurationException exc) {
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
                    throw new VilException(this.file.getAbsolutePath() + ":" + exc.getMessage(), 30013);
                }
            }
            Element elt = this.doc.createElement(name);
            this.doc.appendChild(elt);
            this.rootElement = new XmlRootElement(this, null, name, new XmlAttribute[0], elt);
        }
        return this.rootElement;
    }

    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<? extends XmlElement> selectChilds() throws VilException {
        XmlElement[] elements = null;
        if (this.rootElement != null) {
            elements = new XmlElement[this.rootElement.selectAll().size()];
            Iterator iter = this.rootElement.elements().iterator();
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = (XmlElement)iter.next();
            }
        }
        return new ArraySet(elements, FragmentArtifact.class);
    }

    private void load(File file) throws VilException {
        if (file != null && file.length() > 0L) {
            try {
                DocumentBuilder builder = this.getDocumentBuilderFactory().newDocumentBuilder();
                this.doc = this.initFromDoc(builder.parse(file));
                this.pruneWhitespaces(this.doc.getChildNodes());
            }
            catch (ParserConfigurationException exc) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
                throw new VilException(file.getAbsolutePath() + ":" + exc.getMessage(), 30013);
            }
            catch (SAXException exc) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
                throw new VilException(file.getAbsolutePath() + ":" + exc.getMessage(), 30013);
            }
            catch (IOException exc) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
                throw new VilException(file.getAbsolutePath() + ":" + exc.getMessage(), 30013);
            }
        }
    }

    private Document initFromDoc(Document doc) {
        if (null != doc) {
            this.encoding = doc.getXmlEncoding();
        }
        return doc;
    }

    private void pruneWhitespaces(NodeList nodes) {
        int count = nodes.getLength() - 1;
        if (count > 1) {
            Node first = null;
            Node last = null;
            for (int n = 0; n <= count; ++n) {
                Node node = nodes.item(n);
                if (0 == n) {
                    first = this.toEmptyTextNode(node);
                } else if (count == n) {
                    last = this.toEmptyTextNode(node);
                }
                this.pruneWhitespaces(node.getChildNodes());
            }
            this.deleteNode(first);
            this.deleteNode(last);
        }
    }

    private void deleteNode(Node node) {
        if (null != node) {
            node.getParentNode().removeChild(node);
        }
    }

    private Node toEmptyTextNode(Node node) {
        Node result = null;
        if (null != node && 3 == node.getNodeType() && 0 == node.getTextContent().trim().length()) {
            result = node;
        }
        return result;
    }

    private XmlNode build(Node node, XmlElement parent) {
        ArrayList<Integer> childIndexes = new ArrayList<Integer>();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            short type = node.getChildNodes().item(i).getNodeType();
            if (type != 1 && type != 8) continue;
            childIndexes.add(i);
        }
        XmlNode result = null;
        if (null == parent) {
            if (node.getNodeType() == 1) {
                XmlAttribute[] attributes = this.createAttributes(node, null);
                result = this.fill(node, new XmlRootElement(this, parent, node.getNodeName(), attributes, node), childIndexes);
            }
        } else if (node.getNodeType() == 1) {
            XmlAttribute[] attributes = this.createAttributes(node, null);
            result = this.fill(node, new XmlElement(parent, node.getNodeName(), attributes, node), childIndexes);
        } else if (node.getNodeType() == 8) {
            result = this.fill(node, new XmlComment(parent, node));
        }
        return result;
    }

    private XmlElement fill(Node node, XmlElement element, List<Integer> childIndexes) {
        try {
            if (node.hasChildNodes()) {
                if (node.getFirstChild().getNodeType() == 4) {
                    element.setCdata(((CDATASection)node.getFirstChild()).getData());
                } else if (node.getFirstChild().getNodeType() == 3) {
                    String text = node.getFirstChild().getNodeValue().trim();
                    element.getText().setText(text);
                }
            }
        }
        catch (VilException e1) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(e1);
        }
        catch (DOMException e1) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(e1);
        }
        Iterator iter = null;
        try {
            iter = element.attributes().iterator();
        }
        catch (VilException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(e);
        }
        if (null != iter) {
            while (iter.hasNext()) {
                ((XmlAttribute)iter.next()).setParent(element);
            }
        }
        XmlNode[] nodes = new XmlNode[childIndexes.size()];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = this.build(node.getChildNodes().item(childIndexes.get(i)), element);
        }
        element.setNodes(nodes);
        return element;
    }

    private XmlComment fill(Node node, XmlComment element) {
        try {
            element.getText().setText(node.getNodeValue().trim());
        }
        catch (VilException e1) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(e1);
        }
        return element;
    }

    private List<String> getLineEndedComments() {
        ArrayList<String> lineEndedComments = new ArrayList<String>();
        LineNumberReader reader = null;
        try {
            String line;
            reader = new LineNumberReader(new FileReader(this.file));
            do {
                if (null == (line = reader.readLine()) || !line.endsWith("-->")) continue;
                lineEndedComments.add(line);
            } while (null != line);
            reader.close();
        }
        catch (IOException e) {
            IOUtils.closeQuietly(reader);
        }
        return lineEndedComments;
    }

    private void ensureLineEndedComments(List<String> lineEndedComments) {
        try {
            String sep = System.getProperty("line.separator");
            List lines = FileUtils.readLines((File)this.file);
            int c = 0;
            int l = 0;
            int lPos = 0;
            while (c < lineEndedComments.size() && l < lines.size()) {
                String comment;
                String line = (String)lines.get(l);
                int pos = line.indexOf(comment = lineEndedComments.get(c), lPos);
                if (pos >= 0) {
                    int ePos = pos + comment.length();
                    if (ePos < line.length()) {
                        int tmpPos = ePos;
                        while (ePos < line.length() && XmlFileArtifact.isLineEndChar(line.charAt(ePos))) {
                            ++ePos;
                        }
                        if (tmpPos == ePos) {
                            line = line.substring(0, ePos) + sep + line.substring(ePos);
                            lines.set(l, line);
                            lPos = ePos + sep.length();
                        }
                    }
                    ++c;
                    continue;
                }
                ++l;
                lPos = 0;
            }
            FileUtils.writeLines((File)this.file, (Collection)lines);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isLineEndChar(char ch) {
        return '\r' == ch || '\n' == ch;
    }

    private void writeToFile() throws VilException {
        Text text = null;
        boolean initializationNeeded = false;
        try {
            text = this.getText();
        }
        catch (VilException exc) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
        }
        if (null == this.doc && null != text && !text.getText().trim().isEmpty()) {
            try {
                DocumentBuilder builder = this.getDocumentBuilderFactory().newDocumentBuilder();
                InputStream in = IOUtils.toInputStream((String)text.getText());
                this.doc = this.initFromDoc(builder.parse(in));
                in.reset();
                this.synchronizeAttributes(in);
                in.close();
                initializationNeeded = true;
            }
            catch (ParserConfigurationException exc) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
                throw new VilException(this.file.getAbsolutePath() + ":" + exc.getMessage(), 30013);
            }
            catch (SAXException exc) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
                throw new VilException(this.file.getAbsolutePath() + ":" + exc.getMessage(), 30013);
            }
            catch (IOException exc) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
                throw new VilException(this.file.getAbsolutePath() + ":" + exc.getMessage(), 30013);
            }
        }
        if (null != this.doc) {
            List<String> lineEndedComments = this.getLineEndedComments();
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = null;
            result = new StreamResult(this.file);
            try {
                TransformerFactory transformerFactory = this.getTransformerFactory();
                Transformer transformer = transformerFactory.newTransformer();
                this.configureTransformer(transformer);
                transformer.transform(source, result);
            }
            catch (TransformerException exc) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(exc);
            }
            if (!lineEndedComments.isEmpty()) {
                this.ensureLineEndedComments(lineEndedComments);
            }
            if (this.dtd != null && this.dtd.getContent() != null && !this.dtd.getContent().isEmpty()) {
                try {
                    DtdParser.writeDtd(this.file, this.dtd);
                }
                catch (FileNotFoundException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(e);
                }
            }
        }
        if (initializationNeeded) {
            this.initialize();
        }
    }

    protected void configureTransformer(Transformer transformer) {
        if (null != this.encoding) {
            transformer.setOutputProperty("encoding", this.encoding);
        }
        if (this.indentation >= 0) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(this.indentation));
            transformer.setOutputProperty("indent", "yes");
        }
        transformer.setOutputProperty("indent", this.toYesNo(this.indentation >= 0));
        if (this.omitXmlDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("standalone", this.toYesNo(!this.omitXmlStandalone));
    }

    private String toYesNo(boolean yes) {
        return yes ? "yes" : "no";
    }

    private XmlAttribute[] createAttributes(Node node, XmlElement element) {
        XmlAttribute[] attributes;
        if (null != node.getAttributes()) {
            int amountOfAtt = node.getAttributes().getLength();
            attributes = new XmlAttribute[amountOfAtt];
            for (int i = 0; i < amountOfAtt; ++i) {
                attributes[i] = new XmlAttribute(element, node.getAttributes().item(i).getNodeName(), node.getAttributes().item(i).getNodeValue());
            }
        } else {
            attributes = null;
        }
        return attributes;
    }

    @Override
    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByName(String name) throws VilException {
        return this.rootElement.selectByName(name);
    }

    @Override
    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByPath(String path) throws VilException {
        return PathUtils.selectByPath(this, PathUtils.normalize(path));
    }

    @Override
    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByXPath(String path) throws VilException {
        return PathUtils.selectByXPath(path, this.doc, this);
    }

    @OperationMeta(returnGenerics={XmlElement.class})
    public Set<XmlElement> selectByRegEx(String regEx) throws VilException {
        if (this.rootElement == null) {
            throw new VilException("Root Element does not exist", 30003);
        }
        return this.rootElement.selectByRegEx(regEx);
    }

    @Override
    public void update() throws VilException {
        boolean update = true;
        File file = this.getPath().getAbsolutePath();
        if (null != file) {
            boolean bl = update = file.lastModified() > this.lastPersisted && this.lastModification <= this.lastPersisted;
        }
        if (update) {
            this.initialize();
        }
    }

    private void cleanTree(Node parent) {
        Node child = parent.getFirstChild();
        while (null != child) {
            Node nextChild = child.getNextSibling();
            if (3 == child.getNodeType() && !child.hasChildNodes() && child.getNodeValue().trim().isEmpty()) {
                parent.removeChild(child);
            }
            child = nextChild;
        }
    }

    private void readDtd() throws VilException {
        if (null != this.file && this.file.length() > 0L) {
            try {
                this.dtd = DtdParser.extractDTD(this.file);
            }
            catch (FileNotFoundException e) {
                throw new VilException("File not found: " + this.file.getAbsolutePath(), 30013);
            }
        }
    }

    @Invisible
    @Conversion
    public static FileArtifact convert(String val) throws VilException {
        Path path = Path.convert(val);
        return XmlFileArtifact.convert(path);
    }

    @Invisible
    @Conversion
    public static XmlFileArtifact convert(IFileSystemArtifact val) {
        XmlFileArtifact convertedValue = null;
        if (val instanceof XmlFileArtifact) {
            convertedValue = (XmlFileArtifact)val;
        }
        return convertedValue;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setXmlStandalone(boolean standalone) {
        if (null != this.doc) {
            this.doc.setXmlStandalone(standalone);
        }
    }

    public boolean getXmlStandalone() {
        return null == this.doc ? false : this.doc.getXmlStandalone();
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }

    public void setOmitXmlStandalone(boolean omitXmlStandalone) {
        this.omitXmlStandalone = omitXmlStandalone;
    }

    @Invisible
    public boolean synchronizeAttributeSequence() {
        return this.synchronizeAttributeSequence;
    }

    public void setSynchronizeAttributeSequence(boolean synchronizeAttributeSequence) {
        this.synchronizeAttributeSequence = synchronizeAttributeSequence;
    }

    protected TransformerFactory getTransformerFactory() {
        return new TransformerFactoryImpl();
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        return new DocumentBuilderFactoryImpl();
    }

    public void format() throws VilException {
        this.initialize();
        this.writeToFile();
        this.lastPersisted = System.currentTimeMillis();
    }

    private void synchronizeAttributes(InputStream stream) {
        if (this.synchronizeAttributeSequence && null != this.rootElement) {
            try {
                SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
                AttributeSynchronizer handler = new AttributeSynchronizer(this.rootElement);
                saxParser.parse(this.file, (DefaultHandler)handler);
            }
            catch (SAXException sAXException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void synchronizeAttributes(File file) {
        block3: {
            if (this.synchronizeAttributeSequence && file.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    this.synchronizeAttributes(in);
                    in.close();
                }
                catch (IOException e) {
                    if (null == in) break block3;
                    net.ssehub.easy.basics.io.FileUtils.closeQuietly(in);
                }
            }
        }
    }
}

