/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Utils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class AlternativeExpression
extends Expression {
    private Expression condition;
    private IRuleBlock ifPart;
    private IRuleBlock elsePart;
    private TypeDescriptor<?> type;

    AlternativeExpression() {
    }

    public AlternativeExpression(Expression condition, IRuleBlock ifPart, IRuleBlock elsePart) throws VilException {
        if (null == condition) {
            throw new VilException("no condition given", 70001);
        }
        if (null == ifPart) {
            throw new VilException("no if-part given", 70001);
        }
        this.condition = condition;
        this.ifPart = ifPart;
        this.elsePart = elsePart;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public IRuleBlock getIfPart() {
        return this.ifPart;
    }

    public IRuleBlock getElsePart() {
        return this.elsePart;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        if (null == this.type) {
            Expression elseExpr;
            Expression thenExpr = Utils.findLastExpression(this.ifPart);
            Expression expression = elseExpr = null == this.elsePart ? null : Utils.findLastExpression(this.elsePart);
            if (null == elseExpr) {
                this.type = null == thenExpr ? TypeRegistry.voidType() : thenExpr.inferType();
            } else if (null == thenExpr) {
                this.type = elseExpr.inferType();
            } else {
                TypeDescriptor<?> elseType;
                TypeDescriptor<?> thenType = thenExpr.inferType();
                if (thenType.isAssignableFrom(elseType = elseExpr.inferType())) {
                    this.type = thenType;
                } else if (elseType.isAssignableFrom(thenType)) {
                    this.type = elseType;
                } else {
                    throw new VilException("if given, both paths must lead to compatible types", 70001);
                }
            }
        }
        return this.type;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IVisitor ? ((IVisitor)((Object)visitor)).visitAlternativeExpression(this) : visitor.visitExpression(this);
        return result;
    }
}

