/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.net.URI;
import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.DefaultImportResolver;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VtlRule;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;

public class BuildLangImportResolver
extends DefaultImportResolver<Script> {
    @Override
    protected void cannotResolveImport(ModelImport<Script> imp, List<IMessage> messages, URI modelURI, IRestrictionEvaluationContext context) {
        try {
            Template template = (Template)TemplateModel.INSTANCE.resolve(imp.getName(), imp.getVersionRestriction(), modelURI, context);
            if (null != template && 2 == template.getParameterCount()) {
                Script tmpScript = new Script(template.getName());
                for (int d = 0; d < template.getDefCount(); ++d) {
                    Def def = template.getDef(d);
                    if (def.isProtected()) continue;
                    tmpScript.addRule(new VtlRule(def, tmpScript));
                }
                imp.setResolved(tmpScript);
            } else {
                super.cannotResolveImport(imp, messages, modelURI, context);
            }
        }
        catch (ModelManagementException e) {
            messages.add(new Message(e.getMessage(), Status.ERROR));
        }
    }
}

