/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangExecution;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;

class ExecutableRules {
    private List<AbstractRule> rules = new ArrayList<AbstractRule>();

    public void collect(Script script) {
        HashSet<Script> processed = new HashSet<Script>();
        HashSet<String> knownSignatures = new HashSet<String>();
        this.collect(script, false, processed, knownSignatures);
    }

    private void collect(Script script, boolean asParent, Set<Script> processed, Set<String> knownSignatures) {
        if (!processed.contains(script)) {
            processed.add(script);
            if (null != script.getParent()) {
                this.collect(script.getParent(), true, processed, knownSignatures);
            }
            for (int i = 0; i < script.getImportsCount(); ++i) {
                Script imp = (Script)script.getImport(i).getResolved();
                if (null == imp) continue;
                this.collect(imp, false, processed, knownSignatures);
            }
            for (int r = 0; r < script.getRuleCount(); ++r) {
                AbstractRule rule = script.getRule(r);
                String signature = rule.getSignature();
                if (asParent && knownSignatures.contains(signature)) continue;
                knownSignatures.add(signature);
                this.rules.add(rule);
            }
        }
    }

    public Object buildContributing(AbstractRuleMatchExpression expression, BuildlangExecution visitor) throws VilException {
        ArrayList<AbstractRule> contributing = new ArrayList<AbstractRule>();
        for (int r = 0; r < this.rules.size(); ++r) {
            AbstractRule candidate = this.rules.get(r);
            if (visitor.isOnStack(candidate)) continue;
            try {
                visitor.resolveMatches(candidate, Rule.Side.LHS);
            }
            catch (VilException vilException) {
                // empty catch block
            }
            for (int c = 0; c < candidate.getRuleConditionCount(Rule.Side.LHS); ++c) {
                AbstractRuleMatchExpression lhsEx = candidate.getRuleCondition(Rule.Side.LHS, c);
                if (!lhsEx.contributesTo(expression)) continue;
                contributing.add(candidate);
            }
        }
        for (int c = 0; c < contributing.size(); ++c) {
            ((AbstractRule)contributing.get(c)).accept(visitor);
        }
        Object value = expression.accept(visitor);
        assert (expression.inferType().isCollection());
        assert (value instanceof Collection);
        return value;
    }
}

